/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.substitutions;

import cc.redberry.core.combinatorics.IntCombinationPermutationGenerator;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.OutputPort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SumBijectionPort
implements OutputPort<BijectionContainer> {
    private List<Mapper> mappers;
    private int[] bijection;
    private boolean finished = false;
    private MapperSource source;

    public SumBijectionPort(Tensor from, Tensor to) {
        if (from.size() > to.size()) {
            this.finished = true;
            return;
        }
        this.mappers = new ArrayList<Mapper>();
        int j = 0;
        int fromBegin = 0;
        int fromSize = from.size();
        int toSize = to.size();
        int mainStretchFromCoord = -1;
        int mainStretchFromPointer = -1;
        int mainStretchFromLength = -1;
        int mainStretchToLength = Integer.MAX_VALUE;
        int maintStretchIndex = -1;
        int hash = from.get(0).hashCode();
        for (int i = 1; i <= fromSize; ++i) {
            if (i == fromSize || from.get(i).hashCode() != hash) {
                while (j < toSize && to.get(j).hashCode() < hash) {
                    ++j;
                }
                if (j == toSize || to.get(j).hashCode() > hash) {
                    this.finished = true;
                    break;
                }
                int toBegin = j;
                while (j < toSize && to.get(j).hashCode() == hash) {
                    ++j;
                }
                if (j - toBegin < i - fromBegin) {
                    this.finished = true;
                    break;
                }
                if (j - toBegin == 1) {
                    this.mappers.add(new SinglePairMapper(from.get(fromBegin), to.get(toBegin), toBegin));
                } else {
                    this.mappers.add(new StretchPairMapper(from.getRange(fromBegin, i), to.getRange(toBegin, j), toBegin));
                }
                if (j - toBegin < mainStretchToLength) {
                    mainStretchToLength = j - toBegin;
                    mainStretchFromLength = i - fromBegin;
                    mainStretchFromCoord = fromBegin;
                    mainStretchFromPointer = toBegin;
                    maintStretchIndex = this.mappers.size() - 1;
                }
                fromBegin = i;
            }
            if (i == fromSize) continue;
            hash = from.get(i).hashCode();
        }
        if (this.finished) {
            return;
        }
        this.source = mainStretchToLength == 1 ? new SinglePairSource(from.get(mainStretchFromCoord), to.get(mainStretchFromPointer), mainStretchFromPointer) : new StretchPairSource(from.getRange(mainStretchFromCoord, mainStretchFromCoord + mainStretchFromLength), to.getRange(mainStretchFromPointer, mainStretchFromPointer + mainStretchToLength), mainStretchFromPointer);
        this.mappers.set(maintStretchIndex, this.source);
        this.bijection = new int[from.size()];
    }

    @Override
    public BijectionContainer take() {
        Mapping buffer;
        if (this.finished) {
            return null;
        }
        ArrayList<int[]> bijections = new ArrayList<int[]>();
        int mappersSize = this.mappers.size();
        block0: while (true) {
            if ((buffer = (Mapping)this.source.take()) == null) {
                this.finished = true;
                return null;
            }
            for (int i = 0; i < mappersSize; ++i) {
                int[] b = this.mappers.get(i).nextMapping(buffer);
                if (b == null) {
                    while (i >= 0) {
                        this.mappers.get(i).reset();
                        --i;
                    }
                    bijections.clear();
                    continue block0;
                }
                bijections.add(b);
            }
            break;
        }
        return new BijectionContainer(buffer, SumBijectionPort.fill(this.bijection, bijections));
    }

    private static int[] fill(int[] r, List<int[]> list) {
        int size = list.size();
        int begin = 0;
        for (int i = 0; i < size; ++i) {
            int[] temp = list.get(i);
            System.arraycopy(temp, 0, r, begin, temp.length);
            begin += temp.length;
        }
        return r;
    }

    public static final class BijectionContainer {
        public final Mapping mapping;
        public final int[] bijection;

        BijectionContainer(Mapping mapping, int[] bijection) {
            this.mapping = mapping;
            this.bijection = bijection;
        }

        public String toString() {
            return Arrays.toString(this.bijection) + "\n" + this.mapping.toString();
        }
    }

    private static final class StretchPairMapper
    extends AbstractStretchMapper {
        public StretchPairMapper(Tensor[] from, Tensor[] to, int fromPointer) {
            super(from, to, fromPointer);
            this.currentPermutation = this.permutationGenerator.next();
        }

        @Override
        public void reset() {
            this.permutationGenerator = new IntCombinationPermutationGenerator(this.to.length, this.from.length);
            this.currentPermutation = this.permutationGenerator.next();
        }

        @Override
        public int[] _nextMapping(Mapping buffer) {
            while (true) {
                if (this.currentPermutation == null) {
                    return null;
                }
                if (this.test(buffer)) break;
                this.currentPermutation = this.permutationGenerator.next();
            }
            int[] bijection = new int[this.from.length];
            for (int i = 0; i < this.from.length; ++i) {
                bijection[i] = this.fromPointer + this.currentPermutation[i];
            }
            return bijection;
        }
    }

    private static final class StretchPairSource
    extends AbstractStretchMapper
    implements MapperSource {
        private OutputPort<Mapping> currentSource;

        public StretchPairSource(Tensor[] from, Tensor[] to, int fromPointer) {
            super(from, to, fromPointer);
        }

        @Override
        public int[] _nextMapping(Mapping buffer) {
            if (buffer == null) {
                return null;
            }
            if (!this.test(buffer)) {
                return null;
            }
            int[] mapping = new int[this.from.length];
            for (int i = 0; i < this.from.length; ++i) {
                mapping[i] = this.fromPointer + this.currentPermutation[i];
            }
            return mapping;
        }

        @Override
        public Mapping take() {
            Mapping buf;
            while (this.currentSource == null || (buf = this.currentSource.take()) == null) {
                if (!this.permutationGenerator.hasNext()) {
                    return null;
                }
                this.currentPermutation = this.permutationGenerator.next();
                this.currentSource = IndexMappings.createPort(this.from[0], this.to[this.currentPermutation[0]]);
            }
            return buf;
        }

        @Override
        public void reset() {
        }
    }

    private static final class SinglePairMapper
    extends AbstaractMapper {
        final Tensor from;
        final Tensor to;
        final int[] fromPointer;

        public SinglePairMapper(Tensor from, Tensor to, int fromPointer) {
            this.from = from;
            this.to = to;
            this.fromPointer = new int[]{fromPointer};
        }

        @Override
        public int[] _nextMapping(Mapping buffer) {
            if (!IndexMappings.testMapping(buffer, this.from, this.to)) {
                return null;
            }
            return this.fromPointer;
        }

        @Override
        public void reset() {
        }
    }

    private static final class SinglePairSource
    extends AbstaractMapper
    implements MapperSource {
        private final OutputPort<Mapping> mappingsPort;
        private final int[] fromPointer;

        public SinglePairSource(Tensor from, Tensor to, int fromPointer) {
            this.mappingsPort = IndexMappings.createPort(from, to);
            this.fromPointer = new int[]{fromPointer};
        }

        @Override
        public int[] _nextMapping(Mapping buffer) {
            return this.fromPointer;
        }

        @Override
        public Mapping take() {
            return this.mappingsPort.take();
        }

        @Override
        public void reset() {
        }
    }

    private static interface MapperSource
    extends Mapper,
    OutputPort<Mapping> {
    }

    private static abstract class AbstractStretchMapper
    extends AbstaractMapper {
        final Tensor[] from;
        final Tensor[] to;
        final int fromPointer;
        IntCombinationPermutationGenerator permutationGenerator;
        int[] currentPermutation;

        public AbstractStretchMapper(Tensor[] from, Tensor[] to, int fromPointer) {
            this.from = from;
            this.to = to;
            this.fromPointer = fromPointer;
            this.permutationGenerator = new IntCombinationPermutationGenerator(to.length, from.length);
        }

        public boolean test(Mapping buffer) {
            for (int i = 1; i < this.from.length; ++i) {
                if (IndexMappings.testMapping(buffer, this.from[i], this.to[this.currentPermutation[i]])) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class AbstaractMapper
    implements Mapper {
        private AbstaractMapper() {
        }

        @Override
        public int[] nextMapping(Mapping buffer) {
            if (buffer == null) {
                return null;
            }
            return this._nextMapping(buffer);
        }

        abstract int[] _nextMapping(Mapping var1);
    }

    private static interface Mapper {
        public int[] nextMapping(Mapping var1);

        public void reset();
    }
}

