/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.substitutions;

import cc.redberry.core.combinatorics.Combinatorics;
import cc.redberry.core.combinatorics.IntCombinatorialGenerator;
import cc.redberry.core.combinatorics.IntDistinctTuplesPort;
import cc.redberry.core.graph.GraphUtils;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.StructureOfContractions;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.OutputPort;
import cc.redberry.core.utils.stretces.Stretch;
import cc.redberry.core.utils.stretces.StretchIteratorS;
import java.util.Arrays;

public final class ProductsBijectionsPort
implements OutputPort<int[]> {
    private Tensor[] fromData;
    private Tensor[] targetData;
    private final int[] seeds;
    private StructureOfContractions targetFContractions;
    private StructureOfContractions fromFContractions;
    private long[][] fromContractions;
    private long[][] targetContractions;
    private final SeedPlanter planter;
    private InnerPort innerPort;

    public ProductsBijectionsPort(ProductContent fromContent, ProductContent targetContent) {
        this.targetFContractions = targetContent.getStructureOfContractions();
        this.fromFContractions = fromContent.getStructureOfContractions();
        this.fromContractions = this.fromFContractions.contractions;
        this.targetContractions = this.targetFContractions.contractions;
        int[] seeds = new int[this.fromFContractions.componentCount];
        Arrays.fill(seeds, -1);
        for (int i = 0; i < this.fromFContractions.components.length; ++i) {
            if (seeds[this.fromFContractions.components[i]] != -1) continue;
            seeds[this.fromFContractions.components[i]] = i;
        }
        this.seeds = seeds;
        this.fromData = fromContent.getRange(0, fromContent.size());
        this.targetData = targetContent.getRange(0, targetContent.size());
        this.planter = new SeedPlanter();
    }

    @Override
    public int[] take() {
        while (true) {
            int[] seedsInTarget;
            if (this.innerPort != null) {
                int[] bijection_ = this.innerPort.take();
                if (bijection_ != null) {
                    return bijection_;
                }
                this.innerPort = null;
            }
            if ((seedsInTarget = this.planter.next()) == null) {
                return null;
            }
            int[] bijection = new int[this.fromData.length];
            Arrays.fill(bijection, -1);
            for (int i = 0; i < seedsInTarget.length; ++i) {
                bijection[this.seeds[i]] = seedsInTarget[i];
            }
            this.innerPort = new InnerPort(bijection, this.seeds);
        }
    }

    private static boolean weakMatch(Tensor t0, Tensor t1) {
        if (t0.hashCode() != t1.hashCode()) {
            return false;
        }
        if (t0.getClass() != t1.getClass()) {
            return false;
        }
        if (t0.getIndices().getClass() != t1.getIndices().getClass()) {
            return false;
        }
        return t0.getIndices().size() == t1.getIndices().size();
    }

    private static boolean alreadyContains(int[] bijection, int value) {
        for (int i : bijection) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    private final class SeedPlanter {
        final IntDistinctTuplesPort combinationsPort;

        public SeedPlanter() {
            int[][] hits = new int[ProductsBijectionsPort.this.seeds.length][];
            IntArrayList hitList = new IntArrayList();
            for (int seedIndex = 0; seedIndex < ProductsBijectionsPort.this.seeds.length; ++seedIndex) {
                hitList.clear();
                for (int i = 0; i < ProductsBijectionsPort.this.targetData.length; ++i) {
                    if (!ProductsBijectionsPort.weakMatch(ProductsBijectionsPort.this.fromData[ProductsBijectionsPort.this.seeds[seedIndex]], ProductsBijectionsPort.this.targetData[i]) || GraphUtils.componentSize(ProductsBijectionsPort.this.seeds[seedIndex], ((ProductsBijectionsPort)ProductsBijectionsPort.this).fromFContractions.components) > GraphUtils.componentSize(i, ((ProductsBijectionsPort)ProductsBijectionsPort.this).targetFContractions.components)) continue;
                    hitList.add(i);
                }
                hits[seedIndex] = hitList.toArray();
            }
            this.combinationsPort = new IntDistinctTuplesPort(hits);
        }

        public int[] next() {
            return this.combinationsPort.take();
        }
    }

    private static final class PermutationInfo {
        final PermutationInfo previous;
        PermutationInfo next;
        final long[] fromContractions;
        final long[] targetContractions;
        final int[] permutation;
        final IntCombinatorialGenerator generator;

        public PermutationInfo(PermutationInfo previous, long[] fromContractions, long[] targetContractions) {
            this.previous = previous;
            this.fromContractions = fromContractions;
            this.targetContractions = targetContractions;
            this.generator = Combinatorics.createIntGenerator(targetContractions.length, fromContractions.length);
            this.permutation = this.generator.getReference();
            if (previous != null) {
                previous.generator.next();
                previous.next = this;
            }
        }

        boolean next() {
            if (!this.generator.hasNext()) {
                this.generator.reset();
                this.generator.next();
                if (this.previous != null) {
                    return this.previous.next();
                }
                return false;
            }
            this.generator.next();
            return true;
        }

        boolean nextAndResetRightChain() {
            if (this.next == null) {
                return true;
            }
            if (!this.next()) {
                return false;
            }
            PermutationInfo current = this;
            while (true) {
                current = current.next;
                if (current.next == null) break;
                current.generator.reset();
                current.generator.next();
            }
            current.generator.reset();
            return true;
        }
    }

    private class InnerPort
    implements OutputPort<int[]> {
        boolean closed = false;
        final int[] bijection;
        final int[] seeds;
        PermutationInfo lastInfo = null;
        PermutationInfo firstInfo = null;
        IntArrayList addedBijections;
        InnerPort innerPort = null;

        InnerPort(int[] bijection, int[] seeds) {
            this.bijection = bijection;
            this.seeds = seeds;
            this.init();
        }

        @Override
        public int[] take() {
            if (this.closed) {
                return null;
            }
            block0: while (true) {
                if (this.innerPort != null) {
                    int[] bijection_ = this.innerPort.take();
                    if (bijection_ != null) {
                        return bijection_;
                    }
                    if (this.lastInfo == null) {
                        this.closed = true;
                        return null;
                    }
                    this.innerPort = null;
                }
                if (this.lastInfo == null) {
                    if (this.addedBijections.size() == 0) {
                        this.closed = true;
                        return this.bijection;
                    }
                    this.innerPort = new InnerPort(this.bijection, this.addedBijections.toArray());
                    continue;
                }
                if (!this.lastInfo.next()) {
                    this.closed = true;
                    return null;
                }
                int[] bijectionNew = (int[])this.bijection.clone();
                IntArrayList addedBijectionsNew = this.addedBijections.clone();
                PermutationInfo currentInfo = this.firstInfo;
                do {
                    for (int j = 0; j < currentInfo.fromContractions.length; ++j) {
                        long fromContraction = currentInfo.fromContractions[j];
                        long targetContraction = currentInfo.targetContractions[currentInfo.permutation[j]];
                        assert (StructureOfContractions.getFromIndexId(fromContraction) == StructureOfContractions.getFromIndexId(targetContraction));
                        int fromTensorIndex = StructureOfContractions.getToTensorIndex(fromContraction);
                        int targetTensorIndex = StructureOfContractions.getToTensorIndex(targetContraction);
                        if (StructureOfContractions.getToIndexId(fromContraction) != StructureOfContractions.getToIndexId(targetContraction)) {
                            if (currentInfo.nextAndResetRightChain()) continue block0;
                            this.closed = true;
                            return null;
                        }
                        if (targetTensorIndex == -1) {
                            if (currentInfo.nextAndResetRightChain()) continue block0;
                            this.closed = true;
                            return null;
                        }
                        if (!ProductsBijectionsPort.weakMatch(ProductsBijectionsPort.this.fromData[fromTensorIndex], ProductsBijectionsPort.this.targetData[targetTensorIndex])) {
                            if (currentInfo.nextAndResetRightChain()) continue block0;
                            this.closed = true;
                            return null;
                        }
                        if (bijectionNew[fromTensorIndex] == -1) {
                            if (ProductsBijectionsPort.alreadyContains(bijectionNew, targetTensorIndex)) {
                                if (currentInfo.nextAndResetRightChain()) continue block0;
                                this.closed = true;
                                return null;
                            }
                            bijectionNew[fromTensorIndex] = targetTensorIndex;
                            addedBijectionsNew.add(fromTensorIndex);
                            continue;
                        }
                        if (bijectionNew[fromTensorIndex] == targetTensorIndex) continue;
                        if (currentInfo.nextAndResetRightChain()) continue block0;
                        this.closed = true;
                        return null;
                    }
                } while ((currentInfo = currentInfo.next) != null);
                this.innerPort = new InnerPort(bijectionNew, addedBijectionsNew.toArray());
            }
        }

        private void init() {
            PermutationInfo previousInfo = null;
            IntArrayList addedBijections = new IntArrayList();
            for (int i = 0; i < this.seeds.length; ++i) {
                int seedFromIndex = this.seeds[i];
                Tensor seedFrom = ProductsBijectionsPort.this.fromData[seedFromIndex];
                int seedTargetIndex = this.bijection[seedFromIndex];
                short[] diffIds = (short[])seedFrom.getIndices().getPositionsInOrbits().clone();
                int[] diffIdsPermutation = ArraysUtils.quickSortP(diffIds);
                for (Stretch stretch : new StretchIteratorS(diffIds)) {
                    int j;
                    if (stretch.length == 1) {
                        long fromIndexContraction = ProductsBijectionsPort.this.fromContractions[seedFromIndex][diffIdsPermutation[stretch.from]];
                        long targetIndexContraction = ProductsBijectionsPort.this.targetContractions[seedTargetIndex][diffIdsPermutation[stretch.from]];
                        int fromTensorIndex = StructureOfContractions.getToTensorIndex(fromIndexContraction);
                        if (fromTensorIndex == -1) continue;
                        if (StructureOfContractions.getToIndexId(fromIndexContraction) != StructureOfContractions.getToIndexId(targetIndexContraction)) {
                            this.closed = true;
                            return;
                        }
                        int targetTensorIndex = StructureOfContractions.getToTensorIndex(targetIndexContraction);
                        if (targetTensorIndex == -1) {
                            this.closed = true;
                            return;
                        }
                        if (!ProductsBijectionsPort.weakMatch(ProductsBijectionsPort.this.fromData[fromTensorIndex], ProductsBijectionsPort.this.targetData[targetTensorIndex])) {
                            this.closed = true;
                            return;
                        }
                        if (this.bijection[fromTensorIndex] == -1) {
                            if (ProductsBijectionsPort.alreadyContains(this.bijection, targetTensorIndex)) {
                                this.closed = true;
                                return;
                            }
                            this.bijection[fromTensorIndex] = targetTensorIndex;
                            addedBijections.add(fromTensorIndex);
                            continue;
                        }
                        if (this.bijection[fromTensorIndex] == targetTensorIndex) continue;
                        this.closed = true;
                        return;
                    }
                    int count = 0;
                    for (j = 0; j < stretch.length; ++j) {
                        if (StructureOfContractions.getToTensorIndex(ProductsBijectionsPort.this.fromContractions[seedFromIndex][diffIdsPermutation[stretch.from + j]]) == -1) continue;
                        ++count;
                    }
                    long[] fromContractions_ = new long[count];
                    long[] targetContractions_ = new long[stretch.length];
                    count = 0;
                    for (j = 0; j < stretch.length; ++j) {
                        long contraction = ProductsBijectionsPort.this.fromContractions[seedFromIndex][diffIdsPermutation[stretch.from + j]];
                        if (StructureOfContractions.getToTensorIndex(contraction) != -1) {
                            fromContractions_[count++] = contraction;
                        }
                        targetContractions_[j] = ProductsBijectionsPort.this.targetContractions[seedTargetIndex][diffIdsPermutation[stretch.from + j]];
                    }
                    previousInfo = new PermutationInfo(previousInfo, fromContractions_, targetContractions_);
                    if (this.firstInfo != null) continue;
                    this.firstInfo = previousInfo;
                }
            }
            this.addedBijections = addedBijections;
            this.lastInfo = previousInfo;
        }
    }
}

