/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.substitutions;

import cc.redberry.core.context.NameDescriptorForTensorField;
import cc.redberry.core.indexgenerator.IndexGeneratorImpl;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.UnsafeIndicesFactory;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.DifferentiateTransformation;
import cc.redberry.core.transformations.substitutions.PrimitiveSubstitution;
import cc.redberry.core.transformations.substitutions.SubstitutionIterator;
import cc.redberry.core.transformations.substitutions.SubstitutionTransformation;
import cc.redberry.core.utils.IntArray;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashMap;

class PrimitiveTensorFieldSubstitution
extends PrimitiveSubstitution {
    private NameDescriptorForTensorField fromDescriptor;
    private final IntArray orders;
    private final HashMap<IntArray, DFromTo> derivatives = new HashMap();

    public PrimitiveTensorFieldSubstitution(Tensor from, Tensor to) {
        super(from, to);
        this.fromDescriptor = ((TensorField)from).getNameDescriptor();
        this.orders = new IntArray(this.fromDescriptor.getDerivativeOrders());
        this.derivatives.put(this.orders, new DFromTo((TensorField)from, to));
    }

    @Override
    Tensor newTo_(Tensor currentNode, SubstitutionIterator iterator) {
        TensorField currentField = (TensorField)currentNode;
        NameDescriptorForTensorField currentDescriptor = currentField.getNameDescriptor();
        if (currentDescriptor.getParent().getId() != this.fromDescriptor.getParent().getId()) {
            return currentNode;
        }
        for (int i = currentNode.size() - 1; i >= 0; --i) {
            if (currentDescriptor.getDerivativeOrder(i) >= this.fromDescriptor.getDerivativeOrder(i)) continue;
            return currentNode;
        }
        IntArray orders = new IntArray(currentDescriptor.getDerivativeOrders());
        DFromTo derivative = this.derivatives.get(orders);
        if (derivative == null) {
            TensorField __from = (TensorField)this.from;
            Tensor __to = this.to;
            IndexGeneratorImpl ig = null;
            for (int i = orders.length() - 1; i >= 0; --i) {
                for (int order = orders.get(i) - this.orders.get(i); order > 0; --order) {
                    SimpleTensor var = (SimpleTensor)this.from.get(i);
                    int[] indices = new int[var.getIndices().size()];
                    if (indices.length != 0 && ig == null) {
                        TIntHashSet forbidden = new TIntHashSet(iterator.getForbidden());
                        forbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(this.from));
                        forbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(this.to));
                        ig = new IndexGeneratorImpl(forbidden.toArray());
                    }
                    for (int j = indices.length - 1; j >= 0; --j) {
                        indices[j] = IndicesUtils.setRawState(IndicesUtils.getRawStateInt(var.getIndices().get(j)), ig.generate(IndicesUtils.getType(var.getIndices().get(j))));
                    }
                    SimpleIndices varIndices = UnsafeIndicesFactory.createIsolatedUnsafeWithoutSort(null, indices);
                    var = Tensors.setIndices(var, varIndices);
                    __from = Tensors.fieldDerivative(__from, varIndices.getInverted(), i);
                    __to = new DifferentiateTransformation(var).transform(__to);
                }
            }
            derivative = new DFromTo(__from, __to);
            this.derivatives.put(orders, derivative);
        }
        return this.__newTo(derivative, currentField, currentNode, iterator);
    }

    private Tensor __newTo(DFromTo fromTo, TensorField currentField, Tensor currentNode, SubstitutionIterator iterator) {
        TensorField from = fromTo.from;
        Mapping mapping = IndexMappings.simpleTensorsPort(from, currentField).take();
        if (mapping == null) {
            return currentNode;
        }
        SimpleIndices[] fromIndices = from.getArgIndices();
        SimpleIndices[] currentIndices = currentField.getArgIndices();
        ArrayList<Tensor> argFrom = new ArrayList<Tensor>();
        ArrayList<Tensor> argTo = new ArrayList<Tensor>();
        for (int i = from.size() - 1; i >= 0; --i) {
            if (IndexMappings.positiveMappingExists(currentNode.get(i), from.get(i))) continue;
            int[] fIndices = fromIndices[i].getAllIndices().copy();
            int[] cIndices = currentIndices[i].getAllIndices().copy();
            assert (cIndices.length == fIndices.length);
            Tensor fArg = ApplyIndexMapping.applyIndexMapping(from.get(i), new Mapping(fIndices, cIndices), new int[0]);
            argFrom.add(fArg);
            argTo.add(currentNode.get(i));
        }
        Tensor newTo = fromTo.to;
        newTo = new SubstitutionTransformation(argFrom.toArray(new Tensor[argFrom.size()]), argTo.toArray(new Tensor[argTo.size()]), false).transform(newTo);
        return this.applyIndexMappingToTo(currentNode, newTo, mapping, iterator);
    }

    private static class DFromTo {
        final TensorField from;
        final Tensor to;

        private DFromTo(TensorField from, Tensor to) {
            this.from = from;
            this.to = to;
        }
    }
}

