/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.vector;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BasicLinAlg<C extends RingElem<C>> {
    public List<C> vectorAdd(List<C> a, List<C> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<RingElem> V = new ArrayList<RingElem>(a.size());
        Iterator<C> it = a.iterator();
        Iterator<C> jt = b.iterator();
        while (it.hasNext() && jt.hasNext()) {
            RingElem pi = (RingElem)it.next();
            RingElem pj = (RingElem)jt.next();
            RingElem p = pi.sum(pj);
            V.add(p);
        }
        if (it.hasNext() || jt.hasNext()) {
            // empty if block
        }
        return V;
    }

    public boolean isZero(List<C> a) {
        if (a == null) {
            return true;
        }
        for (RingElem pi : a) {
            if (pi == null || pi.isZERO()) continue;
            return false;
        }
        return true;
    }
}

