/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class CartesianProductIterator<E>
implements Iterator<List<E>> {
    final List<Iterable<E>> comps;
    final List<Iterator<E>> compit;
    List<E> current;
    boolean empty;

    public CartesianProductIterator(List<Iterable<E>> comps) {
        if (comps == null) {
            throw new IllegalArgumentException("null comps not allowed");
        }
        this.comps = comps;
        this.current = new ArrayList(comps.size());
        this.compit = new ArrayList<Iterator<E>>(comps.size());
        this.empty = false;
        for (Iterable<Iterable<E>> ci : comps) {
            Iterator<Iterable<E>> it = ci.iterator();
            if (!it.hasNext()) {
                this.empty = true;
                this.current.clear();
                break;
            }
            this.current.add(it.next());
            this.compit.add(it);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.empty;
    }

    @Override
    public synchronized List<E> next() {
        Iterator<E> iter;
        int j;
        Iterator<E> iter2;
        int i;
        if (this.empty) {
            throw new NoSuchElementException("invalid call of next()");
        }
        ArrayList<E> res = new ArrayList<E>(this.current);
        for (i = this.compit.size() - 1; i >= 0 && !(iter2 = this.compit.get(i)).hasNext(); --i) {
        }
        if (i < 0) {
            this.empty = true;
            return res;
        }
        for (j = i + 1; j < this.compit.size(); ++j) {
            iter = this.comps.get(j).iterator();
            this.compit.set(j, iter);
        }
        for (j = i; j < this.compit.size(); ++j) {
            iter = this.compit.get(j);
            E el = iter.next();
            this.current.set(j, el);
        }
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove tuples");
    }
}

