/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GCDFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeAbstract;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SquarefreeFieldChar0<C extends GcdRingElem<C>>
extends SquarefreeAbstract<C> {
    protected final RingFactory<C> coFac;

    public SquarefreeFieldChar0(RingFactory<C> fac) {
        super(GCDFactory.getProxy(fac));
        if (!fac.isField()) {
            throw new IllegalArgumentException("fac must be a field");
        }
        if (fac.characteristic().signum() != 0) {
            throw new IllegalArgumentException("characterisic(fac) must be zero");
        }
        this.coFac = fac;
    }

    public String toString() {
        return this.getClass().getName() + " with " + this.engine + " over " + this.coFac;
    }

    @Override
    public GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<C> pp = P.monic();
        if (pp.isConstant()) {
            return pp;
        }
        GenPolynomial<C> d = PolyUtil.baseDeriviative(pp);
        d = d.monic();
        GenPolynomial<C> g = this.engine.baseGcd(pp, d);
        g = g.monic();
        GenPolynomial<C> q = PolyUtil.basePseudoDivide(pp, g);
        q = q.monic();
        return q;
    }

    public boolean isBaseSquarefree(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return true;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<C> pp = P.monic();
        if (pp.isConstant()) {
            return true;
        }
        GenPolynomial<C> d = PolyUtil.baseDeriviative(pp);
        d = d.monic();
        GenPolynomial<C> g = this.engine.baseGcd(pp, d);
        g = g.monic();
        return g.isONE();
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> A) {
        TreeMap<GenPolynomial<C>, Long> sfactors = new TreeMap<GenPolynomial<C>, Long>();
        if (A == null || A.isZERO()) {
            return sfactors;
        }
        if (A.isConstant()) {
            sfactors.put(A, 1L);
            return sfactors;
        }
        GenPolynomialRing pfac = A.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GcdRingElem ldbcf = (GcdRingElem)A.leadingBaseCoefficient();
        if (!ldbcf.isONE()) {
            A = A.divide(ldbcf);
            GenPolynomial<GcdRingElem> f1 = ((GenPolynomial)pfac.getONE()).multiply(ldbcf);
            sfactors.put(f1, 1L);
            ldbcf = (GcdRingElem)pfac.coFac.getONE();
        }
        GenPolynomial<GcdRingElem> T0 = A;
        GenPolynomial<C> T = null;
        GenPolynomial<C> V = null;
        long k = 0L;
        boolean init = true;
        while (true) {
            if (init) {
                if (T0.isConstant() || T0.isZERO()) break;
                GenPolynomial<C> Tp = PolyUtil.baseDeriviative(T0);
                T = this.engine.baseGcd(T0, Tp);
                T = T.monic();
                V = PolyUtil.basePseudoDivide(T0, T);
                k = 0L;
                init = false;
            }
            if (V.isConstant()) break;
            ++k;
            GenPolynomial W = this.engine.baseGcd(T, V);
            W = W.monic();
            GenPolynomial z = PolyUtil.basePseudoDivide(V, W);
            V = W;
            T = PolyUtil.basePseudoDivide(T, V);
            if (z.degree(0) <= 0L) continue;
            if (ldbcf.isONE() && !((GcdRingElem)z.leadingBaseCoefficient()).isONE()) {
                z = z.monic();
            }
            sfactors.put(z, k);
        }
        return this.normalizeFactorization(sfactors);
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for multivariate polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> pp = P;
        GenPolynomial<C> Pc = this.engine.recursiveContent(P);
        if (!(Pc = Pc.monic()).isONE()) {
            pp = PolyUtil.coefficientPseudoDivide(pp, Pc);
        }
        if (pp.leadingExpVector().getVal(0) < 1L) {
            return pp.multiply((GenPolynomial<GenPolynomial<C>>)Pc);
        }
        GenPolynomial<GenPolynomial<C>> d = PolyUtil.recursiveDeriviative(pp);
        GenPolynomial<GenPolynomial<C>> g = this.engine.recursiveUnivariateGcd(pp, d);
        g = PolyUtil.monic(g);
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> q = PolyUtil.recursivePseudoDivide(pp, g);
        q = PolyUtil.monic(q);
        return q.multiply((GenPolynomial<GenPolynomial<C>>)Pc);
    }

    public boolean isRecursiveUnivariateSquarefree(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return true;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for multivariate polynomials");
        }
        GenPolynomial<GenPolynomial<C>> pp = P;
        GenPolynomial<C> Pc = this.engine.recursiveContent(P);
        if (!this.isSquarefree(Pc)) {
            return false;
        }
        if (!(Pc = Pc.monic()).isONE()) {
            pp = PolyUtil.coefficientPseudoDivide(pp, Pc);
        }
        if (pp.leadingExpVector().getVal(0) <= 1L) {
            return true;
        }
        GenPolynomial<GenPolynomial<C>> d = PolyUtil.recursiveDeriviative(pp);
        GenPolynomial<GenPolynomial<C>> g = this.engine.recursiveUnivariateGcd(pp, d);
        g = PolyUtil.monic(g);
        return g.isONE();
    }

    @Override
    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> P) {
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> sfactors = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (P == null || P.isZERO()) {
            return sfactors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing cfac = (GenPolynomialRing)pfac.coFac;
        GcdRingElem ldbcf = (GcdRingElem)P.leadingBaseCoefficient().leadingBaseCoefficient();
        if (!ldbcf.isONE()) {
            GenPolynomial<GcdRingElem> lc = ((GenPolynomial)cfac.getONE()).multiply(ldbcf);
            GenPolynomial<GenPolynomial<GcdRingElem>> pl = ((GenPolynomial)pfac.getONE()).multiply(lc);
            sfactors.put(pl, 1L);
            GcdRingElem li = (GcdRingElem)ldbcf.inverse();
            P = P.multiply((GenPolynomial<Object>)((GenPolynomial)cfac.getONE()).multiply(li));
            ldbcf = (GcdRingElem)P.leadingBaseCoefficient().leadingBaseCoefficient();
        }
        GenPolynomial Pc = this.engine.recursiveContent(P);
        if (!(Pc = Pc.monic()).isONE()) {
            P = PolyUtil.coefficientPseudoDivide(P, Pc);
        }
        SortedMap rsf = this.squarefreeFactors((C)Pc);
        for (Map.Entry entry : rsf.entrySet()) {
            GenPolynomial c = (GenPolynomial)entry.getKey();
            if (c.isONE()) continue;
            GenPolynomial<GenPolynomial> cr = ((GenPolynomial)pfac.getONE()).multiply(c);
            Long rk = (Long)entry.getValue();
            sfactors.put(cr, rk);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<Object>>> T0 = P;
        GenPolynomial T = null;
        GenPolynomial V = null;
        long k = 0L;
        boolean init = true;
        while (true) {
            if (init) {
                if (T0.isConstant() || T0.isZERO()) break;
                GenPolynomial genPolynomial = PolyUtil.recursiveDeriviative(T0);
                T = this.engine.recursiveUnivariateGcd(T0, genPolynomial);
                T = PolyUtil.monic(T);
                V = PolyUtil.recursivePseudoDivide(T0, T);
                k = 0L;
                init = false;
            }
            if (V.isConstant()) break;
            ++k;
            GenPolynomial W = this.engine.recursiveUnivariateGcd(T, V);
            W = PolyUtil.monic(W);
            GenPolynomial z = PolyUtil.recursivePseudoDivide(V, W);
            V = W;
            T = PolyUtil.recursivePseudoDivide(T, V);
            if (z.isONE() || z.isZERO()) continue;
            if (ldbcf.isONE()) {
                z = PolyUtil.monic(z);
            }
            sfactors.put(z, k);
        }
        return sfactors;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseSquarefreePart(P);
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        GenPolynomial Pc = this.engine.recursiveContent(Pr);
        Pr = PolyUtil.coefficientPseudoDivide(Pr, Pc);
        GenPolynomial Ps = this.squarefreePart(Pc);
        GenPolynomial PP = this.recursiveUnivariateSquarefreePart(Pr);
        GenPolynomial PS = PP.multiply(Ps);
        GenPolynomial D = PolyUtil.distribute(pfac, PS);
        return D;
    }

    @Override
    public boolean isSquarefree(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return true;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.isBaseSquarefree(P);
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        return this.isRecursiveUnivariateSquarefree(Pr);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.normalizeFactorization(this.baseSquarefreeFactors(P));
        }
        TreeMap sfactors = new TreeMap();
        if (P.isZERO()) {
            return this.normalizeFactorization(sfactors);
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        SortedMap PP = this.recursiveUnivariateSquarefreeFactors(Pr);
        for (Map.Entry m : PP.entrySet()) {
            Long i = m.getValue();
            GenPolynomial Dr = m.getKey();
            GenPolynomial D = PolyUtil.distribute(pfac, Dr);
            sfactors.put(D, i);
        }
        return this.normalizeFactorization(sfactors);
    }

    @Override
    public SortedMap<C, Long> squarefreeFactors(C P) {
        throw new UnsupportedOperationException("method not implemented");
    }
}

