/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Power;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GreatestCommonDivisorAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.Squarefree;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class SquarefreeAbstract<C extends GcdRingElem<C>>
implements Squarefree<C> {
    protected final GreatestCommonDivisorAbstract<C> engine;

    public SquarefreeAbstract(GreatestCommonDivisorAbstract<C> engine) {
        this.engine = engine;
    }

    public abstract GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> var1);

    public abstract SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> var1);

    public abstract GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> var1);

    public abstract SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> var1);

    @Override
    public abstract GenPolynomial<C> squarefreePart(GenPolynomial<C> var1);

    @Override
    public boolean isSquarefree(GenPolynomial<C> P) {
        GenPolynomial<C> S = this.squarefreePart(P);
        GenPolynomial<C> Ps = P;
        Ps = P.ring.coFac.isField() ? Ps.monic() : this.engine.basePrimitivePart(Ps);
        boolean f = Ps.equals(S);
        return f;
    }

    @Override
    public abstract SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> var1);

    public SortedMap<GenPolynomial<C>, Long> normalizeFactorization(SortedMap<GenPolynomial<C>, Long> F) {
        if (F == null || F.size() <= 1) {
            return F;
        }
        ArrayList<GenPolynomial<C>> Fp = new ArrayList<GenPolynomial<C>>(F.keySet());
        AbelianGroupElem f0 = (GenPolynomial)Fp.get(0);
        if (f0.ring.characteristic().signum() != 0) {
            return F;
        }
        long e0 = (Long)F.get(f0);
        TreeMap<GenPolynomial<C>, Long> Sp = new TreeMap<GenPolynomial<C>, Long>();
        for (int i = 1; i < Fp.size(); ++i) {
            AbelianGroupElem fi = (GenPolynomial)Fp.get(i);
            long ei = (Long)F.get(fi);
            if (fi.signum() < 0) {
                fi = fi.negate();
                if (ei % 2L != 0L) {
                    f0 = f0.negate();
                }
            }
            Sp.put((GenPolynomial<C>)fi, ei);
        }
        if (!f0.isONE()) {
            Sp.put((GenPolynomial<C>)f0, e0);
        }
        return Sp;
    }

    public boolean isFactorization(GenPolynomial<C> P, List<GenPolynomial<C>> F) {
        boolean f;
        if (P == null || F == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> t = P.ring.getONE();
        for (GenPolynomial<C> f2 : F) {
            t = t.multiply((GenPolynomial<GenPolynomial<C>>)f2);
        }
        boolean bl = f = P.equals(t) || P.equals(t.negate());
        if (!f) {
            // empty if block
        }
        return f;
    }

    public boolean isFactorization(GenPolynomial<C> P, SortedMap<GenPolynomial<C>, Long> F) {
        boolean f;
        if (P == null || F == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (P.isZERO() && F.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial<C>> t = P.ring.getONE();
        for (Map.Entry<GenPolynomial<C>, Long> me : F.entrySet()) {
            GenPolynomial<C> f2 = me.getKey();
            Long E = me.getValue();
            long e = E;
            GenPolynomial<C> g = Power.positivePower(f2, e);
            t = t.multiply(g);
        }
        boolean bl = f = P.equals(t) || P.equals(t.negate());
        if (!f) {
            boolean bl2 = f = (P = P.monic()).equals(t = t.monic()) || P.equals(t.negate());
            if (f) {
                return f;
            }
        }
        return f;
    }

    public abstract SortedMap<C, Long> squarefreeFactors(C var1);
}

