/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModIntegerRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModLong;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModLongRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.Modular;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModularRingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Monomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Power;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GreatestCommonDivisorPrimitive;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.HenselApprox;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.List;

public class HenselUtil {
    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadratic(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> S, GenPolynomial<MOD> T) throws NoLiftingException {
        MonoidElem<GenPolynomial<GenPolynomial<BigInteger>>> E;
        GcdRingElem b;
        RingFactory p;
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomialRing pfac = A.ring;
        RingFactory q = p = pfac.coFac;
        ModularRingFactory P = (ModularRingFactory)p;
        ModularRingFactory<ModLong> Q = (ModularRingFactory<ModLong>)q;
        BigInteger Qi = Q.getIntegerModul();
        BigInteger M2 = M.multiply(M.fromInteger(2L));
        BigInteger Mq = Qi;
        GenPolynomialRing qfac = new GenPolynomialRing(Q, pfac);
        BigInteger c = C.leadingBaseCoefficient();
        C = C.multiply(c);
        GcdRingElem a = (GcdRingElem)A.leadingBaseCoefficient();
        if (!a.isONE()) {
            A = A.divide((Object)a);
            S = S.multiply((Object)a);
        }
        if (!(b = (GcdRingElem)B.leadingBaseCoefficient()).isONE()) {
            B = B.divide((Object)b);
            T = T.multiply((Object)b);
        }
        GcdRingElem cm = (GcdRingElem)P.fromInteger(c.getVal());
        A = A.multiply((Object)cm);
        B = B.multiply((Object)cm);
        T = T.divide((Object)cm);
        S = S.divide((Object)cm);
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(fac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(fac, B);
        ExpVector ea = Ai.leadingExpVector();
        ExpVector eb = Bi.leadingExpVector();
        Ai.doPutToMap(ea, c);
        Bi.doPutToMap(eb, c);
        GenPolynomial<Object> A1p = A;
        GenPolynomial<Object> B1p = B;
        GenPolynomial<Object> Sp = S;
        GenPolynomial<Object> Tp = T;
        GenPolynomial<Iterable<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(fac, S);
        GenPolynomial<Iterable<BigInteger>> Ti = PolyUtil.integerFromModularCoefficients(fac, T);
        GenPolynomial Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
        GenPolynomial Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
        while (Mq.compareTo(M2) < 0 && !((GenPolynomial)(E = C.subtract((BigInteger)((Object)Ai.multiply((BigInteger)((Object)Bi)))))).isZERO()) {
            E = ((GenPolynomial)E).divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)Qi));
            GenPolynomial Ep = PolyUtil.fromIntegerCoefficients(qfac, E);
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>> Ap = Sp.multiply((Object)Ep);
            GenPolynomial Bp = Tp.multiply((Object)Ep);
            GenPolynomial<GenPolynomial<C>>[] QR = Ap.quotientRemainder(Bq);
            GenPolynomial Qp = QR[0];
            GenPolynomial<GenPolynomial<Object>> Rp = QR[1];
            A1p = Rp;
            B1p = Bp.sum(Aq.multiply(Qp));
            GenPolynomial<Iterable<BigInteger>> Ea = PolyUtil.integerFromModularCoefficients(fac, A1p);
            GenPolynomial<Iterable<BigInteger>> Eb = PolyUtil.integerFromModularCoefficients(fac, B1p);
            GenPolynomial<Iterable<BigInteger>> Ea1 = Ea.multiply(Qi);
            GenPolynomial<Iterable<BigInteger>> Eb1 = Eb.multiply(Qi);
            Ea = Ai.sum((BigInteger)((Object)Eb1));
            Eb = Bi.sum((BigInteger)((Object)Ea1));
            assert (Ea.degree(0) + Eb.degree(0) <= C.degree(0));
            Ai = Ea;
            Bi = Eb;
            E = fac.getONE();
            E = ((GenPolynomial)E).subtract(Si.multiply((BigInteger)((Object)Ai))).subtract(Ti.multiply((BigInteger)((Object)Bi)));
            E = ((GenPolynomial)E).divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)Qi));
            Ep = PolyUtil.fromIntegerCoefficients(qfac, E);
            Ap = Sp.multiply((Object)Ep);
            Bp = Tp.multiply((Object)Ep);
            QR = Bp.quotientRemainder(Aq);
            Qp = QR[0];
            Rp = QR[1];
            B1p = Rp;
            A1p = Ap.sum(Bq.multiply(Qp));
            Ea = PolyUtil.integerFromModularCoefficients(fac, A1p);
            Eb = PolyUtil.integerFromModularCoefficients(fac, B1p);
            Ea1 = Ea.multiply(Qi);
            Eb1 = Eb.multiply(Qi);
            Ea = Si.sum((BigInteger)((Object)Ea1));
            Eb = Ti.sum((BigInteger)((Object)Eb1));
            Si = Ea;
            Ti = Eb;
            Mq = Qi;
            Qi = Q.getIntegerModul().multiply(Q.getIntegerModul());
            Q = ModLongRing.MAX_LONG.compareTo(Qi.getVal()) > 0 ? new ModLongRing(Qi.getVal()) : new ModIntegerRing(Qi.getVal());
            qfac = new GenPolynomialRing(Q, pfac);
            Aq = PolyUtil.fromIntegerCoefficients(qfac, Ai);
            Bq = PolyUtil.fromIntegerCoefficients(qfac, Bi);
            Sp = PolyUtil.fromIntegerCoefficients(qfac, Si);
            Tp = PolyUtil.fromIntegerCoefficients(qfac, Ti);
        }
        GreatestCommonDivisorPrimitive<BigInteger> ufd = new GreatestCommonDivisorPrimitive<BigInteger>();
        BigInteger ai = ufd.baseContent(Ai);
        Ai = Ai.divide(ai);
        BigInteger bi = null;
        try {
            bi = c.divide(ai);
            Bi = Bi.divide(bi);
        }
        catch (RuntimeException e) {
            throw new NoLiftingException("no exact lifting possible " + e);
        }
        return new HenselApprox<Object>(Ai, Bi, A1p, B1p);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> HenselApprox<MOD> liftHenselQuadratic(GenPolynomial<BigInteger> C, BigInteger M, GenPolynomial<MOD> A, GenPolynomial<MOD> B) throws NoLiftingException {
        if (C == null || C.isZERO()) {
            return new HenselApprox<MOD>(C, C, A, B);
        }
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero");
        }
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        try {
            GenPolynomial<MOD>[] gst = A.egcd(B);
            if (!gst[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
            }
            GenPolynomial<MOD> s = gst[1];
            GenPolynomial<MOD> t = gst[2];
            HenselApprox<MOD> ab = HenselUtil.liftHenselQuadratic(C, M, A, B, s, t);
            return ab;
        }
        catch (ArithmeticException e) {
            throw new NoLiftingException("coefficient error " + e);
        }
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> GenPolynomial<MOD>[] liftExtendedEuclidean(GenPolynomial<MOD> A, GenPolynomial<MOD> B, long k) throws NoLiftingException {
        GenPolynomial<GenPolynomial<GenPolynomial<BigInteger>>> e;
        BigInteger p;
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero, A = " + A + ", B = " + B);
        }
        GenPolynomialRing fac = A.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] gst = null;
        try {
            gst = A.egcd(B);
            if (!gst[0].isONE()) {
                throw new NoLiftingException("A and B not coprime, gcd = " + gst[0] + ", A = " + A + ", B = " + B);
            }
        }
        catch (ArithmeticException e2) {
            throw new NoLiftingException("coefficient error " + e2);
        }
        GenPolynomial<Object> S = gst[1];
        GenPolynomial<Object> T = gst[2];
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        MonoidElem one = ifac.getONE();
        GenPolynomial<BigInteger> Ai = PolyUtil.integerFromModularCoefficients(ifac, A);
        GenPolynomial<BigInteger> Bi = PolyUtil.integerFromModularCoefficients(ifac, B);
        GenPolynomial<Iterable<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(ifac, S);
        GenPolynomial<Iterable<BigInteger>> Ti = PolyUtil.integerFromModularCoefficients(ifac, T);
        ModularRingFactory<ModLong> mcfac = (ModularRingFactory<ModLong>)fac.coFac;
        BigInteger modul = p = mcfac.getIntegerModul();
        int i = 1;
        while ((long)i < k && !(e = ((GenPolynomial)one).subtract(Si.multiply((BigInteger)((Object)Ai))).subtract(Ti.multiply((BigInteger)((Object)Bi)))).isZERO()) {
            e = e.divide((GenPolynomial<GenPolynomial<BigInteger>>)((Object)modul));
            GenPolynomial c = PolyUtil.fromIntegerCoefficients(fac, e);
            GenPolynomial<GenPolynomial<MOD>> s = S.multiply((Object)c);
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>> t = T.multiply((Object)c);
            GenPolynomial<GenPolynomial<C>>[] QR = s.quotientRemainder(B);
            GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> q = QR[0];
            s = QR[1];
            t = t.sum((GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>)q.multiply((GenPolynomial<GenPolynomial<MOD>>)A));
            GenPolynomial<BigInteger> si = PolyUtil.integerFromModularCoefficients(ifac, s);
            GenPolynomial<BigInteger> ti = PolyUtil.integerFromModularCoefficients(ifac, t);
            Si = Si.sum((BigInteger)((Object)si.multiply(modul)));
            Ti = Ti.sum((BigInteger)((Object)ti.multiply(modul)));
            modul = modul.multiply(p);
            ++i;
        }
        mcfac = ModLongRing.MAX_LONG.compareTo(modul.getVal()) > 0 ? new ModLongRing(modul.getVal()) : new ModIntegerRing(modul.getVal());
        GenPolynomialRing mfac = new GenPolynomialRing(mcfac, fac);
        S = PolyUtil.fromIntegerCoefficients(mfac, Si);
        T = PolyUtil.fromIntegerCoefficients(mfac, Ti);
        GenPolynomial[] rel = new GenPolynomial[]{S, T};
        return rel;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftExtendedEuclidean(List<GenPolynomial<MOD>> A, long k) throws NoLiftingException {
        if (A == null || A.size() == 0) {
            throw new IllegalArgumentException("A must be non null and non empty");
        }
        GenPolynomialRing fac = A.get((int)0).ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem zero = fac.getZERO();
        int r = A.size();
        ArrayList<AbelianGroupElem> Q = new ArrayList<AbelianGroupElem>(r);
        for (GenPolynomial<MOD> aA1 : A) {
            Q.add(zero);
        }
        Q.set(r - 2, A.get(r - 1));
        for (int j = r - 3; j >= 0; --j) {
            GenPolynomial<GenPolynomial> q = A.get(j + 1).multiply((MOD)((GenPolynomial)Q.get(j + 1)));
            Q.set(j, q);
        }
        ArrayList<AbelianGroupElem> B = new ArrayList<AbelianGroupElem>(r + 1);
        ArrayList<GenPolynomial<MOD>> lift = new ArrayList<GenPolynomial<MOD>>(r);
        for (GenPolynomial<MOD> aA : A) {
            B.add(zero);
            lift.add((GenPolynomial<MOD>)zero);
        }
        GenPolynomial<MOD> one = fac.getONE();
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        B.add(0, one);
        GenPolynomial<MOD> b = one;
        for (int j = 0; j < r - 1; ++j) {
            List<GenPolynomial<MOD>> S = HenselUtil.liftDiophant((GenPolynomial)Q.get(j), A.get(j), (GenPolynomial)B.get(j), k);
            b = S.get(0);
            GenPolynomial bb = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, b));
            B.set(j + 1, bb);
            lift.set(j, S.get(1));
        }
        lift.set(r - 1, b);
        return lift;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> C, long k) throws NoLiftingException {
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero, A = " + A + ", B = " + B + ", C = " + C);
        }
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem zero = fac.getZERO();
        for (int i = 0; i < 2; ++i) {
            sol.add((GenPolynomial<MOD>)zero);
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        for (Monomial<Object> m : C) {
            long e = m.e.getVal(0);
            List<GenPolynomial<Object>> S = HenselUtil.liftDiophant(A, B, e, k);
            GcdRingElem a = (GcdRingElem)m.c;
            a = (GcdRingElem)fac.coFac.fromInteger(((Modular)((Object)a)).getSymmetricInteger().getVal());
            int i = 0;
            for (GenPolynomial<Object> genPolynomial : S) {
                GenPolynomial<GcdRingElem> genPolynomial3 = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, genPolynomial));
                genPolynomial3 = genPolynomial3.multiply(a);
                GenPolynomial<GenPolynomial<GcdRingElem>> genPolynomial4 = ((GenPolynomial)sol.get(i)).sum(genPolynomial3);
                sol.set(i++, genPolynomial4);
            }
        }
        A = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, A));
        B = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, B));
        C = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, C));
        GenPolynomial<GenPolynomial<GenPolynomial>> y = B.multiply((Object)((GenPolynomial)sol.get(0))).sum((GenPolynomial)A.multiply((Object)((GenPolynomial)sol.get(1))));
        if (!y.equals(C)) {
            // empty if block
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(List<GenPolynomial<MOD>> A, GenPolynomial<MOD> C, long k) throws NoLiftingException {
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        AbelianGroupElem zero = fac.getZERO();
        for (GenPolynomial<MOD> aA : A) {
            sol.add((GenPolynomial<MOD>)zero);
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        for (Monomial<MOD> m : C) {
            long e = m.e.getVal(0);
            List<GenPolynomial<MOD>> S = HenselUtil.liftDiophant(A, e, k);
            GcdRingElem a = (GcdRingElem)m.c;
            a = (GcdRingElem)fac.coFac.fromInteger(((Modular)((Object)a)).getSymmetricInteger().getVal());
            int i = 0;
            for (GenPolynomial<MOD> genPolynomial : S) {
                GenPolynomial<GcdRingElem> genPolynomial3 = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, genPolynomial));
                genPolynomial3 = genPolynomial3.multiply(a);
                GenPolynomial<GenPolynomial<GcdRingElem>> genPolynomial4 = ((GenPolynomial)sol.get(i)).sum(genPolynomial3);
                sol.set(i++, genPolynomial4);
            }
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> A, GenPolynomial<MOD> B, long e, long k) throws NoLiftingException {
        if (A == null || A.isZERO() || B == null || B.isZERO()) {
            throw new IllegalArgumentException("A and B must be nonzero, A = " + A + ", B = " + B);
        }
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = A.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        GenPolynomial<MOD>[] lee = HenselUtil.liftExtendedEuclidean(B, A, k);
        GenPolynomial<MOD> s1 = lee[0];
        GenPolynomial<MOD> s2 = lee[1];
        if (e == 0L) {
            sol.add(s1);
            sol.add(s2);
            return sol;
        }
        fac = s1.ring;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        A = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, A));
        B = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, B));
        GenPolynomial xe = fac.univariate(0, e);
        GenPolynomial<GenPolynomial<Object>> q = s1.multiply((MOD)xe);
        GenPolynomial<GenPolynomial<C>>[] QR = q.quotientRemainder(A);
        q = QR[0];
        GenPolynomial r1 = QR[1];
        GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> r2 = s2.multiply((MOD)xe).sum((GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>)q.multiply(B));
        sol.add(r1);
        sol.add(r2);
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>>> y = B.multiply((Object)r1).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<MOD>>>>>>)A.multiply((Object)r2));
        if (!y.equals(xe)) {
            // empty if block
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(List<GenPolynomial<MOD>> A, long e, long k) throws NoLiftingException {
        ArrayList<GenPolynomial<MOD>> sol = new ArrayList<GenPolynomial<MOD>>();
        GenPolynomialRing fac = A.get((int)0).ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        List<GenPolynomial<MOD>> lee = HenselUtil.liftExtendedEuclidean(A, k);
        if (e == 0L) {
            return lee;
        }
        fac = lee.get((int)0).ring;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        ArrayList<GenPolynomial<MOD>> S = new ArrayList<GenPolynomial<MOD>>(lee.size());
        for (GenPolynomial<Object> a : lee) {
            a = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, a));
            S.add(a);
        }
        GenPolynomial xe = fac.univariate(0, e);
        int i = 0;
        for (GenPolynomial genPolynomial : S) {
            GenPolynomial<GenPolynomial<MOD>> q = genPolynomial.multiply(xe);
            GenPolynomial r = q.remainder((GenPolynomial<GenPolynomial<MOD>>)A.get(i++));
            sol.add(r);
        }
        return sol;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isDiophantLift(GenPolynomial<MOD> A, GenPolynomial<MOD> B, GenPolynomial<MOD> S1, GenPolynomial<MOD> S2, GenPolynomial<MOD> C) {
        GenPolynomialRing fac = C.ring;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        GenPolynomial a = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, A));
        GenPolynomial b = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, B));
        GenPolynomial s1 = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, S1));
        GenPolynomial s2 = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, S2));
        GenPolynomial t = a.multiply(s1).sum(b.multiply(s2));
        return t.equals(C);
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isDiophantLift(List<GenPolynomial<MOD>> A, List<GenPolynomial<MOD>> S, GenPolynomial<MOD> C) {
        GenPolynomialRing fac = A.get((int)0).ring;
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        ArrayList B = new ArrayList(A.size());
        int i = 0;
        for (GenPolynomial<MOD> ai : A) {
            void var9_11;
            MonoidElem monoidElem = fac.getONE();
            int j = 0;
            for (GenPolynomial<MOD> aj : A) {
                if (i != j) {
                    GenPolynomial<GenPolynomial<MOD>> genPolynomial = var9_11.multiply(aj);
                }
                ++j;
            }
            GenPolynomial genPolynomial = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, var9_11));
            B.add(genPolynomial);
            ++i;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<MOD>>> t = fac.getZERO();
        i = 0;
        for (GenPolynomial genPolynomial : B) {
            GenPolynomial<Object> b = S.get(i++);
            b = PolyUtil.fromIntegerCoefficients(fac, PolyUtil.integerFromModularCoefficients(ifac, b));
            GenPolynomial<GenPolynomial<MOD>> s = genPolynomial.multiply(b);
            t = t.sum(s);
        }
        return t.equals(C);
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHenselMonic(GenPolynomial<BigInteger> C, List<GenPolynomial<MOD>> F, long k) throws NoLiftingException {
        BigInteger p;
        if (C == null || C.isZERO() || F == null || F.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<BigInteger> fac = C.ring;
        if (fac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        List<GenPolynomial<Object>> lift = new ArrayList<GenPolynomial<MOD>>(F.size());
        GenPolynomialRing pfac = F.get((int)0).ring;
        RingFactory pcfac = pfac.coFac;
        ModularRingFactory<ModLong> PF = (ModularRingFactory<ModLong>)pcfac;
        BigInteger P = PF.getIntegerModul();
        int n = F.size();
        if (n == 1) {
            GenPolynomial<Object> f = F.get(0);
            ModularRingFactory<ModLong> mcfac = ModLongRing.MAX_LONG.compareTo(P.getVal()) > 0 ? new ModLongRing(P.getVal()) : new ModIntegerRing(P.getVal());
            GenPolynomialRing<ModLong> mfac = new GenPolynomialRing<ModLong>(mcfac, fac);
            f = PolyUtil.fromIntegerCoefficients(mfac, PolyUtil.integerFromModularCoefficients(fac, f));
            lift.add(f);
            return lift;
        }
        GenPolynomialRing<BigInteger> ifac = new GenPolynomialRing<BigInteger>(new BigInteger(), fac);
        List<GenPolynomial<BigInteger>> Fi = PolyUtil.integerFromModularCoefficients(ifac, F);
        List S = HenselUtil.liftExtendedEuclidean(F, k + 1L);
        List<GenPolynomial<BigInteger>> Si = PolyUtil.integerFromModularCoefficients(ifac, S);
        ModularRingFactory<ModLong> mcfac = PF;
        BigInteger modul = p = mcfac.getIntegerModul();
        GenPolynomialRing mfac = new GenPolynomialRing(mcfac, fac);
        List Sp = PolyUtil.fromIntegerCoefficients(mfac, Si);
        int i = 1;
        while ((long)i < k) {
            GenPolynomial<Iterable<BigInteger>> e = fac.getONE();
            for (GenPolynomial<BigInteger> fi : Fi) {
                e = e.multiply((Iterable<BigInteger>)fi);
            }
            if ((e = C.subtract((BigInteger)((Object)e))).isZERO()) break;
            try {
                e = e.divide(modul);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw ex;
            }
            GenPolynomial c = PolyUtil.fromIntegerCoefficients(mfac, e);
            ArrayList s = new ArrayList(S.size());
            int j = 0;
            for (GenPolynomial genPolynomial : Sp) {
                GenPolynomial<GenPolynomial<MOD>> genPolynomial2 = genPolynomial.multiply(c);
                GenPolynomial genPolynomial3 = genPolynomial2.remainder((GenPolynomial<GenPolynomial<MOD>>)F.get(j++));
                s.add(genPolynomial3);
            }
            List<GenPolynomial<BigInteger>> si = PolyUtil.integerFromModularCoefficients(ifac, s);
            ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>(F.size());
            j = 0;
            for (GenPolynomial<Iterable<BigInteger>> f : Fi) {
                f = f.sum((BigInteger)((Object)si.get(j++).multiply(modul)));
                arrayList.add(f);
            }
            Fi = arrayList;
            modul = modul.multiply(p);
            if ((long)i >= k - 1L) {
                // empty if block
            }
            ++i;
        }
        mcfac = ModLongRing.MAX_LONG.compareTo((modul = Power.positivePower(p, k)).getVal()) > 0 ? new ModLongRing(modul.getVal()) : new ModIntegerRing(modul.getVal());
        mfac = new GenPolynomialRing(mcfac, fac);
        lift = PolyUtil.fromIntegerCoefficients(mfac, Fi);
        return lift;
    }
}

