/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.Coefficients;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.Multiply;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.Negate;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.Subtract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.Sum;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.UnivPowerSeriesRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.BinaryFunctor;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.UnaryFunctor;

public class UnivPowerSeries<C extends RingElem<C>>
implements RingElem<UnivPowerSeries<C>> {
    public final UnivPowerSeriesRing<C> ring;
    Coefficients<C> lazyCoeffs;
    private int truncate = 11;
    private int order = -1;

    private UnivPowerSeries() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    public UnivPowerSeries(UnivPowerSeriesRing<C> ring, Coefficients<C> lazyCoeffs) {
        if (lazyCoeffs == null || ring == null) {
            throw new IllegalArgumentException("null not allowed: ring = " + ring + ", lazyCoeffs = " + lazyCoeffs);
        }
        this.ring = ring;
        this.lazyCoeffs = lazyCoeffs;
        this.truncate = ring.truncate;
    }

    @Override
    public UnivPowerSeriesRing<C> factory() {
        return this.ring;
    }

    @Override
    public UnivPowerSeries<C> copy() {
        return new UnivPowerSeries<C>(this.ring, this.lazyCoeffs);
    }

    public String toString() {
        return this.toString(this.truncate);
    }

    public String toString(int truncate) {
        StringBuilder sb = new StringBuilder();
        UnivPowerSeries s = this;
        String var = this.ring.var;
        for (int i = 0; i < truncate; ++i) {
            Object c = s.coefficient(i);
            int si = c.signum();
            if (si == 0) continue;
            if (si > 0) {
                if (sb.length() > 0) {
                    sb.append(" + ");
                }
            } else {
                c = (RingElem)c.negate();
                sb.append(" - ");
            }
            if (!c.isONE() || i == 0) {
                if (c instanceof GenPolynomial || c instanceof AlgebraicNumber) {
                    sb.append("{ ");
                }
                sb.append(c.toString());
                if (c instanceof GenPolynomial || c instanceof AlgebraicNumber) {
                    sb.append(" }");
                }
                if (i > 0) {
                    sb.append(" * ");
                }
            }
            if (i == 0) continue;
            if (i == 1) {
                sb.append(var);
                continue;
            }
            sb.append(var).append("^").append(i);
        }
        if (sb.length() == 0) {
            sb.append("0");
        }
        sb.append(" + BigO(").append(var).append("^").append(truncate).append(")");
        return sb.toString();
    }

    public C coefficient(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index not allowed");
        }
        return this.lazyCoeffs.get(index);
    }

    public C leadingCoefficient() {
        return this.coefficient(0);
    }

    public UnivPowerSeries<C> shift(final int k) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                if (i - k < 0) {
                    return (RingElem)UnivPowerSeries.this.ring.coFac.getZERO();
                }
                return UnivPowerSeries.this.coefficient(i - k);
            }
        });
    }

    public UnivPowerSeries<C> map(final UnaryFunctor<? super C, C> f) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                return (RingElem)f.eval(UnivPowerSeries.this.coefficient(i));
            }
        });
    }

    public <C2 extends RingElem<C2>> UnivPowerSeries<C> zip(final BinaryFunctor<? super C, ? super C2, C> f, final UnivPowerSeries<C2> ps) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                return (RingElem)f.eval(UnivPowerSeries.this.coefficient(i), ps.coefficient(i));
            }
        });
    }

    @Override
    public UnivPowerSeries<C> sum(UnivPowerSeries<C> ps) {
        return this.zip(new Sum(), ps);
    }

    @Override
    public UnivPowerSeries<C> subtract(UnivPowerSeries<C> ps) {
        return this.zip(new Subtract(), ps);
    }

    @Override
    public UnivPowerSeries<C> multiply(C c) {
        return this.map(new Multiply<C>(c));
    }

    @Override
    public UnivPowerSeries<C> negate() {
        return this.map(new Negate());
    }

    @Override
    public UnivPowerSeries<C> abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public int order() {
        if (this.order < 0) {
            for (int i = 0; i <= this.truncate; ++i) {
                if (this.coefficient(i).isZERO()) continue;
                this.order = i;
                return this.order;
            }
            this.order = this.truncate + 1;
        }
        return this.order;
    }

    @Override
    public int signum() {
        return this.coefficient(this.order()).signum();
    }

    @Override
    public int compareTo(UnivPowerSeries<C> ps) {
        int n;
        int m = this.order();
        int pos = m <= (n = ps.order()) ? m : n;
        int s = 0;
        while ((s = this.coefficient(pos).compareTo(ps.coefficient(pos))) == 0 && ++pos <= this.truncate) {
        }
        return s;
    }

    @Override
    public boolean isZERO() {
        return this.compareTo(this.ring.ZERO) == 0;
    }

    @Override
    public boolean isONE() {
        return this.compareTo(this.ring.ONE) == 0;
    }

    @Override
    public boolean equals(Object B) {
        UnivPowerSeries a = null;
        try {
            a = (UnivPowerSeries)B;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (int i = 0; i <= this.truncate; ++i) {
            h += this.coefficient(i).hashCode();
            h <<= 23;
        }
        return h;
    }

    @Override
    public boolean isUnit() {
        return this.leadingCoefficient().isUnit();
    }

    @Override
    public UnivPowerSeries<C> multiply(final UnivPowerSeries<C> ps) {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                RingElem c = null;
                for (int k = 0; k <= i; ++k) {
                    RingElem m = (RingElem)UnivPowerSeries.this.coefficient(k).multiply(ps.coefficient(i - k));
                    c = c == null ? m : c.sum(m);
                }
                return c;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> inverse() {
        return new UnivPowerSeries<C>(this.ring, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                RingElem d = (RingElem)UnivPowerSeries.this.leadingCoefficient().inverse();
                if (i == 0) {
                    return d;
                }
                MonoidElem c = null;
                for (int k = 0; k < i; ++k) {
                    RingElem m = (RingElem)this.get(k).multiply(UnivPowerSeries.this.coefficient(i - k));
                    c = c == null ? m : c.sum(m);
                }
                c = (RingElem)c.multiply((MonoidElem)d.negate());
                return c;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> divide(UnivPowerSeries<C> ps) {
        int n;
        if (ps.isUnit()) {
            return this.multiply((UnivPowerSeries<C>)ps.inverse());
        }
        int m = this.order();
        if (m < (n = ps.order())) {
            return this.ring.getZERO();
        }
        if (!ps.coefficient(n).isUnit()) {
            throw new ArithmeticException("division by non unit coefficient " + ps.coefficient(n) + ", n = " + n);
        }
        UnivPowerSeries<C> st = m == 0 ? this : this.shift(-m);
        UnivPowerSeries<C> sps = n == 0 ? ps : ps.shift(-n);
        UnivPowerSeries<C> q = st.multiply((UnivPowerSeries<C>)sps.inverse());
        UnivPowerSeries<C> sq = m == n ? q : q.shift(m - n);
        return sq;
    }

    @Override
    public UnivPowerSeries<C> remainder(UnivPowerSeries<C> ps) {
        int n;
        int m = this.order();
        if (m >= (n = ps.order())) {
            return this.ring.getZERO();
        }
        return this;
    }

    @Override
    public UnivPowerSeries<C> gcd(UnivPowerSeries<C> ps) {
        int n;
        if (ps.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return ps;
        }
        int m = this.order();
        int ll = m < (n = ps.order()) ? m : n;
        return ((UnivPowerSeries)this.ring.getONE()).shift(ll);
    }

    public UnivPowerSeries<C>[] egcd(UnivPowerSeries<C> S) {
        throw new UnsupportedOperationException("egcd for power series not implemented");
    }
}

