/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigIntegerIterator;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class BigInteger
implements GcdRingElem<BigInteger>,
RingFactory<BigInteger>,
Iterable<BigInteger> {
    public final java.math.BigInteger val;
    private static final Random random = new Random();
    public static final BigInteger ZERO = new BigInteger(java.math.BigInteger.ZERO);
    public static final BigInteger ONE = new BigInteger(java.math.BigInteger.ONE);
    private boolean nonNegative = true;

    public BigInteger(java.math.BigInteger a) {
        this.val = a;
    }

    public BigInteger(long a) {
        this.val = new java.math.BigInteger(String.valueOf(a));
    }

    public BigInteger(String s) {
        this.val = new java.math.BigInteger(s.trim());
    }

    public BigInteger() {
        this.val = java.math.BigInteger.ZERO;
    }

    public java.math.BigInteger getVal() {
        return this.val;
    }

    public long longValue() {
        return this.val.longValue();
    }

    public BigInteger factory() {
        return this;
    }

    @Override
    public List<BigInteger> generators() {
        ArrayList<BigInteger> g = new ArrayList<BigInteger>(1);
        g.add(this.getONE());
        return g;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigInteger copy() {
        return new BigInteger(this.val);
    }

    @Override
    public BigInteger copy(BigInteger c) {
        return new BigInteger(c.val);
    }

    @Override
    public BigInteger getZERO() {
        return ZERO;
    }

    @Override
    public BigInteger getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return java.math.BigInteger.ZERO;
    }

    @Override
    public BigInteger fromInteger(java.math.BigInteger a) {
        return new BigInteger(a);
    }

    public static BigInteger valueOf(java.math.BigInteger a) {
        return new BigInteger(a);
    }

    @Override
    public BigInteger fromInteger(long a) {
        return new BigInteger(a);
    }

    public static BigInteger valueOf(long a) {
        return new BigInteger(a);
    }

    @Override
    public boolean isZERO() {
        return this.val.equals(java.math.BigInteger.ZERO);
    }

    @Override
    public boolean isONE() {
        return this.val.equals(java.math.BigInteger.ONE);
    }

    @Override
    public boolean isUnit() {
        return this.isONE() || this.negate().isONE();
    }

    public String toString() {
        return this.val.toString();
    }

    @Override
    public int compareTo(BigInteger b) {
        return this.val.compareTo(b.val);
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof BigInteger)) {
            return false;
        }
        BigInteger bi = (BigInteger)b;
        return this.val.equals(bi.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public BigInteger abs() {
        return new BigInteger(this.val.abs());
    }

    @Override
    public BigInteger negate() {
        return new BigInteger(this.val.negate());
    }

    @Override
    public int signum() {
        return this.val.signum();
    }

    @Override
    public BigInteger subtract(BigInteger S) {
        return new BigInteger(this.val.subtract(S.val));
    }

    @Override
    public BigInteger divide(BigInteger S) {
        return new BigInteger(this.val.divide(S.val));
    }

    @Override
    public BigInteger inverse() {
        if (this.isONE() || this.negate().isONE()) {
            return this;
        }
        return ZERO;
    }

    @Override
    public BigInteger remainder(BigInteger S) {
        return new BigInteger(this.val.remainder(S.val));
    }

    public BigInteger[] quotientRemainder(BigInteger S) {
        BigInteger[] qr = new BigInteger[2];
        java.math.BigInteger[] C = this.val.divideAndRemainder(S.val);
        qr[0] = new BigInteger(C[0]);
        qr[1] = new BigInteger(C[1]);
        return qr;
    }

    @Override
    public BigInteger gcd(BigInteger S) {
        return new BigInteger(this.val.gcd(S.val));
    }

    public BigInteger[] egcd(BigInteger S) {
        BigInteger[] ret = new BigInteger[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        BigInteger q = this;
        BigInteger r = S;
        BigInteger c1 = ONE;
        BigInteger d1 = ZERO;
        BigInteger c2 = ZERO;
        BigInteger d2 = ONE;
        while (!r.isZERO()) {
            BigInteger[] qr = q.quotientRemainder(r);
            q = qr[0];
            BigInteger x1 = c1.subtract(q.multiply(d1));
            BigInteger x2 = c2.subtract(q.multiply(d2));
            c1 = d1;
            c2 = d2;
            d1 = x1;
            d2 = x2;
            q = r;
            r = qr[1];
        }
        if (q.signum() < 0) {
            q = q.negate();
            c1 = c1.negate();
            c2 = c2.negate();
        }
        ret[0] = q;
        ret[1] = c1;
        ret[2] = c2;
        return ret;
    }

    @Override
    public BigInteger random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigInteger random(int n, Random rnd) {
        java.math.BigInteger r = new java.math.BigInteger(n, rnd);
        if (rnd.nextBoolean()) {
            r = r.negate();
        }
        return new BigInteger(r);
    }

    @Override
    public BigInteger multiply(BigInteger S) {
        return new BigInteger(this.val.multiply(S.val));
    }

    @Override
    public BigInteger sum(BigInteger S) {
        return new BigInteger(this.val.add(S.val));
    }

    public void setAllIterator() {
        this.nonNegative = false;
    }

    public void setNonNegativeIterator() {
        this.nonNegative = true;
    }

    @Override
    public Iterator<BigInteger> iterator() {
        return new BigIntegerIterator(this.nonNegative);
    }
}

