/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.iterator;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.iterator.TraverseGuide;
import cc.redberry.core.tensor.iterator.TraverseState;
import cc.redberry.core.tensor.iterator.TreeIterator;
import cc.redberry.core.tensor.iterator.TreeTraverseIterator;

abstract class TreeIteratorAbstract
implements TreeIterator {
    private final TreeTraverseIterator iterator;
    private final TraverseState state;

    TreeIteratorAbstract(Tensor tensor, TraverseGuide guide, TraverseState state) {
        this.iterator = new TreeTraverseIterator(tensor, guide);
        this.state = state;
    }

    TreeIteratorAbstract(Tensor tensor, TraverseState state) {
        this.iterator = new TreeTraverseIterator(tensor);
        this.state = state;
    }

    @Override
    public int depth() {
        return this.iterator.depth();
    }

    @Override
    public Tensor next() {
        TraverseState nextState;
        while ((nextState = this.iterator.next()) != this.state && nextState != null) {
        }
        if (nextState == null) {
            return null;
        }
        return this.iterator.current();
    }

    @Override
    public Tensor result() {
        return this.iterator.result();
    }

    @Override
    public void set(Tensor tensor) {
        this.iterator.set(tensor);
    }
}

