/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.graph.GraphType;
import cc.redberry.core.graph.GraphUtils;
import cc.redberry.core.graph.PrimitiveSubgraph;
import cc.redberry.core.graph.PrimitiveSubgraphPartition;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.number.Complex;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.MultiTensor;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.ProductBuilder;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.ProductFactory;
import cc.redberry.core.tensor.StructureOfContractions;
import cc.redberry.core.tensor.StructureOfContractionsHashed;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorContraction;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.BitArray;
import cc.redberry.core.utils.HashFunctions;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.SoftReferenceWrapper;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public final class Product
extends MultiTensor {
    final Complex factor;
    final Tensor[] indexlessData;
    final Tensor[] data;
    final SoftReferenceWrapper<ProductContent> contentReference;
    int hash;
    private static final long dummyTensorInfo = -65536L;

    Product(Indices indices, Complex factor, Tensor[] indexless, Tensor[] data) {
        super(indices);
        this.factor = Product.getDefaultReference(factor);
        this.indexlessData = indexless;
        this.data = data;
        Arrays.sort(data);
        Arrays.sort(indexless);
        this.contentReference = new SoftReferenceWrapper();
        this.calculateContent();
        this.hash = this.calculateHash();
    }

    Product(Complex factor, Tensor[] indexlessData, Tensor[] data, ProductContent content, Indices indices) {
        super(indices);
        this.factor = Product.getDefaultReference(factor);
        this.indexlessData = indexlessData;
        this.data = data;
        this.contentReference = new SoftReferenceWrapper();
        if (content == null) {
            this.calculateContent();
        } else {
            this.contentReference.resetReferent(content);
        }
        this.hash = this.calculateHash();
    }

    Product(Indices indices, Complex factor, Tensor[] indexlessData, Tensor[] data, SoftReferenceWrapper<ProductContent> contentReference, int hash) {
        super(indices);
        this.factor = factor;
        this.indexlessData = indexlessData;
        this.data = data;
        this.contentReference = contentReference;
        this.hash = hash;
    }

    Product(Indices indices, Complex factor, Tensor[] indexlessData, Tensor[] data, SoftReferenceWrapper<ProductContent> contentReference) {
        super(indices);
        this.factor = factor;
        this.indexlessData = indexlessData;
        this.data = data;
        this.contentReference = contentReference;
        this.hash = this.calculateHash();
    }

    private static Complex getDefaultReference(Complex factor) {
        return factor.isOne() ? Complex.ONE : (factor.isMinusOne() ? Complex.MINUS_ONE : factor);
    }

    @Override
    public Indices getIndices() {
        return this.indices;
    }

    @Override
    public Tensor get(int i) {
        if (this.factor != Complex.ONE) {
            --i;
        }
        if (i == -1) {
            return this.factor;
        }
        if (i < this.indexlessData.length) {
            return this.indexlessData[i];
        }
        return this.data[i - this.indexlessData.length];
    }

    @Override
    public Tensor[] getRange(int from, int to) {
        if (from < 0 || to > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
        int indexlessMaxPos = this.indexlessData.length;
        Tensor[] result = new Tensor[to - from];
        if (to == from) {
            return result;
        }
        int n = 0;
        if (this.factor != Complex.ONE) {
            if (from == 0) {
                result[0] = this.factor;
                ++n;
            } else {
                --from;
            }
            --to;
        }
        if (to < indexlessMaxPos) {
            System.arraycopy(this.indexlessData, from, result, n, to - from);
        } else if (from < indexlessMaxPos) {
            System.arraycopy(this.indexlessData, from, result, n, indexlessMaxPos - from);
            System.arraycopy(this.data, 0, result, indexlessMaxPos - from + n, to - indexlessMaxPos);
        } else {
            System.arraycopy(this.data, from - indexlessMaxPos, result, n, to - from);
        }
        return result;
    }

    @Override
    public int size() {
        int size = this.data.length + this.indexlessData.length;
        if (this.factor == Complex.ONE) {
            return size;
        }
        return size + 1;
    }

    public int sizeWithoutFactor() {
        return this.data.length + this.indexlessData.length;
    }

    public int sizeOfIndexlessPart() {
        return this.indexlessData.length + (this.factor == Complex.ONE ? 0 : 1);
    }

    @Override
    public Tensor set(int i, Tensor tensor) {
        Boolean compare;
        if (i >= this.size() || i < 0) {
            throw new IndexOutOfBoundsException();
        }
        Tensor old = this.get(i);
        if (old == tensor) {
            return this;
        }
        if (TensorUtils.equalsExactly(old, tensor)) {
            return this;
        }
        if (tensor instanceof Complex) {
            return this.setComplex(i, (Complex)tensor);
        }
        int size = this.size();
        if (TensorUtils.passOutDummies(tensor)) {
            TIntHashSet forbidden = new TIntHashSet();
            for (int j = 0; j < size; ++j) {
                if (j == i) continue;
                TensorUtils.appendAllIndicesNamesT(this.get(j), forbidden);
            }
            tensor = ApplyIndexMapping.renameDummy(tensor, forbidden.toArray());
        }
        if ((compare = TensorUtils.compare1(old, tensor)) == null) {
            return super.set(i, tensor);
        }
        Complex newFactor = this.factor;
        if (compare.booleanValue()) {
            tensor = Tensors.negate(tensor);
            newFactor = this.factor.negate();
            newFactor = Product.getDefaultReference(newFactor);
        }
        if (this.factor != Complex.ONE) {
            assert (i != 0);
            --i;
        }
        if (i < this.indexlessData.length) {
            Tensor[] newIndexless = (Tensor[])this.indexlessData.clone();
            newIndexless[i] = tensor;
            return new Product(this.indices, newFactor, newIndexless, this.data, this.contentReference);
        }
        Tensor[] newData = (Tensor[])this.data.clone();
        newData[i - this.indexlessData.length] = tensor;
        return new Product(new IndicesBuilder().append(newData).getIndices(), newFactor, this.indexlessData, newData);
    }

    @Override
    public Tensor remove(int position) {
        return this.setComplex(position, Complex.ONE);
    }

    private Tensor setComplex(int i, Complex complex) {
        if (NumberUtils.isZeroOrIndeterminate(complex)) {
            return complex;
        }
        if (this.factor != Complex.ONE) {
            if (i == 0) {
                if (complex.isOne()) {
                    if (this.data.length == 1 && this.indexlessData.length == 0) {
                        return this.data[0];
                    }
                    if (this.data.length == 0 && this.indexlessData.length == 1) {
                        return this.indexlessData[0];
                    }
                }
                complex = Product.getDefaultReference(complex);
                return new Product(this.indices, complex, this.indexlessData, this.data, this.contentReference);
            }
            complex = complex.multiply(this.factor);
            complex = Product.getDefaultReference(complex);
            --i;
        }
        if (complex.isOne()) {
            if (this.data.length == 2 && this.indexlessData.length == 0) {
                return this.data[1 - i];
            }
            if (this.data.length == 0 && this.indexlessData.length == 2) {
                return this.indexlessData[1 - i];
            }
            if (this.data.length == 1 && this.indexlessData.length == 1) {
                return i == 0 ? this.data[0] : this.indexlessData[0];
            }
        }
        if (this.data.length == 1 && this.indexlessData.length == 0 || this.data.length == 0 && this.indexlessData.length == 1) {
            return complex;
        }
        if (i < this.indexlessData.length) {
            Tensor[] newIndexless = ArraysUtils.remove(this.indexlessData, i);
            return new Product(this.indices, complex, newIndexless, this.data, this.contentReference);
        }
        Tensor[] newData = ArraysUtils.remove(this.data, i - this.indexlessData.length);
        return new Product(new IndicesBuilder().append(newData).getIndices(), complex, this.indexlessData, newData);
    }

    @Override
    protected Tensor remove1(int[] positions) {
        int dataFrom;
        Complex newFactor = this.factor;
        if (this.factor != Complex.ONE) {
            if (positions[0] == 0) {
                newFactor = Complex.ONE;
                positions = Arrays.copyOfRange(positions, 1, positions.length);
            }
            int i = positions.length - 1;
            while (i >= 0) {
                int n = i--;
                positions[n] = positions[n] - 1;
            }
        }
        if ((dataFrom = Arrays.binarySearch(positions, this.indexlessData.length - 1)) < 0) {
            dataFrom = ~dataFrom - 1;
        }
        int[] indexlessPositions = Arrays.copyOfRange(positions, 0, dataFrom + 1);
        int[] dataPositions = Arrays.copyOfRange(positions, dataFrom + 1, positions.length);
        int i = 0;
        while (i < dataPositions.length) {
            int n = i++;
            dataPositions[n] = dataPositions[n] - this.indexlessData.length;
        }
        Tensor[] newIndexless = ArraysUtils.remove(this.indexlessData, indexlessPositions);
        Tensor[] newData = ArraysUtils.remove(this.data, dataPositions);
        return Product.createProduct(new IndicesBuilder().append(newData).getIndices(), newFactor, newIndexless, newData);
    }

    @Override
    protected Complex getNeutral() {
        return Complex.ONE;
    }

    @Override
    protected Tensor select1(int[] positions) {
        int add = this.factor == Complex.ONE ? 0 : 1;
        Complex newFactor = Complex.ONE;
        ArrayList<Tensor> newIndexless = new ArrayList<Tensor>();
        ArrayList<Tensor> newData = new ArrayList<Tensor>();
        for (int position : positions) {
            if ((position -= add) == -1) {
                newFactor = this.factor;
                continue;
            }
            if (position < this.indexlessData.length) {
                newIndexless.add(this.indexlessData[position]);
                continue;
            }
            newData.add(this.data[position - this.indexlessData.length]);
        }
        return new Product(new IndicesBuilder().append(newData).getIndices(), newFactor, newIndexless.toArray(new Tensor[newIndexless.size()]), newData.toArray(new Tensor[newData.size()]));
    }

    private static Tensor createProduct(Indices indices, Complex factor, Tensor[] indexless, Tensor[] data) {
        if (indexless.length == 0 && data.length == 0) {
            return factor;
        }
        if (factor == Complex.ONE) {
            if (indexless.length == 0 && data.length == 1) {
                return data[0];
            }
            if (indexless.length == 1 && data.length == 0) {
                return indexless[0];
            }
        }
        return new Product(indices, factor, indexless, data);
    }

    public Tensor getWithoutFactor(int i) {
        return i < this.indexlessData.length ? this.indexlessData[i] : this.data[i - this.indexlessData.length];
    }

    public Complex getFactor() {
        return this.factor;
    }

    private int calculateHash() {
        int result = this.factor == Complex.ONE || this.factor == Complex.MINUS_ONE ? 0 : this.factor.hashCode();
        for (Tensor t : this.indexlessData) {
            result = result * 31 + t.hashCode();
        }
        for (Tensor t : this.data) {
            result = result * 17 + t.hashCode();
        }
        if (this.factor == Complex.MINUS_ONE && this.size() == 2) {
            return result;
        }
        return result - 79 * this.getContent().getStructureOfContractionsHashed().hashCode();
    }

    public ProductContent getContent() {
        ProductContent content = this.contentReference.getReference().get();
        if (content == null) {
            content = this.calculateContent();
        }
        return content;
    }

    public Tensor[] getIndexless() {
        return (Tensor[])this.indexlessData.clone();
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ProductBuilder(this.indexlessData.length, this.data.length);
    }

    public Tensor[] getAllScalars() {
        Tensor[] scalras = this.getContent().getScalars();
        if (this.factor == Complex.ONE) {
            Tensor[] allScalars = new Tensor[this.indexlessData.length + scalras.length];
            System.arraycopy(this.indexlessData, 0, allScalars, 0, this.indexlessData.length);
            System.arraycopy(scalras, 0, allScalars, this.indexlessData.length, scalras.length);
            return allScalars;
        }
        Tensor[] allScalars = new Tensor[1 + this.indexlessData.length + scalras.length];
        allScalars[0] = this.factor;
        System.arraycopy(this.indexlessData, 0, allScalars, 1, this.indexlessData.length);
        System.arraycopy(scalras, 0, allScalars, this.indexlessData.length + 1, scalras.length);
        return allScalars;
    }

    public Tensor[] getAllScalarsWithoutFactor() {
        Tensor[] scalras = this.getContent().getScalars();
        Tensor[] allScalars = new Tensor[this.indexlessData.length + scalras.length];
        System.arraycopy(this.indexlessData, 0, allScalars, 0, this.indexlessData.length);
        System.arraycopy(scalras, 0, allScalars, this.indexlessData.length, scalras.length);
        return allScalars;
    }

    public Tensor getIndexlessSubProduct() {
        if (this.indexlessData.length == 0) {
            return this.factor;
        }
        if (this.factor == Complex.ONE && this.indexlessData.length == 1) {
            return this.indexlessData[0];
        }
        return new Product(this.factor, this.indexlessData, new Tensor[0], ProductContent.EMPTY_INSTANCE, IndicesFactory.EMPTY_INDICES);
    }

    public Tensor getSubProductWithoutFactor() {
        if (this.factor == Complex.ONE) {
            return this;
        }
        return new Product(this.indices, Complex.ONE, this.indexlessData, this.data, this.contentReference);
    }

    public Tensor getDataSubProduct() {
        if (this.data.length == 0) {
            return Complex.ONE;
        }
        if (this.data.length == 1) {
            return this.data[0];
        }
        return new Product(this.indices, Complex.ONE, new Tensor[0], this.data, this.contentReference);
    }

    private ProductContent calculateContent() {
        int tensorIndex;
        int state;
        int index;
        int i;
        if (this.data.length == 0) {
            this.contentReference.resetReferent(ProductContent.EMPTY_INSTANCE);
            return ProductContent.EMPTY_INSTANCE;
        }
        Indices freeIndices = this.indices.getFree();
        int differentIndicesCount = (this.getIndices().size() + freeIndices.size()) / 2;
        int[] upperIndices = new int[differentIndicesCount];
        int[] lowerIndices = new int[differentIndicesCount];
        long[] upperInfo = new long[differentIndicesCount];
        long[] lowerInfo = new long[differentIndicesCount];
        int[][] indices = new int[][]{lowerIndices, upperIndices};
        long[][] info = new long[][]{lowerInfo, upperInfo};
        int[] pointer = new int[2];
        short[] stretchIndices = this.calculateStretchIndices();
        TensorContraction[] contractions = new TensorContraction[this.data.length];
        TensorContraction freeContraction = new TensorContraction(-1, new long[freeIndices.size()]);
        for (i = 0; i < freeIndices.size(); ++i) {
            index = freeIndices.get(i);
            state = 1 - IndicesUtils.getStateInt(index);
            info[state][pointer[state]] = -65536L;
            int n = state;
            int n2 = pointer[n];
            pointer[n] = n2 + 1;
            indices[state][n2] = IndicesUtils.getNameWithType(index);
        }
        for (tensorIndex = 0; tensorIndex < this.data.length; ++tensorIndex) {
            Indices tInds = this.data[tensorIndex].getIndices();
            short[] diffIds = tInds.getPositionsInOrbits();
            for (i = 0; i < tInds.size(); ++i) {
                index = tInds.get(i);
                state = IndicesUtils.getStateInt(index);
                info[state][pointer[state]] = Product.packToLong(tensorIndex, stretchIndices[tensorIndex], diffIds[i]);
                int n = state;
                int n3 = pointer[n];
                pointer[n] = n3 + 1;
                indices[state][n3] = IndicesUtils.getNameWithType(index);
            }
            contractions[tensorIndex] = new TensorContraction(stretchIndices[tensorIndex], new long[tInds.size()]);
        }
        ArraysUtils.quickSort(indices[0], info[0]);
        ArraysUtils.quickSort(indices[1], info[1]);
        int[] components = GraphUtils.calculateConnectedComponents(Product.infoToTensorIndices(upperInfo), Product.infoToTensorIndices(lowerInfo), this.data.length + 1);
        int componentCount = components[components.length - 1];
        int[] componentSizes = new int[componentCount];
        for (i = 1; i < components.length - 1; ++i) {
            int n = components[i];
            componentSizes[n] = componentSizes[n] + 1;
        }
        Tensor[][] datas = new Tensor[componentCount][];
        for (i = 0; i < componentCount; ++i) {
            datas[i] = new Tensor[componentSizes[i]];
        }
        Arrays.fill(componentSizes, 0);
        for (i = 1; i < this.data.length + 1; ++i) {
            int n = components[i];
            int n4 = componentSizes[n];
            componentSizes[n] = n4 + 1;
            datas[components[i]][n4] = this.data[i - 1];
        }
        Tensor nonScalar = null;
        if (componentCount == 1) {
            nonScalar = this.data.length == 1 ? this.data[0] : new Product(this.indices, Complex.ONE, new Tensor[0], this.data, this.contentReference, 0);
        } else if (datas[0].length > 0) {
            nonScalar = Tensors.multiply(datas[0]);
        }
        Object[] scalars = new Tensor[componentCount - 1];
        if (nonScalar == null && componentCount == 2 && this.factor == Complex.ONE && this.indexlessData.length == 0) {
            scalars[0] = this;
        } else {
            for (i = 1; i < componentCount; ++i) {
                scalars[i - 1] = Tensors.multiply(datas[i]);
            }
            Arrays.sort(scalars);
        }
        assert (Arrays.equals(indices[0], indices[1]));
        int[] pointers = new int[this.data.length];
        int freePointer = 0;
        for (i = 0; i < differentIndicesCount; ++i) {
            tensorIndex = (int)(info[0][i] >> 32);
            long contraction = 0xFFFF00000000L & info[0][i] << 32 | 0xFFFFFFFFL & info[1][i];
            if (tensorIndex == -1) {
                freeContraction.indexContractions[freePointer++] = contraction;
            } else {
                int n = tensorIndex;
                int n5 = pointers[n];
                pointers[n] = n5 + 1;
                contractions[tensorIndex].indexContractions[n5] = contraction;
            }
            tensorIndex = (int)(info[1][i] >> 32);
            contraction = 0xFFFF00000000L & info[1][i] << 32 | 0xFFFFFFFFL & info[0][i];
            if (tensorIndex == -1) {
                freeContraction.indexContractions[freePointer++] = contraction;
                continue;
            }
            int n = tensorIndex;
            int n6 = pointers[n];
            pointers[n] = n6 + 1;
            contractions[tensorIndex].indexContractions[n6] = contraction;
        }
        for (TensorContraction contraction : contractions) {
            contraction.sortContractions();
        }
        freeContraction.sortContractions();
        int[] inds = IndicesUtils.getIndicesNames(this.indices.getFree());
        Arrays.sort(inds);
        Comparable[] wrappers = new ScaffoldWrapper[contractions.length];
        for (i = 0; i < contractions.length; ++i) {
            wrappers[i] = new ScaffoldWrapper(inds, components[i + 1], this.data[i], contractions[i]);
        }
        ArraysUtils.quickSort((Comparable[])wrappers, (Object[])this.data);
        for (i = 0; i < contractions.length; ++i) {
            contractions[i] = ((ScaffoldWrapper)wrappers[i]).tc;
        }
        StructureOfContractionsHashed structureOfContractionsHashed = new StructureOfContractionsHashed(freeContraction, contractions);
        StructureOfContractions structureOfContractions = new StructureOfContractions(this.data, differentIndicesCount, freeIndices);
        ProductContent content = new ProductContent(structureOfContractionsHashed, structureOfContractions, (Tensor[])scalars, nonScalar, stretchIndices, this.data);
        this.contentReference.resetReferent(content);
        if (componentCount == 1 && nonScalar instanceof Product) {
            ((Product)nonScalar).hash = ((Product)nonScalar).calculateHash();
        }
        return content;
    }

    private short[] calculateStretchIndices() {
        short[] stretchIndex = new short[this.data.length];
        short index = 0;
        int oldHash = this.data[0].hashCode();
        for (int i = 1; i < this.data.length; ++i) {
            if (oldHash == this.data[i].hashCode()) {
                stretchIndex[i] = index;
                continue;
            }
            stretchIndex[i] = index = (short)(index + 1);
            oldHash = this.data[i].hashCode();
        }
        return stretchIndex;
    }

    @Override
    protected int hash() {
        return this.hash;
    }

    @Override
    public TensorFactory getFactory() {
        return ProductFactory.FACTORY;
    }

    private static long packToLong(int tensorIndex, short stretchIndex, short id) {
        return (long)tensorIndex << 32 | 0xFFFF0000L & (long)(stretchIndex << 16) | 0xFFFFL & (long)id;
    }

    private static int[] infoToTensorIndices(long[] info) {
        int[] result = new int[info.length];
        for (int i = 0; i < info.length; ++i) {
            result[i] = (int)(info[i] >> 32) + 1;
        }
        return result;
    }

    private static int hc(Tensor t, int[] inds) {
        Indices ind = t.getIndices().getFree();
        int h = 31;
        for (int i = ind.size() - 1; i >= 0; --i) {
            int ii = IndicesUtils.getNameWithType(ind.get(i));
            if ((ii = Arrays.binarySearch(inds, ii)) < 0) continue;
            h ^= HashFunctions.JenkinWang32shift(ii);
        }
        return h;
    }

    @Override
    public String toString(OutputFormat format) {
        EnumSet<IndexType> matrixTypes;
        int size;
        char operatorChar;
        StringBuilder sb = new StringBuilder();
        char c = operatorChar = format == OutputFormat.LaTeX ? (char)' ' : '*';
        if (this.factor.isReal() && this.factor.getReal().signum() < 0) {
            sb.append('-');
            Complex f = this.factor.abs();
            if (!f.isOne()) {
                sb.append(((Tensor)f).toString(format, Product.class)).append(operatorChar);
            }
        } else if (this.factor != Complex.ONE) {
            sb.append(((Tensor)this.factor).toString(format, Product.class)).append(operatorChar);
        }
        int n = size = this.factor == Complex.ONE ? this.size() : this.size() - 1;
        for (int i = 0; i < this.indexlessData.length; ++i) {
            sb.append(this.indexlessData[i].toString(format, Product.class));
            if (i == size - 1) {
                return sb.toString();
            }
            sb.append(operatorChar);
        }
        if (format.printMatrixIndices || (matrixTypes = IndicesUtils.nonMetricTypes(this.indices)).isEmpty()) {
            return this.printData(sb, format, operatorChar);
        }
        return this.printMatrices(sb, format, operatorChar, matrixTypes);
    }

    private String printData(StringBuilder sb, OutputFormat format, char operatorChar) {
        int i = 0;
        while (true) {
            sb.append(this.data[i].toString(format, Product.class));
            if (i == this.data.length - 1) break;
            sb.append(operatorChar);
            ++i;
        }
        Product.removeLastOperatorChar(sb, operatorChar);
        return sb.toString();
    }

    private String printMatrices(StringBuilder sb, OutputFormat format, char operatorChar, EnumSet<IndexType> matrixTypes) {
        sb.append((Product)this.new MatricesPrinter((OutputFormat)format, (char)operatorChar, matrixTypes).sb.toString());
        Product.removeLastOperatorChar(sb, operatorChar);
        return sb.toString();
    }

    static void removeLastOperatorChar(StringBuilder sb, char operatorChar) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == operatorChar) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    static boolean intersects(TIntHashSet a, TIntHashSet b) {
        a = new TIntHashSet((TIntCollection)a);
        a.retainAll((TIntCollection)b);
        return a.size() != 0;
    }

    @Override
    protected String toString(OutputFormat mode, Class<? extends Tensor> clazz) {
        if (clazz == Power.class) {
            return "(" + this.toString(mode) + ")";
        }
        return this.toString(mode);
    }

    private static class SubgraphContainer {
        private final List<IndexType> types = new ArrayList<IndexType>();
        private final GraphType graphType;
        private final int[] partition;
        private final TIntHashSet points;

        private SubgraphContainer(GraphType graphType, int[] partition, TIntHashSet points, IndexType type) {
            this.graphType = graphType;
            this.partition = partition;
            this.points = points;
            this.types.add(type);
        }
    }

    private final class MatricesPrinter {
        final OutputFormat format;
        final char operatorChar;
        final EnumSet<IndexType> matrixTypes;
        final BitArray matrixPrint;
        final BitArray graphPrint;
        final StringBuilder sb;

        private MatricesPrinter(OutputFormat format, char operatorChar, EnumSet<IndexType> matrixTypes) {
            this.matrixPrint = new BitArray(Product.this.data.length);
            this.graphPrint = new BitArray(Product.this.data.length);
            this.sb = new StringBuilder();
            this.format = format;
            this.operatorChar = operatorChar;
            this.matrixTypes = matrixTypes;
            this.printData();
        }

        void fillGraphPrint(int[] partition) {
            for (int i : partition) {
                this.graphPrint.set(i);
                this.matrixPrint.set(i);
            }
        }

        void printData() {
            ArrayList<SubgraphContainer> subgraphs = new ArrayList<SubgraphContainer>();
            for (IndexType type : this.matrixTypes) {
                PrimitiveSubgraph[] sgs;
                block1: for (PrimitiveSubgraph sg : sgs = PrimitiveSubgraphPartition.calculatePartition(Product.this.getContent(), type)) {
                    int[] partition = sg.getPartition();
                    TIntHashSet points = new TIntHashSet(partition);
                    boolean newSg = true;
                    boolean newGraph = false;
                    IntArrayList matched = new IntArrayList();
                    for (int i = subgraphs.size() - 1; i >= 0; --i) {
                        SubgraphContainer container = (SubgraphContainer)subgraphs.get(i);
                        if (points.equals((Object)container.points)) {
                            if (container.graphType != sg.getGraphType() || !Arrays.equals(container.partition, partition)) {
                                this.fillGraphPrint(((SubgraphContainer)subgraphs.get(i)).partition);
                                subgraphs.remove(i);
                                continue block1;
                            }
                            container.types.add(type);
                            newSg = false;
                            matched.add(i);
                            continue;
                        }
                        if (!Product.intersects(points, container.points)) continue;
                        this.fillGraphPrint(((SubgraphContainer)subgraphs.get(i)).partition);
                        subgraphs.remove(i);
                        newSg = false;
                        newGraph = true;
                        for (int j = 0; j < matched.size(); ++j) {
                            this.fillGraphPrint(((SubgraphContainer)subgraphs.get(matched.get(j))).partition);
                            subgraphs.remove(matched.get(j));
                        }
                    }
                    if (newSg) {
                        subgraphs.add(new SubgraphContainer(sg.getGraphType(), partition, points, type));
                        continue;
                    }
                    if (!newGraph) continue;
                    this.fillGraphPrint(partition);
                }
            }
            for (int i = 0; i < subgraphs.size(); ++i) {
                SubgraphContainer subgraph = (SubgraphContainer)subgraphs.get(i);
                int ppLength = this.sb.length();
                if (subgraph.graphType == GraphType.Cycle) {
                    this.printTrace(subgraph);
                } else if (subgraph.graphType == GraphType.Line) {
                    this.printProductOfMatrices(subgraph);
                } else {
                    for (int j = 0; j < subgraph.partition.length; ++j) {
                        this.matrixPrint.set(subgraph.partition[j]);
                        this.graphPrint.set(subgraph.partition[j]);
                    }
                    continue;
                }
                if (i == subgraphs.size() - 1) break;
                if (this.sb.length() == ppLength) continue;
                this.sb.append(this.operatorChar);
            }
            this.removeLastOperatorChar();
            if (!this.graphPrint.isEmpty()) {
                if (this.sb.length() != 0) {
                    this.sb.append(this.operatorChar);
                }
                OutputFormat printMatrixIndices = this.format.printMatrixIndices();
                for (int i = 0; i < Product.this.data.length; ++i) {
                    if (!this.graphPrint.get(i)) continue;
                    this.sb.append(Product.this.data[i].toString(printMatrixIndices, Product.class));
                    this.sb.append(this.operatorChar);
                }
                this.removeLastOperatorChar();
            }
            if (this.matrixPrint.isFull()) {
                return;
            }
            if (this.sb.length() != 0) {
                this.sb.append(this.operatorChar);
            }
            for (int i = 0; i < Product.this.data.length; ++i) {
                if (this.matrixPrint.get(i)) continue;
                this.sb.append(Product.this.data[i].toString(this.format, Product.class));
                this.sb.append(this.operatorChar);
            }
            this.removeLastOperatorChar();
        }

        void removeLastOperatorChar() {
            Product.removeLastOperatorChar(this.sb, this.operatorChar);
        }

        void printTrace(SubgraphContainer subgraph) {
            if (subgraph.partition.length == 1 && Tensors.isKronecker(Product.this.data[subgraph.partition[0]])) {
                int position = subgraph.partition[0];
                this.matrixPrint.set(position);
                this.sb.append(Product.this.data[position].toString(this.format.printMatrixIndices(), Product.class));
            } else {
                this.sb.append("Tr[");
                this.printProductOfMatrices(subgraph);
                if (subgraph.types.size() > 1) {
                    this.sb.append(", ");
                    int i = 0;
                    while (true) {
                        this.sb.append(subgraph.types.get(i));
                        if (i == subgraph.types.size() - 1) break;
                        this.sb.append(", ");
                        ++i;
                    }
                }
                this.sb.append("]");
            }
        }

        void printProductOfMatrices(SubgraphContainer subgraph) {
            int i = 0;
            while (true) {
                int position = subgraph.partition[i];
                this.matrixPrint.set(position);
                String str = Product.this.data[position].toString(this.format, Product.class);
                this.sb.append(str);
                if (i == subgraph.partition.length - 1) {
                    return;
                }
                if (!str.isEmpty()) {
                    this.sb.append(this.operatorChar);
                }
                ++i;
            }
        }
    }

    private static class ScaffoldWrapper
    implements Comparable<ScaffoldWrapper> {
        final int[] inds;
        final int component;
        final Tensor t;
        final TensorContraction tc;
        final int hashWithIndices;

        private ScaffoldWrapper(int[] inds, int component, Tensor t, TensorContraction tc) {
            this.inds = inds;
            this.t = t;
            this.tc = tc;
            this.component = component;
            this.hashWithIndices = Product.hc(t, inds);
        }

        @Override
        public int compareTo(ScaffoldWrapper o) {
            int r = this.tc.compareTo(o.tc);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(this.hashWithIndices, o.hashWithIndices);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.component, o.component);
        }
    }
}

