/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.solver.frobenius;

import cc.redberry.core.solver.frobenius.DummySolutionProvider;
import cc.redberry.core.solver.frobenius.FinalSolutionProvider;
import cc.redberry.core.solver.frobenius.SingleSolutionProvider;
import cc.redberry.core.solver.frobenius.SolutionProvider;
import cc.redberry.core.solver.frobenius.TotalSolutionProvider;
import cc.redberry.core.utils.OutputPort;

public final class FrobeniusSolver
implements OutputPort<int[]> {
    private final OutputPort<int[]> provider;

    public FrobeniusSolver(int[] ... equations) {
        int j;
        int i;
        if (equations.length == 0) {
            throw new IllegalArgumentException();
        }
        int length = equations[0].length;
        if (length < 2) {
            throw new IllegalArgumentException();
        }
        for (i = 1; i < equations.length; ++i) {
            if (equations[i].length == length || this.assertEq(equations[i])) continue;
            throw new IllegalArgumentException();
        }
        int[] initialSolution = new int[length - 1];
        int zeroCoefficientsCount = 0;
        block1: for (i = 0; i < length - 1; ++i) {
            for (j = 0; j < equations.length; ++j) {
                if (equations[j][i] != 0) continue block1;
            }
            initialSolution[i] = -1;
            ++zeroCoefficientsCount;
        }
        int[] initialRemainders = new int[equations.length];
        for (j = 0; j < equations.length; ++j) {
            initialRemainders[j] = equations[j][length - 1];
        }
        DummySolutionProvider dummy = new DummySolutionProvider(initialSolution, initialRemainders);
        int providersCount = length - 1 - zeroCoefficientsCount;
        SolutionProvider[] providers = new SolutionProvider[providersCount];
        int count = 0;
        for (i = 0; i < length - 1; ++i) {
            if (initialSolution[i] == -1) continue;
            int[] coefficients = new int[equations.length];
            for (j = 0; j < equations.length; ++j) {
                coefficients[j] = equations[j][i];
            }
            providers[count] = count == 0 ? (providersCount == 1 ? new FinalSolutionProvider(dummy, i, coefficients) : new SingleSolutionProvider(dummy, i, coefficients)) : (count == providersCount - 1 ? new FinalSolutionProvider(providers[count - 1], i, coefficients) : new SingleSolutionProvider(providers[count - 1], i, coefficients));
            ++count;
        }
        this.provider = new TotalSolutionProvider(providers);
    }

    @Override
    public int[] take() {
        return this.provider.take();
    }

    private boolean assertEq(int[] equation) {
        for (int i : equation) {
            if (i >= 0) continue;
            return false;
        }
        return true;
    }
}

