/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.parser.BracketsError;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.parser.TokenParser;
import java.util.ArrayList;
import java.util.List;

abstract class ParserOperator
implements TokenParser {
    private char operatorSymbol;
    private char operatorInverseSymbol;

    protected ParserOperator(char operatorSymbol, char operatorInverseSymbol) {
        this.operatorSymbol = operatorSymbol;
        this.operatorInverseSymbol = operatorInverseSymbol;
    }

    protected final boolean canParse(String expression) {
        char[] expressionChars = expression.toCharArray();
        int level = 0;
        for (int i = 0; i < expressionChars.length; ++i) {
            char c = expressionChars[i];
            if (c == '(' || c == '[') {
                ++level;
            }
            if (c == ')' || c == ']') {
                --level;
            }
            if (level < 0) {
                throw new BracketsError();
            }
            if (c == this.operatorSymbol && level == 0 && this.testOperator(expressionChars, i)) {
                return true;
            }
            if (c != this.operatorInverseSymbol || level != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParseToken parseToken(String expression, Parser parser) {
        if (!this.canParse(expression)) {
            return null;
        }
        expression = expression.replace("--", "+");
        expression = expression.replace("++", "+");
        expression = expression.replace("+-", "-");
        expression = expression.replace("-+", "-");
        char[] expressionChars = expression.toCharArray();
        StringBuffer buffer = new StringBuffer();
        ArrayList<ParseToken> nodes = new ArrayList<ParseToken>();
        int level = 0;
        int indicesLevel = 0;
        Mode mode = Mode.Direct;
        for (int i = 0; i < expressionChars.length; ++i) {
            String toParse;
            char c = expressionChars[i];
            if (c == '(' || c == '[') {
                ++level;
            }
            if (c == '{') {
                ++indicesLevel;
            }
            if (c == '}') {
                --indicesLevel;
            }
            if (c == ')' || c == ']') {
                --level;
            }
            if (level < 0) {
                throw new BracketsError();
            }
            if (c == ' ' && indicesLevel == 0) continue;
            if (c == this.operatorSymbol && level == 0 && this.testOperator(expressionChars, i)) {
                toParse = buffer.toString();
                if (!toParse.isEmpty()) {
                    this.modeParser(toParse, mode, parser, nodes);
                }
                buffer = new StringBuffer();
                mode = Mode.Direct;
                continue;
            }
            if (c == this.operatorInverseSymbol && level == 0) {
                toParse = buffer.toString();
                if (!toParse.isEmpty()) {
                    this.modeParser(toParse, mode, parser, nodes);
                }
                buffer = new StringBuffer();
                mode = Mode.Inverse;
                continue;
            }
            buffer.append(c);
        }
        this.modeParser(buffer.toString(), mode, parser, nodes);
        return this.compile(nodes);
    }

    private void modeParser(String expression, Mode mode, Parser parser, List<ParseToken> nodes) {
        if (mode == Mode.Direct) {
            nodes.add(parser.parse(expression));
            return;
        }
        if (mode != Mode.Inverse) {
            throw new ParserException("unrepoted operator parser mode");
        }
        nodes.add(this.inverseOperation(parser.parse(expression)));
    }

    protected boolean testOperator(char[] expressionChars, int position) {
        return true;
    }

    protected abstract ParseToken compile(List<ParseToken> var1);

    protected abstract ParseToken inverseOperation(ParseToken var1);

    private static enum Mode {
        Direct,
        Inverse;

    }
}

