/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.parser;

import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.parser.TokenType;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import java.util.Arrays;

public class ParseToken {
    public final TokenType tokenType;
    public final ParseToken[] content;
    public ParseToken parent;

    public ParseToken(TokenType tokenType, ParseToken ... content) {
        this.tokenType = tokenType;
        this.content = content;
        for (ParseToken node : content) {
            node.setParent(this);
        }
    }

    private void setParent(ParseToken parent) {
        this.parent = parent;
    }

    public Indices getIndices() {
        switch (this.tokenType) {
            case Product: {
                IndicesBuilder builder = new IndicesBuilder();
                for (ParseToken node : this.content) {
                    builder.append(node.getIndices());
                }
                return builder.getIndices();
            }
            case Sum: {
                return IndicesFactory.create(this.content[0].getIndices());
            }
            case Power: {
                return IndicesFactory.EMPTY_INDICES;
            }
        }
        throw new ParserException("Unknown tensor type: " + (Object)((Object)this.tokenType));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.tokenType).append("[");
        for (ParseToken node : this.content) {
            builder.append(node).append(", ");
        }
        builder.deleteCharAt(builder.length() - 1).deleteCharAt(builder.length() - 1).append("]");
        return builder.toString();
    }

    public String toString(OutputFormat mode) {
        StringBuilder sb = new StringBuilder();
        switch (this.tokenType) {
            case Product: {
                char operatorChar = mode.is(OutputFormat.LaTeX) ? (char)' ' : '*';
                int i = 0;
                while (true) {
                    sb.append(this.content[i].toString(mode));
                    if (i == this.content.length - 1) {
                        return sb.toString();
                    }
                    sb.append(operatorChar);
                    ++i;
                }
            }
            case Sum: {
                sb.append("(");
                int i = 0;
                while (true) {
                    String temp;
                    if (((temp = this.content[i].toString(mode)).charAt(0) == '-' || temp.charAt(0) == '+') && sb.length() != 0) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    sb.append(this.content[i].toString(mode));
                    if (i == this.content.length - 1) {
                        return sb.append(")").toString();
                    }
                    sb.append('+');
                    ++i;
                }
            }
        }
        throw new RuntimeException("Unsupported token type.");
    }

    protected Tensor[] contentToTensors() {
        Tensor[] tensors = new Tensor[this.content.length];
        for (int i = 0; i < this.content.length; ++i) {
            tensors[i] = this.content[i].toTensor();
        }
        return tensors;
    }

    public Tensor toTensor() {
        switch (this.tokenType) {
            case Sum: {
                return Tensors.sum(this.contentToTensors());
            }
            case Power: {
                assert (this.content.length == 2);
                return Tensors.pow(this.content[0].toTensor(), this.content[1].toTensor());
            }
            case Product: {
                return Tensors.multiplyAndRenameConflictingDummies(this.contentToTensors());
            }
        }
        throw new ParserException("Unknown tensor type: " + (Object)((Object)this.tokenType));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParseToken other = (ParseToken)obj;
        if (this.tokenType != other.tokenType) {
            return false;
        }
        return Arrays.deepEquals(this.content, other.content);
    }
}

