/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number;

import cc.redberry.core.number.Number;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.number.Real;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.math3.fraction.BigFraction;

public final class Numeric
extends Real
implements Serializable {
    public static final Numeric ZERO = new Numeric(0);
    public static final Numeric ONE = new Numeric(1);
    public static final Numeric MINUS_ONE = new Numeric(-1);
    public static final Numeric POSITIVE_INFINITY = new Numeric(Double.POSITIVE_INFINITY);
    public static final Numeric NEGATIVE_INFINITY = new Numeric(Double.NEGATIVE_INFINITY);
    public static final Numeric NaN = new Numeric(Double.NaN);
    public static final Numeric MAX_VALUE = new Numeric((double)Double.MAX_VALUE);
    public static final Numeric MIN_NORMAL = new Numeric((double)Double.MIN_NORMAL);
    public static final Numeric MIN_VALUE = new Numeric((double)Double.MIN_VALUE);
    private final double value;

    public Numeric(double value) {
        this.value = value;
    }

    public Numeric(int value) {
        this.value = value;
    }

    public Numeric(float value) {
        this.value = value;
    }

    public Numeric(Number value) {
        NumberUtils.checkNotNull(value);
        this.value = value.doubleValue();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public BigInteger bigIntValue() {
        return new BigDecimal(this.value).toBigInteger();
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    public Numeric add(Real n) {
        NumberUtils.checkNotNull(n);
        return this.add(n.doubleValue());
    }

    public Numeric divide(Real n) {
        NumberUtils.checkNotNull(n);
        return this.divide(n.doubleValue());
    }

    public Numeric multiply(int n) {
        return n == 1 ? this : NumberUtils.createNumeric(this.value * (double)n);
    }

    public Numeric multiply(Real n) {
        NumberUtils.checkNotNull(n);
        return this.multiply(n.doubleValue());
    }

    public Numeric subtract(Real n) {
        NumberUtils.checkNotNull(n);
        return this.subtract(n.doubleValue());
    }

    public Numeric negate() {
        return NumberUtils.createNumeric(-this.value);
    }

    public Numeric reciprocal() {
        return NumberUtils.createNumeric(1.0 / this.value);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value * this.value);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    @Override
    public Numeric abs() {
        return this.value >= 0.0 ? this : this.negate();
    }

    @Override
    public Numeric add(double d) {
        return d == 0.0 ? this : NumberUtils.createNumeric(this.value + d);
    }

    @Override
    public Numeric add(int i) {
        return this.add((double)i);
    }

    @Override
    public Numeric add(BigFraction fraction) {
        NumberUtils.checkNotNull(fraction);
        return this.add(fraction.doubleValue());
    }

    @Override
    public Numeric add(long l) {
        return this.add((double)l);
    }

    @Override
    public Numeric add(BigInteger bg) {
        NumberUtils.checkNotNull(bg);
        return this.add(bg.doubleValue());
    }

    @Override
    public Numeric divide(double d) {
        return d == 1.0 ? this : NumberUtils.createNumeric(this.value / d);
    }

    @Override
    public Numeric divide(BigFraction fraction) {
        NumberUtils.checkNotNull(fraction);
        return this.divide(fraction.doubleValue());
    }

    @Override
    public Numeric divide(long l) {
        return this.divide((double)l);
    }

    @Override
    public Numeric divide(int i) {
        return this.divide((double)i);
    }

    @Override
    public Numeric divide(BigInteger bg) {
        NumberUtils.checkNotNull(bg);
        return this.divide(bg.doubleValue());
    }

    @Override
    public Numeric multiply(double d) {
        return d == 1.0 ? this : NumberUtils.createNumeric(d * this.value);
    }

    @Override
    public Numeric multiply(BigFraction fraction) {
        NumberUtils.checkNotNull(fraction);
        return this.multiply(fraction.doubleValue());
    }

    @Override
    public Numeric multiply(long l) {
        return this.multiply((double)l);
    }

    @Override
    public Numeric multiply(BigInteger bg) {
        NumberUtils.checkNotNull(bg);
        return this.multiply(bg.doubleValue());
    }

    @Override
    public Numeric subtract(BigFraction fraction) {
        return this.add(fraction.negate());
    }

    @Override
    public Numeric subtract(long l) {
        return this.add((double)(-l));
    }

    @Override
    public Numeric subtract(int i) {
        return this.add((double)(-i));
    }

    @Override
    public Numeric subtract(BigInteger bg) {
        return this.add(bg.negate());
    }

    @Override
    public Numeric subtract(double d) {
        return this.add(-d);
    }

    @Override
    public Numeric pow(double exponent) {
        return NumberUtils.createNumeric(StrictMath.pow(this.value, exponent));
    }

    @Override
    public Numeric pow(BigInteger exponent) {
        NumberUtils.checkNotNull(exponent);
        return this.pow(exponent.doubleValue());
    }

    @Override
    public Numeric pow(long exponent) {
        return this.pow((double)exponent);
    }

    @Override
    public Numeric pow(int exponent) {
        return this.pow((double)exponent);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Number)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((Number)obj).doubleValue());
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public Numeric getNumericValue() {
        return this;
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0;
    }

    @Override
    public int compareTo(Real o) {
        NumberUtils.checkNotNull(o);
        return Double.compare(this.value, o.doubleValue());
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isOne() {
        return this.value == 1.0;
    }

    @Override
    public boolean isMinusOne() {
        return this.value == -1.0;
    }

    @Override
    public int signum() {
        return this.value > 0.0 ? 1 : (this.value == 0.0 ? 0 : -1);
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isNatural() {
        return false;
    }
}

