/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.number;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.Numeric;
import cc.redberry.core.number.Rational;
import cc.redberry.core.tensor.Tensor;
import java.math.BigInteger;
import org.apache.commons.math3.fraction.BigFraction;

public final class NumberUtils {
    private static final BigInteger TWO = new BigInteger("2");
    public static BigInteger TWO_BIG_INT = new BigInteger("2");

    private NumberUtils() {
    }

    static void checkNotNull(Object o) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    public static Numeric createNumeric(double d) {
        if (d == 0.0) {
            return Numeric.ZERO;
        }
        if (d == 1.0) {
            return Numeric.ONE;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Numeric.POSITIVE_INFINITY;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return Numeric.NEGATIVE_INFINITY;
        }
        if (d != d) {
            return Numeric.NaN;
        }
        return new Numeric(d);
    }

    public static Rational createRational(BigFraction fraction) {
        if (fraction.getNumerator().equals(BigInteger.ZERO)) {
            return Rational.ZERO;
        }
        if (BigFraction.ONE.equals((Object)fraction)) {
            return Rational.ONE;
        }
        return new Rational(fraction);
    }

    public static BigInteger sqrt(BigInteger n) {
        if (n.signum() >= 0) {
            int bitLength = n.bitLength();
            BigInteger root = BigInteger.ONE.shiftLeft(bitLength / 2);
            while (!NumberUtils.isSqrtXXX(n, root)) {
                root = root.add(n.divide(root)).divide(TWO);
            }
            return root;
        }
        throw new ArithmeticException("square root of negative number");
    }

    private static boolean isSqrtXXX(BigInteger n, BigInteger root) {
        BigInteger lowerBound = root.pow(2);
        BigInteger upperBound = root.add(BigInteger.ONE).pow(2);
        return lowerBound.compareTo(n) <= 0 && n.compareTo(upperBound) < 0;
    }

    public static boolean isSqrt(BigInteger n, BigInteger root) {
        return n.compareTo(root.pow(2)) == 0;
    }

    public static boolean isIntegerOdd(Complex complex) {
        if (complex.isInteger()) {
            return !complex.getReal().bigIntValue().mod(TWO_BIG_INT).equals(BigInteger.ZERO);
        }
        return false;
    }

    public static boolean isIntegerEven(Complex complex) {
        if (complex.isInteger()) {
            return complex.getReal().bigIntValue().mod(TWO_BIG_INT).equals(BigInteger.ZERO);
        }
        return false;
    }

    public static boolean isZeroOrIndeterminate(Complex complex) {
        return complex.isZero() || complex.isInfinite() || complex.isNaN();
    }

    public static boolean isIndeterminate(Complex complex) {
        return complex.isInfinite() || complex.isNaN();
    }

    public static boolean isRealNegative(Complex complex) {
        return complex.isReal() && complex.getReal().signum() < 0;
    }

    public static boolean isRealNumerical(Tensor tensor) {
        if (tensor instanceof Complex && ((Complex)tensor).isReal()) {
            return true;
        }
        for (Tensor t : tensor) {
            if (NumberUtils.isRealNumerical(t)) continue;
            return false;
        }
        return true;
    }

    public static BigInteger pow(BigInteger base, BigInteger exponent) {
        BigInteger result = BigInteger.ONE;
        while (exponent.signum() > 0) {
            if (exponent.testBit(0)) {
                result = result.multiply(base);
            }
            base = base.multiply(base);
            exponent = exponent.shiftRight(1);
        }
        return result;
    }

    public static long pow(long base, long exponent) {
        long result = 1L;
        while (exponent > 0L) {
            if (exponent % 2L == 1L) {
                result *= base;
            }
            base *= base;
            exponent >>= 1;
        }
        return result;
    }

    public static BigInteger factorial(int n) {
        BigInteger result = BigInteger.ONE;
        while (n != 0) {
            result = result.multiply(BigInteger.valueOf(n));
            --n;
        }
        return result;
    }
}

