/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.indices.AbstractIndices;
import cc.redberry.core.indices.AbstractSimpleIndices;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesSymmetries;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SimpleIndicesBuilder {
    private final IntArrayList data;
    private final List<SymmetriesHolder> symmetries;

    public SimpleIndicesBuilder(int initialCapacity) {
        this.data = new IntArrayList(initialCapacity);
        this.symmetries = new ArrayList<SymmetriesHolder>(initialCapacity);
    }

    public SimpleIndicesBuilder() {
        this(7);
    }

    public SimpleIndicesBuilder append(SimpleIndices indices) {
        if (indices.size() == 0) {
            return this;
        }
        this.data.addAll(((AbstractSimpleIndices)indices).data);
        this.symmetries.add(new SymmetriesHolder(indices.size(), indices.getSymmetries().getGenerators()));
        return this;
    }

    public SimpleIndicesBuilder append(int ... indices) {
        this.data.addAll(indices);
        this.symmetries.add(new SymmetriesHolder(indices.length, Collections.EMPTY_LIST));
        return this;
    }

    public SimpleIndicesBuilder appendWithoutSymmetries(Indices indices) {
        if (indices.size() == 0) {
            return this;
        }
        this.data.addAll(((AbstractIndices)indices).data);
        this.symmetries.add(new SymmetriesHolder(indices.size(), Collections.EMPTY_LIST));
        return this;
    }

    public SimpleIndices getIndices() {
        int j;
        int[] data = this.data.toArray();
        int[] types = new int[data.length];
        for (j = 0; j < data.length; ++j) {
            types[j] = data[j] & 0x7F000000;
        }
        int[] cosort = Permutations.createIdentityArray(data.length);
        ArraysUtils.stableSort(types, cosort);
        int[] cosortInv = Permutations.inverse(cosort);
        ArrayList<Permutation> resultingSymmetries = new ArrayList<Permutation>();
        int position = 0;
        for (SymmetriesHolder holder : this.symmetries) {
            for (Permutation s : holder.generators) {
                int[] c = new int[data.length];
                for (j = 0; j < data.length; ++j) {
                    c[j] = cosort[j] < position || cosort[j] >= position + holder.length ? j : cosortInv[s.newIndexOf(cosort[j] - position) + position];
                }
                resultingSymmetries.add(Permutations.createPermutation(s.antisymmetry(), c));
            }
            position += holder.length;
        }
        return IndicesFactory.createSimple(IndicesSymmetries.create(new StructureOfIndices(data), resultingSymmetries), data);
    }

    private static final class SymmetriesHolder {
        final int length;
        final List<Permutation> generators;

        private SymmetriesHolder(int length, List<Permutation> generators) {
            this.length = length;
            this.generators = generators;
        }
    }
}

