/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indices;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.UnsafeIndicesFactory;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.IntArray;
import cc.redberry.core.utils.IntArrayList;
import java.util.Collection;

public final class IndicesBuilder {
    private final IntArrayList data;

    public IndicesBuilder() {
        this.data = new IntArrayList();
    }

    private IndicesBuilder(IntArrayList data) {
        this.data = data;
    }

    public IndicesBuilder(int capacity) {
        this.data = new IntArrayList(capacity);
    }

    public IndicesBuilder append(int index) {
        this.data.add(index);
        return this;
    }

    public IndicesBuilder append(int[] indices) {
        this.data.addAll(indices);
        return this;
    }

    public IndicesBuilder append(int[][] indices) {
        for (int[] ii : indices) {
            this.data.addAll(ii);
        }
        return this;
    }

    public IndicesBuilder append(IntArray indices) {
        this.data.addAll(indices);
        return this;
    }

    public IndicesBuilder append(IntArrayList indices) {
        this.data.addAll(indices);
        return this;
    }

    public IndicesBuilder append(Indices indices) {
        return this.append(indices.getAllIndices());
    }

    public IndicesBuilder append(IndicesBuilder ib) {
        return this.append(ib.toArray());
    }

    public IndicesBuilder append(Tensor tensor) {
        return this.append(tensor.getIndices());
    }

    public IndicesBuilder append(Collection<? extends Tensor> tensors) {
        for (Tensor tensor : tensors) {
            this.append(tensor);
        }
        return this;
    }

    public IndicesBuilder append(Tensor ... tensors) {
        for (Tensor t : tensors) {
            this.append(t);
        }
        return this;
    }

    public Indices getIndices() {
        return UnsafeIndicesFactory.createSortedWithoutCopy(this.data.toArray());
    }

    public int[] toArray() {
        return this.data.toArray();
    }

    public String toString() {
        return this.getIndices().toString();
    }

    public IndicesBuilder clone() {
        return new IndicesBuilder(this.data.clone());
    }
}

