/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.indexmapping.DummyIndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingProviderFactory;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indexmapping.MinusIndexMappingProvider;
import cc.redberry.core.number.Complex;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.tensor.Tensor;

class ProviderPower
implements IndexMappingProviderFactory {
    static final ProviderPower INSTANCE = new ProviderPower();

    private ProviderPower() {
    }

    @Override
    public IndexMappingProvider create(IndexMappingProvider opu, Tensor from, Tensor to) {
        IndexMappingBuffer exponentMapping = IndexMappings.getFirstBuffer(from.get(1), to.get(1));
        if (exponentMapping == null || exponentMapping.getSign()) {
            return IndexMappingProvider.Util.EMPTY_PROVIDER;
        }
        IndexMappingBuffer baseMapping = IndexMappings.getFirstBuffer(from.get(0), to.get(0));
        if (baseMapping == null) {
            return IndexMappingProvider.Util.EMPTY_PROVIDER;
        }
        if (!baseMapping.getSign()) {
            return new DummyIndexMappingProvider(opu);
        }
        if (!(from.get(1) instanceof Complex)) {
            return IndexMappingProvider.Util.EMPTY_PROVIDER;
        }
        assert (to.get(1) instanceof Complex);
        Complex exponent = (Complex)from.get(1);
        if (NumberUtils.isIntegerEven(exponent)) {
            return new DummyIndexMappingProvider(opu);
        }
        if (NumberUtils.isIntegerOdd(exponent)) {
            return new MinusIndexMappingProvider(opu);
        }
        return IndexMappingProvider.Util.EMPTY_PROVIDER;
    }
}

