/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexgenerator;

import cc.redberry.core.indexgenerator.IndexGenerator;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesUtils;
import gnu.trove.map.hash.TByteObjectHashMap;
import java.util.Arrays;

public final class IndexGeneratorFromData
implements IndexGenerator {
    private final TByteObjectHashMap<IntProvider> generators = new TByteObjectHashMap();

    public IndexGeneratorFromData(int[] allowedIndices) {
        if (allowedIndices.length > 0) {
            Arrays.sort(allowedIndices);
            byte type = IndicesUtils.getType(allowedIndices[0]);
            allowedIndices[0] = IndicesUtils.getNameWithoutType(allowedIndices[0]);
            int prevIndex = 0;
            for (int i = 1; i < allowedIndices.length; ++i) {
                if (IndicesUtils.getType(allowedIndices[i]) != type) {
                    this.generators.put(type, (Object)new IntProvider(Arrays.copyOfRange(allowedIndices, prevIndex, i)));
                    prevIndex = i;
                    type = IndicesUtils.getType(allowedIndices[i]);
                }
                allowedIndices[i] = IndicesUtils.getNameWithoutType(allowedIndices[i]);
            }
            this.generators.put(type, (Object)new IntProvider(Arrays.copyOfRange(allowedIndices, prevIndex, allowedIndices.length)));
        }
    }

    @Override
    public int generate(byte type) {
        IntProvider ig = (IntProvider)this.generators.get(type);
        if (ig == null) {
            throw new IndexOutOfBoundsException("No allowed indices with specified type: " + (Object)((Object)IndexType.getType(type)));
        }
        return IndicesUtils.setType(type, ig.getNext());
    }

    private static final class IntProvider {
        final int[] data;
        int pointer;

        private IntProvider(int[] data) {
            this.data = data;
            this.pointer = 0;
        }

        int getNext() {
            return this.data[this.pointer++];
        }
    }
}

