/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.combinatorics.IntTuplesPort;
import cc.redberry.core.context.CC;
import cc.redberry.core.groups.permutations.AlgorithmsBacktrack;
import cc.redberry.core.groups.permutations.AlgorithmsBase;
import cc.redberry.core.groups.permutations.BSGSCandidateElement;
import cc.redberry.core.groups.permutations.BSGSElement;
import cc.redberry.core.groups.permutations.BacktrackSearch;
import cc.redberry.core.groups.permutations.BacktrackSearchTestFunction;
import cc.redberry.core.groups.permutations.InducedOrdering;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.groups.permutations.RandomPermutation;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.Indicator;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.IntComparator;
import cc.redberry.core.utils.MathUtils;
import cc.redberry.core.utils.SingleIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.primes.Primes;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public final class PermutationGroup
implements Iterable<Permutation> {
    public static final PermutationGroup TRIVIAL_GROUP = new PermutationGroup();
    private final List<Permutation> generators;
    private final int internalDegree;
    private final int[] positionsInOrbits;
    private final int[][] orbits;
    private List<BSGSElement> bsgs = null;
    private int[] base = null;
    private BigInteger order = null;
    private InducedOrdering ordering = null;
    Boolean isTrivial = null;
    private Boolean isAbelian = null;
    private List<Permutation> randomSource = null;
    private Boolean isSymmetric = null;
    private Boolean isAlternating = null;
    private static double DEFAULT_CONFIDENCE_LEVEL = 0.999999;
    private static final double NORMAL_CLOSURE_CONFIDENCE_LEVEL = 0.999999;
    private PermutationGroup derivedSubgroup = null;
    private PermutationGroup center = null;

    private PermutationGroup(List<Permutation> generators, int internalDegree, int b) {
        if (generators.isEmpty()) {
            throw new IllegalArgumentException("Empty generators.");
        }
        this.generators = Collections.unmodifiableList(new ArrayList<Permutation>(generators));
        this.internalDegree = internalDegree;
        this.positionsInOrbits = new int[internalDegree];
        this.orbits = Permutations.orbits(generators, this.positionsInOrbits);
    }

    private PermutationGroup(List<BSGSElement> bsgs, int internalDegree) {
        if (bsgs.isEmpty()) {
            throw new IllegalArgumentException("Empty BSGS specified.");
        }
        this.bsgs = Collections.unmodifiableList(bsgs);
        this.base = AlgorithmsBase.getBaseAsArray(bsgs);
        this.internalDegree = internalDegree;
        this.order = AlgorithmsBase.calculateOrder(bsgs);
        this.positionsInOrbits = new int[internalDegree];
        this.generators = bsgs.get((int)0).stabilizerGenerators;
        this.orbits = Permutations.orbits(bsgs.get((int)0).stabilizerGenerators, this.positionsInOrbits);
        this.ordering = new InducedOrdering(this.base);
    }

    private PermutationGroup() {
        this.bsgs = AlgorithmsBase.TRIVIAL_BSGS;
        this.base = new int[0];
        this.internalDegree = 1;
        this.order = BigInteger.ONE;
        this.positionsInOrbits = new int[0];
        this.generators = Collections.singletonList(Permutations.getIdentityPermutation());
        this.orbits = new int[0][0];
        this.ordering = new InducedOrdering(this.base);
    }

    public static PermutationGroup trivialGroup() {
        return TRIVIAL_GROUP;
    }

    public static PermutationGroup createPermutationGroup(Permutation ... generators) {
        return PermutationGroup.createPermutationGroup(Arrays.asList(generators));
    }

    public static PermutationGroup createPermutationGroup(List<Permutation> generators) {
        int degree = Permutations.internalDegree(generators);
        if (degree == 0) {
            return TRIVIAL_GROUP;
        }
        return new PermutationGroup(generators, degree, 0);
    }

    public static PermutationGroup createPermutationGroupFromBSGS(List<BSGSElement> bsgs) {
        int degree = bsgs.get(0).internalDegree();
        if (degree == 0) {
            return TRIVIAL_GROUP;
        }
        return new PermutationGroup(bsgs, degree);
    }

    public static PermutationGroup symmetricGroup(int degree) {
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.createSymmetricGroupBSGS(degree));
    }

    public static PermutationGroup antisymmetricGroup(int degree) {
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.createAntisymmetricGroupBSGS(degree));
    }

    public static PermutationGroup alternatingGroup(int degree) {
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.createAlternatingGroupBSGS(degree));
    }

    private void ensureBSGSIsInitialized() {
        if (this.bsgs == null) {
            this.bsgs = this.isSym0() ? AlgorithmsBase.createSymmetricGroupBSGS(this.internalDegree) : (this.isAlt0() ? AlgorithmsBase.createAlternatingGroupBSGS(this.internalDegree) : (this.base != null ? AlgorithmsBase.createBSGSList(this.base, this.generators, this.internalDegree) : AlgorithmsBase.createBSGSList(this.generators, this.internalDegree)));
            this.bsgs = this.bsgs.isEmpty() ? AlgorithmsBase.TRIVIAL_BSGS : Collections.unmodifiableList(this.bsgs);
            this.base = AlgorithmsBase.getBaseAsArray(this.bsgs);
            this.order = AlgorithmsBase.calculateOrder(this.bsgs);
            this.ordering = new InducedOrdering(this.base);
        }
    }

    public int[] getPositionsInOrbits() {
        return (int[])this.positionsInOrbits.clone();
    }

    public List<Permutation> generators() {
        return this.generators;
    }

    public int degree() {
        return this.internalDegree;
    }

    public int[] orbit(int point) {
        if (point >= this.internalDegree) {
            return new int[]{point};
        }
        return (int[])this.orbits[this.positionsInOrbits[point]].clone();
    }

    public int orbitSize(int point) {
        if (point >= this.internalDegree) {
            return 1;
        }
        return this.orbits[this.positionsInOrbits[point]].length;
    }

    public int[] orbit(int ... points) {
        IntArrayList orbit = new IntArrayList();
        TIntHashSet orbitsIndexesSet = new TIntHashSet();
        for (int i : points) {
            if (i < this.internalDegree) {
                if (orbitsIndexesSet.contains(this.positionsInOrbits[i])) continue;
                orbitsIndexesSet.ensureCapacity(this.orbits[this.positionsInOrbits[i]].length);
                orbitsIndexesSet.add(this.positionsInOrbits[i]);
                orbit.addAll(this.orbits[this.positionsInOrbits[i]]);
                continue;
            }
            if (orbitsIndexesSet.contains(i)) continue;
            orbitsIndexesSet.add(i);
            orbit.add(i);
        }
        return orbit.toArray();
    }

    public int[][] orbits() {
        int[][] r = new int[this.orbits.length][];
        for (int i = 0; i < this.orbits.length; ++i) {
            r[i] = (int[])this.orbits[i].clone();
        }
        return r;
    }

    public int indexOfOrbit(int point) {
        if (point >= this.internalDegree) {
            return -1;
        }
        return this.positionsInOrbits[point];
    }

    public boolean isTransitive() {
        if (this.isTrivial()) {
            return false;
        }
        return this.orbits.length == 1;
    }

    public boolean isTransitive(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("Specified from less then specified to.");
        }
        if (to >= this.internalDegree) {
            return false;
        }
        for (int i = from + 1; i < to; ++i) {
            if (this.positionsInOrbits[i] == this.positionsInOrbits[i - 1]) continue;
            return false;
        }
        return true;
    }

    public boolean isTrivial() {
        if (this.isTrivial != null) {
            return this.isTrivial;
        }
        this.isTrivial = true;
        for (Permutation p : this.generators) {
            if (p.isIdentity()) continue;
            this.isTrivial = false;
            break;
        }
        return this.isTrivial;
    }

    public boolean isAbelian() {
        if (this.isTrivial()) {
            return true;
        }
        if (this.isAbelian != null) {
            return this.isAbelian;
        }
        this.isAbelian = true;
        List<Permutation> generators = this.generators();
        int size = generators.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (generators.get(i).commutator(generators.get(j)).isIdentity()) continue;
                this.isAbelian = false;
                return this.isAbelian;
            }
        }
        return this.isAbelian;
    }

    public List<Permutation> randomSource() {
        if (this.randomSource == null) {
            ArrayList<Permutation> randomSource = new ArrayList<Permutation>(this.generators());
            RandomPermutation.randomness(randomSource, 10, 20, CC.getRandomGenerator());
            this.randomSource = randomSource;
            return this.randomSource;
        }
        return this.randomSource;
    }

    public PermutationGroup union(Permutation ... generators) {
        return this.union(Arrays.asList(generators));
    }

    public PermutationGroup union(List<Permutation> generators) {
        if (this.isTrivial()) {
            return PermutationGroup.createPermutationGroup(generators);
        }
        if (this.bsgs != null && this.membershipTest(generators)) {
            return this;
        }
        ArrayList<Permutation> all_generators = new ArrayList<Permutation>(this.generators());
        all_generators.addAll(generators);
        PermutationGroup r = PermutationGroup.createPermutationGroup(all_generators);
        r.base = this.base;
        return r;
    }

    public List<BSGSElement> getBSGS() {
        this.ensureBSGSIsInitialized();
        return this.bsgs;
    }

    public int[] getBase() {
        this.ensureBSGSIsInitialized();
        return (int[])this.base.clone();
    }

    private int[] base() {
        this.ensureBSGSIsInitialized();
        return this.base;
    }

    public BigInteger order() {
        this.ensureBSGSIsInitialized();
        return this.order;
    }

    public InducedOrdering ordering() {
        this.ensureBSGSIsInitialized();
        return this.ordering;
    }

    public boolean membershipTest(Permutation permutation) {
        if (this.isTrivial()) {
            return permutation.isIdentity();
        }
        return AlgorithmsBase.membershipTest(this.getBSGS(), permutation);
    }

    public boolean membershipTest(Collection<Permutation> permutations) {
        for (Permutation p : permutations) {
            if (this.membershipTest(p)) continue;
            return false;
        }
        return true;
    }

    public Permutation randomElement() {
        return this.randomElement(CC.getRandomGenerator());
    }

    public Permutation randomElement(RandomGenerator generator) {
        List<BSGSElement> bsgs = this.getBSGS();
        BSGSElement element = bsgs.get(0);
        Permutation result = element.getTransversalOf(element.getOrbitPoint(generator.nextInt(element.orbitSize())));
        for (int i = 1; i < bsgs.size(); ++i) {
            element = bsgs.get(i);
            result = result.composition(element.getTransversalOf(element.getOrbitPoint(generator.nextInt(element.orbitSize()))));
        }
        return result;
    }

    public ArrayList<BSGSCandidateElement> getBSGSCandidate() {
        return AlgorithmsBase.asBSGSCandidatesList(this.getBSGS());
    }

    private boolean isSym0() {
        if (this.isTrivial() || !this.isTransitive()) {
            this.isSymmetric = false;
            return this.isSymmetric;
        }
        if (this.internalDegree > 2 && this.generators().size() == 1) {
            this.isSymmetric = false;
            return this.isSymmetric;
        }
        boolean isSym = this.isSymOrAlt(DEFAULT_CONFIDENCE_LEVEL);
        if (!isSym) {
            return false;
        }
        boolean containsOdd = false;
        for (Permutation p : this.generators()) {
            if (p.parity() != 1) continue;
            containsOdd = true;
            break;
        }
        this.isSymmetric = containsOdd;
        return this.isSymmetric;
    }

    public boolean isSymmetric() {
        if (this.isSymmetric != null) {
            return this.isSymmetric;
        }
        this.isSymmetric = this.isSym0();
        if (!this.isSymmetric.booleanValue()) {
            this.isSymmetric = this.order().equals(NumberUtils.factorial(this.internalDegree));
        }
        return this.isSymmetric;
    }

    private boolean isAlt0() {
        if (this.isTrivial() || !this.isTransitive()) {
            this.isAlternating = false;
            return this.isAlternating;
        }
        boolean isAlt = this.isSymOrAlt(DEFAULT_CONFIDENCE_LEVEL);
        if (!isAlt) {
            return false;
        }
        for (Permutation p : this.generators()) {
            if (p.parity() != 1) continue;
            this.isAlternating = false;
            return this.isAlternating;
        }
        this.isAlternating = true;
        return this.isAlternating;
    }

    public boolean isAlternating() {
        if (this.isAlternating != null) {
            return this.isAlternating;
        }
        this.isAlternating = this.isAlt0();
        if (this.isAlternating.booleanValue()) {
            return this.isAlternating;
        }
        this.isAlternating = this.order().equals(NumberUtils.factorial(this.internalDegree).divide(BigInteger.valueOf(2L)));
        if (this.isAlternating.booleanValue()) {
            for (Permutation p : this.generators()) {
                if (p.parity() != 1) continue;
                this.isAlternating = false;
                return this.isAlternating;
            }
        }
        return this.isAlternating;
    }

    private boolean isSymOrAlt(double CL) {
        if (this.internalDegree < 8) {
            return false;
        }
        double c = this.internalDegree <= 16 ? 0.34 : 0.57;
        int num = (int)(-FastMath.log((double)(1.0 - CL)) * FastMath.log((double)2.0, (double)this.internalDegree) / c);
        List<Permutation> randomSource = this.randomSource();
        for (int i = 0; i < num; ++i) {
            int[] lengths;
            for (int length : lengths = RandomPermutation.random(randomSource).lengthsOfCycles()) {
                if (length <= this.internalDegree / 2 || length >= this.internalDegree - 2 || !Primes.isPrime((int)length)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRegular() {
        return this.isTransitive() && this.order().equals(BigInteger.valueOf(this.internalDegree));
    }

    public PermutationGroup pointwiseStabilizer(int ... set) {
        if (this.isTrivial()) {
            return this;
        }
        if (set.length == 0) {
            return this;
        }
        set = MathUtils.getSortedDistinct((int[])set.clone());
        ArraysUtils.quickSort(set, this.ordering());
        ArrayList<BSGSCandidateElement> bsgs = this.getBSGSCandidate();
        AlgorithmsBase.rebase(bsgs, set);
        if (bsgs.size() <= set.length) {
            return TRIVIAL_GROUP;
        }
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.asBSGSList(bsgs.subList(set.length, bsgs.size())));
    }

    public PermutationGroup pointwiseStabilizerRestricted(int ... set) {
        if (this.isTrivial()) {
            return this;
        }
        if (set.length == 0) {
            return this;
        }
        set = MathUtils.getSortedDistinct(set);
        int newDegree = this.internalDegree - set.length;
        int[] newBase = (int[])set.clone();
        ArraysUtils.quickSort(newBase, this.ordering());
        ArrayList<BSGSCandidateElement> bsgs = this.getBSGSCandidate();
        AlgorithmsBase.rebase(bsgs, newBase);
        if (bsgs.size() <= newBase.length) {
            return TRIVIAL_GROUP;
        }
        int[] closure = new int[newDegree];
        int[] mapping = new int[this.internalDegree];
        Arrays.fill(mapping, -1);
        int pointer = 0;
        int counter = 0;
        for (int i = 0; i < this.internalDegree; ++i) {
            if (pointer < set.length && i == set[pointer]) {
                ++pointer;
                continue;
            }
            closure[counter] = i;
            mapping[i] = counter++;
        }
        ArrayList<BSGSCandidateElement> stab = new ArrayList<BSGSCandidateElement>();
        for (int i = newBase.length; i < bsgs.size(); ++i) {
            BSGSCandidateElement e = bsgs.get(i);
            if (mapping[e.basePoint] == -1) continue;
            ArrayList<Permutation> newStabs = new ArrayList<Permutation>(e.stabilizerGenerators.size());
            for (Permutation p : e.stabilizerGenerators) {
                int[] perm = new int[newDegree];
                for (int j = 0; j < newDegree; ++j) {
                    perm[j] = mapping[p.newIndexOf(closure[j])];
                }
                newStabs.add(Permutations.createPermutation(p.antisymmetry(), perm));
            }
            stab.add(new BSGSCandidateElement(mapping[e.basePoint], newStabs, newDegree));
        }
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.asBSGSList(stab));
    }

    public PermutationGroup normalClosureOf(PermutationGroup subgroup) {
        if (subgroup.isTrivial()) {
            return subgroup;
        }
        if (this.isAlternating() && this.internalDegree > 4) {
            return this;
        }
        if (this.isSymmetric() && this.internalDegree != 4) {
            for (Permutation p : subgroup.generators) {
                if (p.parity() != 1) continue;
                return this;
            }
            return PermutationGroup.alternatingGroup(this.internalDegree);
        }
        ArrayList<BSGSCandidateElement> closure = subgroup.getBSGSCandidate();
        List<Permutation> randomSource = this.randomSource();
        boolean completed = false;
        boolean globalAdded = false;
        block1: while (!completed) {
            ArrayList<Permutation> closureSource = new ArrayList<Permutation>(closure.get((int)0).stabilizerGenerators);
            RandomPermutation.randomness(closureSource, 10, 10, CC.getRandomGenerator());
            boolean added = false;
            for (int i = 0; i < 10; ++i) {
                Permutation c = RandomPermutation.random(randomSource).conjugate(RandomPermutation.random(closureSource));
                if (AlgorithmsBase.membershipTest(closure, c)) continue;
                closure.get(0).addStabilizer(c);
                added = true;
                globalAdded = true;
            }
            if (added) {
                AlgorithmsBase.RandomSchreierSimsAlgorithm(closure, 0.999999, CC.getRandomGenerator());
            }
            completed = true;
            for (Permutation generator : this.generators) {
                for (Permutation cGenerator : closure.get((int)0).stabilizerGenerators) {
                    if (AlgorithmsBase.membershipTest(closure, generator.conjugate(cGenerator))) continue;
                    completed = false;
                    continue block1;
                }
            }
        }
        if (globalAdded) {
            AlgorithmsBase.SchreierSimsAlgorithm(closure);
        }
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.asBSGSList(closure));
    }

    public PermutationGroup commutator(PermutationGroup group) {
        ArrayList<Permutation> commutator = new ArrayList<Permutation>();
        for (Permutation a : this.generators) {
            for (Permutation b : group.generators) {
                Permutation c = a.commutator(b);
                if (c.isIdentity()) continue;
                commutator.add(c);
            }
        }
        if (commutator.isEmpty()) {
            return TRIVIAL_GROUP;
        }
        return this.union(group).normalClosureOf(PermutationGroup.createPermutationGroup(commutator));
    }

    public PermutationGroup derivedSubgroup() {
        if (this.derivedSubgroup != null) {
            return this.derivedSubgroup;
        }
        if (this.isSymmetric()) {
            this.derivedSubgroup = PermutationGroup.alternatingGroup(this.internalDegree);
            return this.derivedSubgroup;
        }
        if (this.isAlternating() && this.internalDegree > 4) {
            this.derivedSubgroup = this;
            return this.derivedSubgroup;
        }
        this.derivedSubgroup = this.commutator(this);
        return this.derivedSubgroup;
    }

    public PermutationGroup setwiseStabilizer(int ... set) {
        if (set.length == 0) {
            return this;
        }
        set = MathUtils.getSortedDistinct((int[])set.clone());
        ArraysUtils.quickSort(set, this.ordering());
        ArrayList<BSGSCandidateElement> bsgs = this.getBSGSCandidate();
        AlgorithmsBase.rebase(bsgs, set);
        Arrays.sort(set);
        for (int i = bsgs.size() - 1; i >= set.length; --i) {
            if (Arrays.binarySearch(set, bsgs.get((int)i).basePoint) < 0) continue;
            bsgs.remove(i);
        }
        ArrayList<BSGSCandidateElement> stabilizer = AlgorithmsBase.clone(new ArrayList<BSGSCandidateElement>(bsgs.subList(set.length, bsgs.size())));
        int[] newBase = AlgorithmsBase.getBaseAsArray(bsgs);
        SetwiseStabilizerSearchTest swTest = new SetwiseStabilizerSearchTest(newBase, set);
        AlgorithmsBacktrack.subgroupSearch(bsgs, stabilizer, swTest, swTest, newBase, new InducedOrdering(newBase));
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.asBSGSList(stabilizer));
    }

    public boolean containsSubgroup(PermutationGroup subgroup) {
        if (this.degree() < subgroup.degree()) {
            return false;
        }
        if (this.isTrivial()) {
            return subgroup.isTrivial();
        }
        if (this.isSymmetric()) {
            return true;
        }
        if (this.isAlternating()) {
            for (Permutation p : subgroup.generators()) {
                if (p.parity() != 1) continue;
                return false;
            }
            return true;
        }
        if (subgroup.order().compareTo(this.order()) > 0) {
            return false;
        }
        return this.membershipTest(subgroup.generators());
    }

    public Permutation[] leftCosetRepresentatives(PermutationGroup subgroup) {
        if (this.isTrivial()) {
            return new Permutation[]{Permutations.getIdentityPermutation()};
        }
        return AlgorithmsBacktrack.leftCosetRepresentatives(this.getBSGS(), subgroup.getBSGS(), this.base(), this.ordering());
    }

    public Permutation[] rightCosetRepresentatives(PermutationGroup subgroup) {
        Permutation[] reps = this.leftCosetRepresentatives(subgroup);
        for (int i = 0; i < reps.length; ++i) {
            reps[i] = reps[i].inverse();
        }
        return reps;
    }

    public Permutation leftTransversalOf(PermutationGroup subgroup, Permutation element) {
        return AlgorithmsBacktrack.leftTransversalOf(element, this.getBSGS(), subgroup.getBSGS(), this.base(), this.ordering());
    }

    public PermutationGroup union(PermutationGroup group) {
        if (this == group) {
            return this;
        }
        if (this.isTrivial()) {
            return group;
        }
        if (group.isTrivial()) {
            return this;
        }
        if (this.bsgs == null && group.bsgs != null) {
            return group.union(this.generators());
        }
        if (group.bsgs == null) {
            return this.union(group.generators());
        }
        if (this.containsSubgroup(group)) {
            return this;
        }
        if (group.containsSubgroup(this)) {
            return group;
        }
        int[] thisBase = this.getBase();
        int[] othBase = group.getBase();
        Arrays.sort(thisBase);
        Arrays.sort(othBase);
        int[] base = MathUtils.intSetUnion(thisBase, othBase);
        ArrayList<Permutation> generators = new ArrayList<Permutation>(this.generators().size() + group.generators().size());
        generators.addAll(this.generators());
        generators.addAll(group.generators());
        PermutationGroup r = PermutationGroup.createPermutationGroup(generators);
        r.base = base;
        return r;
    }

    public PermutationGroup intersection(PermutationGroup oth) {
        if (this.isTrivial()) {
            return this;
        }
        if (oth.isTrivial()) {
            return oth;
        }
        if (this.isSymmetric()) {
            if (oth.degree() <= this.degree()) {
                return oth;
            }
            int[] points = new int[oth.degree() - this.degree()];
            for (int i = 0; i < points.length; ++i) {
                points[i] = this.degree() + i;
            }
            return oth.pointwiseStabilizer(points);
        }
        if (oth.isSymmetric()) {
            return oth.intersection(this);
        }
        ArrayList<BSGSCandidateElement> intersection = new ArrayList<BSGSCandidateElement>();
        AlgorithmsBacktrack.intersection(this.getBSGS(), oth.getBSGS(), intersection);
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.asBSGSList(intersection));
    }

    public PermutationGroup directProduct(PermutationGroup group) {
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.directProduct(this.getBSGS(), group.getBSGS()));
    }

    public Permutation mapping(int from, int to) {
        if (this.positionsInOrbits[from] != this.positionsInOrbits[to]) {
            return null;
        }
        List<BSGSElement> bsgs = this.getBSGS();
        if (bsgs.get((int)0).basePoint == from) {
            return bsgs.get(0).getTransversalOf(to);
        }
        int size = bsgs.size();
        for (int i = 0; i < size; ++i) {
            if (bsgs.get((int)i).basePoint != from || !bsgs.get(i).belongsToOrbit(to)) continue;
            return bsgs.get(i).getTransversalOf(to);
        }
        ArrayList<BSGSCandidateElement> bsgs_c = AlgorithmsBase.asBSGSCandidatesList(bsgs);
        AlgorithmsBase.changeBasePointWithTranspositions(bsgs_c, 0, from);
        return bsgs_c.get(0).getTransversalOf(to);
    }

    public BacktrackSearch mapping(int[] from, int[] to) {
        if (from.length != to.length) {
            throw new IllegalArgumentException("Length of from is not equal to length of to.");
        }
        int[] _from_ = (int[])from.clone();
        int[] _to_ = (int[])to.clone();
        ArraysUtils.quickSort(_from_, _to_, this.ordering());
        ArrayList<BSGSCandidateElement> bsgs = this.getBSGSCandidate();
        int newDegree = Math.max(this.internalDegree, Math.max(ArraysUtils.max(from) + 1, ArraysUtils.max(to) + 1));
        AlgorithmsBacktrack.rebaseWithRedundancy(bsgs, _from_, this.internalDegree);
        SearchForMapping mapping = new SearchForMapping(_from_, _to_);
        return new BacktrackSearch(bsgs, mapping, mapping);
    }

    @Override
    public Iterator<Permutation> iterator() {
        this.ensureBSGSIsInitialized();
        if (this.internalDegree == 1) {
            return new SingleIterator<Permutation>(Permutations.getIdentityPermutation());
        }
        return new PermIterator();
    }

    public PermutationGroup centralizerOf(Permutation permutation) {
        return this.centralizerOf(PermutationGroup.createPermutationGroup(permutation));
    }

    public PermutationGroup centralizerOf(final PermutationGroup subgroup) {
        if (subgroup.isAbelian() && subgroup.isTransitive(0, this.internalDegree)) {
            return subgroup;
        }
        int[] base = this.getBase();
        if (subgroup.orbits.length != 1) {
            IntComparator comparator = new IntComparator(){

                @Override
                public int compare(int a, int b) {
                    return -Integer.compare(subgroup.orbitSize(a), subgroup.orbitSize(b));
                }
            };
            ArraysUtils.quickSort(base, comparator);
        }
        ArrayList<BSGSCandidateElement> group_bsgs = this.getBSGSCandidate();
        AlgorithmsBase.rebase(group_bsgs, base);
        ArrayList<BSGSCandidateElement> subgroup_bsgs = subgroup.getBSGSCandidate();
        AlgorithmsBacktrack.rebaseWithRedundancy(subgroup_bsgs, base, this.internalDegree);
        Permutation[] mappings = new Permutation[base.length - 1];
        for (int i = 1; i < base.length; ++i) {
            if (base[i] >= subgroup.internalDegree || subgroup.indexOfOrbit(base[i]) != subgroup.indexOfOrbit(base[i - 1])) continue;
            mappings[i - 1] = subgroup.mapping(base[i - 1], base[i]);
        }
        CentralizerSearchTest centralizerSearch = new CentralizerSearchTest(group_bsgs, subgroup, base, mappings);
        ArrayList<BSGSCandidateElement> centralizer = subgroup.generators().size() == 1 ? AlgorithmsBase.clone(subgroup_bsgs) : new ArrayList();
        AlgorithmsBacktrack.subgroupSearch(group_bsgs, centralizer, centralizerSearch, centralizerSearch);
        return PermutationGroup.createPermutationGroupFromBSGS(AlgorithmsBase.asBSGSList(centralizer));
    }

    public PermutationGroup center() {
        if (this.center == null) {
            if (this.isSymmetric() && this.internalDegree >= 3) {
                this.center = PermutationGroup.createPermutationGroup(this.generators().get(0).getIdentity());
                return this.center;
            }
            if (this.isAlternating() && this.internalDegree >= 4) {
                this.center = PermutationGroup.createPermutationGroup(this.generators().get(0).getIdentity());
                return this.center;
            }
            this.center = this.centralizerOf(this);
            return this.center;
        }
        return this.center;
    }

    public PermutationGroup conjugate(Permutation permutation) {
        if (this.isTrivial()) {
            return this;
        }
        if (this.bsgs == null) {
            ArrayList<Permutation> newGens = new ArrayList<Permutation>(this.generators().size());
            for (Permutation p : this.generators()) {
                newGens.add(permutation.conjugate(p));
            }
            return PermutationGroup.createPermutationGroup(newGens);
        }
        List<BSGSElement> bsgs = this.getBSGS();
        ArrayList<BSGSElement> new_bsgs = new ArrayList<BSGSElement>(bsgs.size());
        for (BSGSElement e : bsgs) {
            ArrayList<Permutation> newStabs = new ArrayList<Permutation>(e.stabilizerGenerators.size());
            for (Permutation p : e.stabilizerGenerators) {
                newStabs.add(permutation.conjugate(p));
            }
            new_bsgs.add(new BSGSCandidateElement(permutation.newIndexOf(e.basePoint), newStabs, this.internalDegree).asBSGSElement());
        }
        return PermutationGroup.createPermutationGroupFromBSGS(new_bsgs);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PermutationGroup oth = (PermutationGroup)obj;
        if (this.internalDegree != oth.internalDegree) {
            return false;
        }
        if (this.orbits.length != oth.orbits.length) {
            return false;
        }
        if (!this.order().equals(oth.order())) {
            return false;
        }
        if (this.generators().size() < oth.generators().size()) {
            return oth.membershipTest(this.generators());
        }
        return this.membershipTest(oth.generators());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Group( ");
        List<Permutation> gens = this.generators();
        int i = 0;
        while (true) {
            sb.append(gens.get(i));
            if (i == gens.size() - 1) {
                return sb.append(" )").toString();
            }
            sb.append(", ");
            ++i;
        }
    }

    public String toStringJava() {
        StringBuilder sb = new StringBuilder();
        sb.append("PermutationGroup.createPermutationGroup( ");
        List<Permutation> gens = this.generators();
        int i = 0;
        while (true) {
            String p = gens.get(i).toString().replace("[", "{").replace("]", "}").replace("+", "").replace("-", "");
            if (gens.get(i).antisymmetry()) {
                sb.append("Permutations.createPermutation(true, new int[][]").append(p).append(")");
            } else {
                sb.append("Permutations.createPermutation(new int[][]").append(p).append(")");
            }
            if (i == gens.size() - 1) {
                return sb.append(" )").toString();
            }
            sb.append(", ");
            ++i;
        }
    }

    private static final class CentralizerSearchTest
    implements BacktrackSearchTestFunction,
    Indicator<Permutation> {
        final List<? extends BSGSElement> group_bsgs;
        final PermutationGroup subgroup;
        final Permutation[] mappings;
        final int[] group_base;

        private CentralizerSearchTest(List<? extends BSGSElement> group_bsgs, PermutationGroup subgroup, int[] group_base, Permutation[] mappings) {
            this.group_bsgs = group_bsgs;
            this.subgroup = subgroup;
            this.group_base = group_base;
            this.mappings = mappings;
        }

        @Override
        public boolean test(Permutation permutation, int level) {
            if (level == 0) {
                return true;
            }
            if (this.subgroup.internalDegree < this.group_base[level - 1] && this.group_base[level - 1] != this.group_base[level]) {
                return true;
            }
            if (this.subgroup.indexOfOrbit(this.group_base[level - 1]) != this.subgroup.indexOfOrbit(this.group_base[level])) {
                return true;
            }
            Permutation mapping = this.mappings[level - 1];
            int expected = mapping.newIndexOf(permutation.newIndexOf(this.group_base[level - 1]));
            return permutation.newIndexOf(this.group_base[level]) == expected;
        }

        @Override
        public boolean is(Permutation permutation) {
            if (permutation.isIdentity()) {
                return false;
            }
            for (Permutation p : this.subgroup.generators()) {
                if (p.commutator(permutation).isIdentity()) continue;
                return false;
            }
            return true;
        }
    }

    private final class PermIterator
    implements Iterator<Permutation> {
        private final IntTuplesPort tuplesPort;
        int[] tuple;

        public PermIterator() {
            int[] orbitSizes = new int[PermutationGroup.this.base.length];
            for (int i = 0; i < orbitSizes.length; ++i) {
                orbitSizes[i] = ((BSGSElement)PermutationGroup.this.bsgs.get(i)).orbitSize();
            }
            this.tuplesPort = new IntTuplesPort(orbitSizes);
            this.tuple = this.tuplesPort.take();
        }

        @Override
        public boolean hasNext() {
            return this.tuple != null;
        }

        @Override
        public Permutation next() {
            Permutation p = ((BSGSElement)PermutationGroup.this.bsgs.get(0)).getInverseTransversalOf(((BSGSElement)PermutationGroup.this.bsgs.get(0)).getOrbitPoint(this.tuple[0]));
            int size = PermutationGroup.this.bsgs.size();
            for (int i = 1; i < size; ++i) {
                BSGSElement e = (BSGSElement)PermutationGroup.this.bsgs.get(i);
                p = p.composition(e.getInverseTransversalOf(e.getOrbitPoint(this.tuple[i])));
            }
            this.tuple = this.tuplesPort.take();
            return p;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Illegal operation.");
        }
    }

    private static final class SearchForMapping
    implements BacktrackSearchTestFunction,
    Indicator<Permutation> {
        final int[] from;
        final int[] to;

        private SearchForMapping(int[] from, int[] to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean test(Permutation permutation, int level) {
            if (level < this.from.length) {
                return permutation.newIndexOf(this.from[level]) == this.to[level];
            }
            return true;
        }

        @Override
        public boolean is(Permutation object) {
            return true;
        }
    }

    private static class SetwiseStabilizerSearchTest
    implements BacktrackSearchTestFunction,
    Indicator<Permutation> {
        final int[] base;
        final int[] set;

        SetwiseStabilizerSearchTest(int[] base, int[] set) {
            this.base = base;
            this.set = set;
        }

        @Override
        public boolean test(Permutation permutation, int level) {
            if (level < this.set.length) {
                assert (Arrays.binarySearch(this.set, this.base[level]) >= 0);
                return Arrays.binarySearch(this.set, permutation.newIndexOf(this.base[level])) >= 0;
            }
            return Arrays.binarySearch(this.set, permutation.newIndexOf(this.base[level])) < 0;
        }

        @Override
        public boolean is(Permutation p) {
            for (int s : this.set) {
                if (Arrays.binarySearch(this.set, p.newIndexOf(s)) >= 0) continue;
                return false;
            }
            return true;
        }
    }
}

