/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context.defaults;

import cc.redberry.core.context.IndexConverterException;
import cc.redberry.core.context.IndexSymbolConverter;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.context.defaults.GreekLaTeXLowerCaseConverter;
import cc.redberry.core.context.defaults.GreekLaTeXUpperCaseConverter;
import cc.redberry.core.context.defaults.LatinLowerCaseConverter;
import cc.redberry.core.context.defaults.LatinUpperCaseConverter;

public final class IndexConverterExtender
implements IndexSymbolConverter {
    public static final IndexConverterExtender LatinLowerEx = new IndexConverterExtender(LatinLowerCaseConverter.INSTANCE);
    public static final IndexConverterExtender LatinUpperEx = new IndexConverterExtender(LatinUpperCaseConverter.INSTANCE);
    public static final IndexConverterExtender GreekLowerEx = new IndexConverterExtender(GreekLaTeXLowerCaseConverter.INSTANCE);
    public static final IndexConverterExtender GreekUpperEx = new IndexConverterExtender(GreekLaTeXUpperCaseConverter.INSTANCE);
    private final IndexSymbolConverter innerConverter;

    public IndexConverterExtender(IndexSymbolConverter innerConverter) {
        this.innerConverter = innerConverter;
    }

    @Override
    public boolean applicableToSymbol(String symbol) {
        if (!symbol.contains("_")) {
            return this.innerConverter.applicableToSymbol(symbol);
        }
        String[] split = symbol.split("_");
        if (split.length != 2 || split[1].length() == 0) {
            return false;
        }
        if (split[1].charAt(0) == '{') {
            if (split[1].length() < 3) {
                return false;
            }
            split[1] = split[1].substring(1, split[1].length() - 1);
        }
        try {
            Integer.parseInt(split[1]);
            return this.innerConverter.applicableToSymbol(split[0]);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public int getCode(String symbol) throws IndexConverterException {
        int num;
        if (!symbol.contains("_")) {
            return this.innerConverter.getCode(symbol);
        }
        String[] split = symbol.split("_");
        if (split.length != 2 || split[1].length() == 0) {
            throw new IndexConverterException();
        }
        if (split[1].charAt(0) == '{') {
            if (split[1].length() < 3) {
                throw new IndexConverterException();
            }
            split[1] = split[1].substring(1, split[1].length() - 1);
        }
        try {
            num = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            throw new IndexConverterException();
        }
        return num * (1 + this.innerConverter.maxNumberOfSymbols()) + this.innerConverter.getCode(split[0]);
    }

    @Override
    public String getSymbol(int code, OutputFormat mode) throws IndexConverterException {
        int subscript = code / (this.innerConverter.maxNumberOfSymbols() + 1);
        if (subscript == 0) {
            return this.innerConverter.getSymbol(code, mode);
        }
        String symbol = this.innerConverter.getSymbol(code % (this.innerConverter.maxNumberOfSymbols() + 1), mode);
        if (mode.is(OutputFormat.WolframMathematica)) {
            return "Subscript[" + symbol + ", " + subscript + "]";
        }
        if (mode.is(OutputFormat.Maple)) {
            return symbol + subscript;
        }
        return symbol + "_" + "{" + subscript + "}";
    }

    @Override
    public byte getType() {
        return this.innerConverter.getType();
    }

    @Override
    public int maxNumberOfSymbols() {
        return 10 * (this.innerConverter.maxNumberOfSymbols() + 1) - 1;
    }
}

