/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.context.NameDescriptor;
import cc.redberry.core.context.NameDescriptorForMetricAndKronecker;
import cc.redberry.core.context.NameDescriptorForSimpleTensor;
import cc.redberry.core.context.NameDescriptorForTensorFieldDerivative;
import cc.redberry.core.context.NameDescriptorForTensorFieldImpl;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.parser.ParserException;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well44497b;

public final class NameManager {
    private long seed;
    private final RandomGenerator random;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final TIntObjectHashMap<NameDescriptor> fromId = new TIntObjectHashMap();
    private HashSet<String> stringNames = new HashSet();
    private final StringGenerator stringGenerator = new StringGenerator();
    private final Map<NameAndStructureOfIndices, NameDescriptor> fromStructure = new HashMap<NameAndStructureOfIndices, NameDescriptor>();
    private final String[] kroneckerAndMetricNames = new String[]{"d", "g"};
    private final IntArrayList kroneckerAndMetricIds = new IntArrayList();
    public static final String DEFAULT_VAR_SYMBOL_PREFIX = "rc";

    NameManager(Long seed, String kronecker, String metric) {
        if (seed == null) {
            this.random = new Well44497b();
            this.seed = this.random.nextLong();
            this.random.setSeed(this.seed);
        } else {
            this.seed = seed;
            this.random = new Well44497b(this.seed);
        }
        this.kroneckerAndMetricNames[0] = kronecker;
        this.kroneckerAndMetricNames[1] = metric;
    }

    public boolean isKroneckerOrMetric(int name) {
        return ArraysUtils.binarySearch(this.kroneckerAndMetricIds, name) >= 0;
    }

    public String getKroneckerName() {
        return this.kroneckerAndMetricNames[0];
    }

    public String getMetricName() {
        return this.kroneckerAndMetricNames[1];
    }

    public void setKroneckerName(String name) {
        this.kroneckerAndMetricNames[0] = name;
        this.rebuild();
    }

    public void setMetricName(String name) {
        this.kroneckerAndMetricNames[1] = name;
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        this.writeLock.lock();
        try {
            this.fromStructure.clear();
            for (NameDescriptor descriptor : this.fromId.valueCollection()) {
                for (NameAndStructureOfIndices itsan : descriptor.getKeys()) {
                    this.fromStructure.put(itsan, descriptor);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private NameDescriptor createDescriptor(String sname, StructureOfIndices[] structuresOfIndices, int id) {
        if (structuresOfIndices.length != 1) {
            return new NameDescriptorForTensorFieldImpl(sname, structuresOfIndices, id);
        }
        StructureOfIndices its = structuresOfIndices[0];
        if (its.size() != 2) {
            return new NameDescriptorForSimpleTensor(sname, structuresOfIndices, id);
        }
        for (byte b = 0; b < 8; b = (byte)(b + 1)) {
            if (its.typeCount(b) != 2) continue;
            if (CC.isMetric(b)) {
                if (!sname.equals(this.kroneckerAndMetricNames[0]) && !sname.equals(this.kroneckerAndMetricNames[1])) continue;
                NameDescriptorForMetricAndKronecker descriptor = new NameDescriptorForMetricAndKronecker(this.kroneckerAndMetricNames, b, id);
                descriptor.getSymmetries().add(b, false, 1, 0);
                return descriptor;
            }
            if (sname.equals(this.kroneckerAndMetricNames[1])) {
                throw new ParserException("Metric is not specified for non metric index type.");
            }
            if (!sname.equals(this.kroneckerAndMetricNames[0])) continue;
            if (!its.getTypeData((byte)b).states.get(0) || its.getTypeData((byte)b).states.get(1)) {
                throw new ParserException("Illegal Kroneckers indices states.");
            }
            NameDescriptorForMetricAndKronecker descriptor = new NameDescriptorForMetricAndKronecker(this.kroneckerAndMetricNames, b, id);
            return descriptor;
        }
        return new NameDescriptorForSimpleTensor(sname, structuresOfIndices, id);
    }

    private void registerDescriptor(NameDescriptor descriptor) {
        this.fromId.put(descriptor.getId(), (Object)descriptor);
        for (NameAndStructureOfIndices key1 : descriptor.getKeys()) {
            this.fromStructure.put(key1, descriptor);
        }
        descriptor.registerInNameManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameDescriptor mapNameDescriptor(String sname, StructureOfIndices ... structureOfIndices) {
        NameAndStructureOfIndices key = new NameAndStructureOfIndices(sname, structureOfIndices);
        boolean rLocked = true;
        this.readLock.lock();
        try {
            NameDescriptor knownND = this.fromStructure.get(key);
            if (knownND == null) {
                this.readLock.unlock();
                rLocked = false;
                this.writeLock.lock();
                try {
                    knownND = this.fromStructure.get(key);
                    if (knownND == null) {
                        int name = this.generateNewName();
                        NameDescriptor descriptor = this.createDescriptor(sname, structureOfIndices, name);
                        if (descriptor instanceof NameDescriptorForMetricAndKronecker) {
                            this.kroneckerAndMetricIds.add(name);
                            this.kroneckerAndMetricIds.sort();
                        }
                        this.registerDescriptor(descriptor);
                        this.stringNames.add(sname);
                        NameDescriptor nameDescriptor = descriptor;
                        return nameDescriptor;
                    }
                    this.readLock.lock();
                    rLocked = true;
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            NameDescriptor nameDescriptor = knownND;
            return nameDescriptor;
        }
        finally {
            if (rLocked) {
                this.readLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NameDescriptorForTensorFieldDerivative createDescriptorForFieldDerivative(NameDescriptorForTensorFieldImpl field, int[] orders) {
        this.writeLock.lock();
        try {
            NameDescriptorForTensorFieldDerivative result = new NameDescriptorForTensorFieldDerivative(this.generateNewName(), orders, field);
            this.registerDescriptor(result);
            NameDescriptorForTensorFieldDerivative nameDescriptorForTensorFieldDerivative = result;
            return nameDescriptorForTensorFieldDerivative;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void reset() {
        this.writeLock.lock();
        try {
            this.kroneckerAndMetricIds.clear();
            this.stringNames.clear();
            this.fromId.clear();
            this.fromStructure.clear();
            this.seed = this.random.nextLong();
            this.random.setSeed(this.seed);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void reset(long seed) {
        this.writeLock.lock();
        try {
            this.kroneckerAndMetricIds.clear();
            this.stringNames.clear();
            this.fromId.clear();
            this.fromStructure.clear();
            this.seed = seed;
            this.random.setSeed(this.seed);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private int generateNewName() {
        int name;
        while (this.fromId.containsKey(name = this.random.nextInt())) {
        }
        return name;
    }

    public NameDescriptor getNameDescriptor(int nameId) {
        this.readLock.lock();
        try {
            NameDescriptor nameDescriptor = (NameDescriptor)this.fromId.get(nameId);
            return nameDescriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameDescriptor generateNewSymbolDescriptor() {
        boolean rLocked = true;
        this.readLock.lock();
        try {
            String name;
            int newNameId = this.generateNewName();
            while (this.stringNames.contains(name = this.stringGenerator.nextString())) {
            }
            this.stringNames.add(name);
            NameDescriptorForSimpleTensor nd = new NameDescriptorForSimpleTensor(name, new StructureOfIndices[]{StructureOfIndices.getEmpty()}, newNameId);
            this.readLock.unlock();
            rLocked = false;
            this.writeLock.lock();
            try {
                this.registerDescriptor(nd);
                this.readLock.lock();
                rLocked = true;
            }
            finally {
                this.writeLock.unlock();
            }
            NameDescriptorForSimpleTensor nameDescriptorForSimpleTensor = nd;
            return nameDescriptorForSimpleTensor;
        }
        finally {
            if (rLocked) {
                this.readLock.unlock();
            }
        }
    }

    public int size() {
        this.writeLock.lock();
        try {
            int n = this.fromId.size();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public RandomGenerator getRandomGenerator() {
        return this.random;
    }

    private static final class StringGenerator {
        long count = 0L;

        private StringGenerator() {
        }

        String nextString() {
            return NameManager.DEFAULT_VAR_SYMBOL_PREFIX + Long.toString(this.count++);
        }
    }
}

