/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.combinatorics;

import cc.redberry.core.combinatorics.IntCombinatorialPort;
import cc.redberry.core.combinatorics.IntPermutationsGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IntPriorityPermutationsGenerator
implements IntCombinatorialPort {
    private final IntPermutationsGenerator generator;
    private final List<PermutationPriorityTuple> tuples = new ArrayList<PermutationPriorityTuple>();
    private final Set<PermutationPriorityTuple> set = new HashSet<PermutationPriorityTuple>();
    private int[] last = null;
    private int lastTuplePointer = 0;

    public IntPriorityPermutationsGenerator(int dimension) {
        this.generator = new IntPermutationsGenerator(dimension);
    }

    public IntPriorityPermutationsGenerator(int[] initialPermutation) {
        this.generator = new IntPermutationsGenerator(initialPermutation);
    }

    @Override
    public int[] take() {
        if (this.lastTuplePointer == this.tuples.size()) {
            int[] next;
            if (!this.generator.hasNext()) {
                return null;
            }
            do {
                if (this.generator.hasNext()) continue;
                return null;
            } while (this.set.contains(new PermutationPriorityTuple(next = this.generator.next())));
            this.last = next;
            return next;
        }
        return this.tuples.get((int)this.lastTuplePointer++).permutation;
    }

    public void nice() {
        if (this.last == null) {
            int index = this.lastTuplePointer - 1;
            int nPriority = ++this.tuples.get((int)index).priority;
            int position = index;
            while (--position >= 0 && this.tuples.get((int)position).priority < nPriority) {
            }
            this.swap(++position, index);
            return;
        }
        PermutationPriorityTuple tuple = new PermutationPriorityTuple((int[])this.last.clone());
        this.set.add(tuple);
        this.tuples.add(tuple);
        ++this.lastTuplePointer;
    }

    @Override
    public void reset() {
        this.generator.reset();
        this.lastTuplePointer = 0;
        this.last = null;
    }

    @Override
    public int[] getReference() {
        return this.tuples.get((int)(this.lastTuplePointer - 1)).permutation;
    }

    private void swap(int i, int j) {
        PermutationPriorityTuple permutationPriorityTuple = this.tuples.get(i);
        this.tuples.set(i, this.tuples.get(j));
        this.tuples.set(j, permutationPriorityTuple);
    }

    private static class PermutationPriorityTuple {
        final int[] permutation;
        int priority;

        PermutationPriorityTuple(int[] permutation) {
            this.permutation = permutation;
            this.priority = 1;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PermutationPriorityTuple other = (PermutationPriorityTuple)obj;
            return Arrays.equals(this.permutation, other.permutation);
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + Arrays.hashCode(this.permutation);
            return hash;
        }

        public String toString() {
            return Arrays.toString(this.permutation) + " : " + this.priority;
        }
    }
}

