/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootMember;
import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.HollowBuilder;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBranchElement;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TLeafElement;
import hep.io.root.interfaces.TObjArray;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public abstract class TBranchElementRep
extends AbstractRootObject
implements TBranchElement {
    private Class cloneClass;
    private RootInput rin;
    private int curIndex;
    private int fWriteBasket;
    private int[] cBasketBytes;
    private long[] cBasketEntry;
    private long[] cBasketSeek;

    private int[] saveIntSpace(String source, int size) {
        try {
            if (size == 0) {
                return null;
            }
            int[] result = new int[size];
            Field field = this.getClass().getDeclaredField(source);
            Object array = field.get(this);
            for (int i = 0; i < size; ++i) {
                result[i] = Array.getInt(array, i);
            }
            return result;
        }
        catch (Exception x) {
            throw new RuntimeException("Wierd error while compressing " + source, x);
        }
    }

    private long[] saveLongSpace(String source, int size) {
        try {
            if (size == 0) {
                return null;
            }
            long[] result = new long[size];
            Field field = this.getClass().getDeclaredField(source);
            Object array = field.get(this);
            for (int i = 0; i < size; ++i) {
                result[i] = Array.getLong(array, i);
            }
            return result;
        }
        catch (Exception x) {
            throw new RuntimeException("Wierd error while compressing " + source, x);
        }
    }

    public Class getCloneClass() {
        try {
            if (this.cloneClass == null) {
                HollowBuilder builder = new HollowBuilder(this, "fTracks.", true);
                String name = "hep.io.root.hollow." + this.getClonesName();
                RootClassFactory factory = this.rin.getFactory();
                GenericRootClass gc = (GenericRootClass)factory.create(this.getClonesName());
                this.cloneClass = factory.getLoader().loadSpecial(builder, name, gc);
                builder.populateStatics(this.cloneClass, factory);
            }
            return this.cloneClass;
        }
        catch (RootClassNotFound x) {
            throw new RuntimeException("Error looking up class for TBranchClones " + x.getClassName(), x);
        }
    }

    public void read(RootInput in) throws IOException {
        super.read(in);
        this.rin = in.getTop();
        this.cBasketBytes = this.saveIntSpace("fBasketBytes", this.fWriteBasket);
        this.cBasketEntry = this.saveLongSpace("fBasketEntry", this.fWriteBasket + 1);
        this.cBasketSeek = this.saveLongSpace("fBasketSeek", this.fWriteBasket);
        TObjArray leaves = this.getLeaves();
        if (leaves != null) {
            for (int i = 0; i < leaves.size(); ++i) {
                TLeaf leaf = (TLeaf)leaves.get(i);
                leaf.setBranch(this);
            }
        }
        this.curIndex = -1;
        String className = this.getClassName();
        int fId = this.getID();
        try {
            BasicRootClass rc = in.getFactory().create(className);
            RootClass[] sup = rc.getSuperClasses();
            if ((fId -= sup.length) >= 0) {
                RootMember[] members = rc.getMembers();
                RootMember member = members[fId];
                if (leaves != null) {
                    for (int i = 0; i < leaves.size(); ++i) {
                        TLeafElement leaf = (TLeafElement)leaves.get(i);
                        leaf.setMember(member);
                    }
                }
            }
        }
        catch (RootClassNotFound x) {
            IOException io = new IOException("Could not find root class " + className);
            io.initCause(x);
            throw io;
        }
    }
}

