/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.CloseOperation;
import hep.io.root.daemon.xrootd.Destination;
import hep.io.root.daemon.xrootd.DirListOperation;
import hep.io.root.daemon.xrootd.Dispatcher;
import hep.io.root.daemon.xrootd.FileStatus;
import hep.io.root.daemon.xrootd.FutureResponse;
import hep.io.root.daemon.xrootd.LocateOperation;
import hep.io.root.daemon.xrootd.OpenFile;
import hep.io.root.daemon.xrootd.OpenOperation;
import hep.io.root.daemon.xrootd.Operation;
import hep.io.root.daemon.xrootd.PingOperation;
import hep.io.root.daemon.xrootd.PrepareOperation;
import hep.io.root.daemon.xrootd.ProtocolOperation;
import hep.io.root.daemon.xrootd.QueryOperation;
import hep.io.root.daemon.xrootd.ReadOperation;
import hep.io.root.daemon.xrootd.RemoveOperation;
import hep.io.root.daemon.xrootd.StatOperation;
import hep.io.root.daemon.xrootd.WriteOperation;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private static Logger logger = Logger.getLogger(Session.class.getName());
    private Dispatcher dispatcher = Dispatcher.instance();
    private Destination destination;

    public Session(String host, int port, String userName) throws IOException {
        this(new Destination(host, port, userName));
    }

    Session(Destination dest) throws IOException {
        this.destination = dest;
    }

    public void close() throws IOException {
    }

    public <V> FutureResponse<V> send(Operation<V> operation) {
        Destination actualDestination = operation.getDestination();
        if (actualDestination == null) {
            actualDestination = this.destination;
        }
        return this.dispatcher.send(actualDestination, operation);
    }

    public List<String> dirList(String path) throws IOException {
        return this.send(new DirListOperation(path)).getResponse();
    }

    public void ping() throws IOException {
        this.send(new PingOperation()).getResponse();
    }

    public void remove(String path) throws IOException {
        this.send(new RemoveOperation(path)).getResponse();
    }

    public FileStatus stat(String path) throws IOException {
        return this.send(new StatOperation(path)).getResponse();
    }

    public String query(int queryType, String path) throws IOException {
        return this.send(new QueryOperation(queryType, path)).getResponse();
    }

    public String prepare(String[] path, int options, int priority) throws IOException {
        return this.send(new PrepareOperation(path, options, priority)).getResponse();
    }

    public String[] locate(String path, boolean noWait, boolean refresh) throws IOException {
        return this.send(new LocateOperation(path, noWait, refresh)).getResponse();
    }

    public String protocol() throws IOException {
        return this.send(new ProtocolOperation()).getResponse();
    }

    public OpenFile open(String path, int mode, int options) throws IOException {
        return this.send(new OpenOperation(path, mode, options)).getResponse();
    }

    public void close(OpenFile file) throws IOException {
        this.send(new CloseOperation(file)).getResponse();
    }

    public int read(OpenFile file, long fileOffset, byte[] buffer) throws IOException {
        return this.read(file, fileOffset, buffer, 0, buffer.length);
    }

    public int read(OpenFile file, long fileOffset, byte[] buffer, int bufOffset, int size) throws IOException {
        return this.send(new ReadOperation(file, fileOffset, buffer, bufOffset, size)).getResponse();
    }

    public void write(OpenFile file, long fileOffset, byte[] buffer, int offset, int length) throws IOException {
        this.send(new WriteOperation(file, fileOffset, buffer, offset, length));
    }

    public String toString() {
        return this.destination.toString();
    }
}

