/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

class AuthentificationPanel
extends JPanel {
    private JPasswordField passwordTextField;
    private JComboBox schemeComboBox;
    private JTextField userTextField;

    AuthentificationPanel(String scheme) {
        this.initComponents();
        boolean anon = scheme != null && scheme.equalsIgnoreCase("anonymous");
        this.schemeComboBox.setSelectedIndex(anon ? 0 : 1);
    }

    PasswordAuthentication getPasswordAuthentication() {
        boolean anon;
        String username = this.userTextField.getText();
        char[] password = this.passwordTextField.getPassword();
        boolean bl = anon = this.schemeComboBox.getSelectedIndex() == 0;
        if (anon) {
            username = "anonymous";
            try {
                password = (System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getCanonicalHostName()).toCharArray();
            }
            catch (Throwable x) {
                password = "freehep-user@freehep.org".toCharArray();
            }
        }
        return new PasswordAuthentication(username, password);
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.schemeComboBox = new JComboBox();
        JLabel jLabel2 = new JLabel();
        this.userTextField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.setLayout(new GridBagLayout());
        jLabel1.setText("Authentification required for access to root daemon");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jLabel1, gridBagConstraints);
        jLabel4.setText("Scheme:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel4, gridBagConstraints);
        this.schemeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Anonymous", "UsrPwd"}));
        this.schemeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthentificationPanel.this.setEnabled(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.schemeComboBox, gridBagConstraints);
        jLabel2.setText("Username:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel2, gridBagConstraints);
        this.userTextField.setText(System.getProperty("user.name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.userTextField, gridBagConstraints);
        jLabel3.setText("Password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.passwordTextField, gridBagConstraints);
    }

    private void setEnabled(ActionEvent evt) {
        boolean anon = this.schemeComboBox.getSelectedIndex() == 0;
        this.passwordTextField.setEnabled(!anon);
        this.userTextField.setEnabled(!anon);
    }
}

