/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.core.ClassBuilder;
import hep.io.root.core.Clone2Builder;
import hep.io.root.core.CloneBuilder;
import hep.io.root.core.ClonesBuilder;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.InterfaceBuilder;
import hep.io.root.core.NameMangler;
import hep.io.root.core.Proxy2Builder;
import hep.io.root.core.ProxyBuilder;
import hep.io.root.test.JasminVisitor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;

public class RootClassLoader
extends ClassLoader {
    private static final boolean debugRoot = System.getProperty("debugRoot") != null;
    private Map<Class, GenericRootClass> classMap = new HashMap<Class, GenericRootClass>();
    private Map<String, ClassBuilder> stemMap = new HashMap<String, ClassBuilder>();
    private RootFileReader rfr;
    private static final Object bcelLock = new Object();
    private NameMangler nameMangler = NameMangler.instance();

    RootClassLoader(RootFileReader rfr) {
        super(RootClassLoader.class.getClassLoader());
        this.rfr = rfr;
        this.register(new InterfaceBuilder());
        this.register(new ProxyBuilder());
        this.register(new Proxy2Builder());
        this.register(new ClonesBuilder());
        this.register(new CloneBuilder());
        this.register(new Clone2Builder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String name) throws ClassNotFoundException {
        try {
            JavaClass jc;
            if (debugRoot) {
                System.out.println("RootClassLoader: loading " + name);
            }
            String stem = this.nameMangler.getStemForJavaClass(name);
            String rootClassName = this.nameMangler.getClassForJavaClass(name);
            ClassBuilder builder = this.stemMap.get(stem);
            GenericRootClass gc = (GenericRootClass)this.rfr.getFactory().create(rootClassName);
            if (debugRoot) {
                System.out.println("RootClassLoader: (2) loading " + name);
            }
            Object object = bcelLock;
            synchronized (object) {
                jc = builder.build(gc);
            }
            if (debugRoot) {
                System.out.println("RootClassLoader: (3) loading " + name);
            }
            if (debugRoot) {
                try {
                    FileOutputStream out = new FileOutputStream(name + ".j");
                    new JasminVisitor(jc, out).disassemble();
                    out.close();
                }
                catch (IOException out) {
                    // empty catch block
                }
            }
            byte[] data = jc.getBytes();
            if (debugRoot) {
                System.out.println("Object length=" + Long.toString(data.length));
            }
            Class<?> result = this.defineClass(name, data, 0, data.length);
            this.classMap.put(result, gc);
            if (debugRoot) {
                System.out.println("RootClassLoader: (4) loading " + name);
            }
            return result;
        }
        catch (RootClassNotFound x) {
            throw new ClassNotFoundException(name);
        }
    }

    public Class loadSpecial(ClassBuilder builder, String name, GenericRootClass rc) {
        if (debugRoot) {
            System.out.println("RootClassLoader: loading special " + name);
        }
        JavaClass jc = builder.build(rc);
        if (debugRoot) {
            try {
                FileOutputStream out = new FileOutputStream(name + ".j");
                new JasminVisitor(jc, out).disassemble();
                out.close();
            }
            catch (IOException out) {
                // empty catch block
            }
        }
        byte[] data = jc.getBytes();
        Class<?> result = this.defineClass(name, data, 0, data.length);
        this.classMap.put(result, rc);
        return result;
    }

    GenericRootClass getRootClass(Class klass) {
        return this.classMap.get(klass);
    }

    private void register(ClassBuilder builder) {
        this.stemMap.put(builder.getStem(), builder);
    }
}

