/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.util.Random;
import org.ejml.alg.generic.GenericMatrixOps;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RealMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.CovarianceRandomDraw;
import org.ejml.ops.RandomMatrices;
import org.ejml.simple.SimpleBase;

public class SimpleMatrix
extends SimpleBase<SimpleMatrix> {
    public static final int END = Integer.MAX_VALUE;

    public SimpleMatrix(int n, int n2, boolean bl, double ... dArray) {
        this.mat = new DenseMatrix64F(n, n2, bl, dArray);
    }

    public SimpleMatrix(double[][] dArray) {
        this.mat = new DenseMatrix64F(dArray);
    }

    public SimpleMatrix(int n, int n2) {
        this.mat = new DenseMatrix64F(n, n2);
    }

    public SimpleMatrix(SimpleMatrix simpleMatrix) {
        this.mat = simpleMatrix.mat.copy();
    }

    public SimpleMatrix(DenseMatrix64F denseMatrix64F) {
        this.mat = denseMatrix64F.copy();
    }

    public SimpleMatrix(RealMatrix64F realMatrix64F) {
        this.mat = new DenseMatrix64F(realMatrix64F.getNumRows(), realMatrix64F.getNumCols());
        GenericMatrixOps.copy(realMatrix64F, this.mat);
    }

    public SimpleMatrix() {
    }

    public static SimpleMatrix wrap(DenseMatrix64F denseMatrix64F) {
        SimpleMatrix simpleMatrix = new SimpleMatrix();
        simpleMatrix.mat = denseMatrix64F;
        return simpleMatrix;
    }

    public static SimpleMatrix identity(int n) {
        SimpleMatrix simpleMatrix = new SimpleMatrix(n, n);
        CommonOps.setIdentity(simpleMatrix.mat);
        return simpleMatrix;
    }

    public static SimpleMatrix diag(double ... dArray) {
        DenseMatrix64F denseMatrix64F = CommonOps.diag(dArray);
        SimpleMatrix simpleMatrix = SimpleMatrix.wrap(denseMatrix64F);
        return simpleMatrix;
    }

    public static SimpleMatrix random(int n, int n2, double d, double d2, Random random) {
        SimpleMatrix simpleMatrix = new SimpleMatrix(n, n2);
        RandomMatrices.setRandom(simpleMatrix.mat, d, d2, random);
        return simpleMatrix;
    }

    public static SimpleMatrix randomNormal(SimpleMatrix simpleMatrix, Random random) {
        CovarianceRandomDraw covarianceRandomDraw = new CovarianceRandomDraw(random, simpleMatrix.getMatrix());
        SimpleMatrix simpleMatrix2 = new SimpleMatrix(simpleMatrix.numRows(), 1);
        covarianceRandomDraw.next(simpleMatrix2.getMatrix());
        return simpleMatrix2;
    }

    @Override
    protected SimpleMatrix createMatrix(int n, int n2) {
        return new SimpleMatrix(n, n2);
    }
}

