/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import org.ejml.data.Complex64F;
import org.ejml.data.ComplexMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RealMatrix32F;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.ReshapeMatrix;
import org.ejml.ops.ReadMatrixCsv;

public class MatrixIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBin(RealMatrix64F realMatrix64F, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        try {
            objectOutputStream.writeObject(realMatrix64F);
            objectOutputStream.flush();
        }
        finally {
            try {
                objectOutputStream.close();
            }
            finally {
                fileOutputStream.close();
            }
        }
    }

    public static <T extends RealMatrix64F> T loadBin(String string) throws IOException {
        RealMatrix64F realMatrix64F;
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        try {
            realMatrix64F = (RealMatrix64F)objectInputStream.readObject();
            if (objectInputStream.available() != 0) {
                throw new RuntimeException("File not completely read?");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        objectInputStream.close();
        return (T)realMatrix64F;
    }

    public static void saveCSV(RealMatrix64F realMatrix64F, String string) throws IOException {
        PrintStream printStream = new PrintStream(string);
        printStream.println(realMatrix64F.getNumRows() + " " + realMatrix64F.getNumCols() + " real");
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                printStream.print(realMatrix64F.get(i, j) + " ");
            }
            printStream.println();
        }
        printStream.close();
    }

    public static DenseMatrix64F loadCSV(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ReadMatrixCsv readMatrixCsv = new ReadMatrixCsv(fileInputStream);
        DenseMatrix64F denseMatrix64F = (DenseMatrix64F)readMatrixCsv.read();
        fileInputStream.close();
        return denseMatrix64F;
    }

    public static DenseMatrix64F loadCSV(String string, int n, int n2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ReadMatrixCsv readMatrixCsv = new ReadMatrixCsv(fileInputStream);
        DenseMatrix64F denseMatrix64F = readMatrixCsv.readReal(n, n2);
        fileInputStream.close();
        return denseMatrix64F;
    }

    public static void print(PrintStream printStream, RealMatrix64F realMatrix64F) {
        MatrixIO.print(printStream, realMatrix64F, 6, 3);
    }

    public static void print(PrintStream printStream, RealMatrix64F realMatrix64F, int n, int n2) {
        String string = "%" + n + "." + n2 + "f ";
        MatrixIO.print(printStream, realMatrix64F, string);
    }

    public static void print(PrintStream printStream, RealMatrix64F realMatrix64F, String string) {
        String string2 = ReshapeMatrix.class.isAssignableFrom(realMatrix64F.getClass()) ? "dense" : "dense fixed";
        printStream.println("Type = " + string2 + " real , numRows = " + realMatrix64F.getNumRows() + " , numCols = " + realMatrix64F.getNumCols());
        string = string + " ";
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                printStream.printf(string, realMatrix64F.get(i, j));
            }
            printStream.println();
        }
    }

    public static void print(PrintStream printStream, RealMatrix32F realMatrix32F) {
        MatrixIO.print(printStream, realMatrix32F, 6, 3);
    }

    public static void print(PrintStream printStream, RealMatrix32F realMatrix32F, int n, int n2) {
        String string = "%" + n + "." + n2 + "f ";
        MatrixIO.print(printStream, realMatrix32F, string);
    }

    public static void print(PrintStream printStream, RealMatrix32F realMatrix32F, String string) {
        String string2 = ReshapeMatrix.class.isAssignableFrom(realMatrix32F.getClass()) ? "dense" : "dense fixed";
        printStream.println("Type = " + string2 + " , numRows = " + realMatrix32F.getNumRows() + " , numCols = " + realMatrix32F.getNumCols());
        string = string + " ";
        for (int i = 0; i < realMatrix32F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix32F.getNumCols(); ++j) {
                printStream.printf(string, Float.valueOf(realMatrix32F.get(i, j)));
            }
            printStream.println();
        }
    }

    public static void print(PrintStream printStream, RealMatrix64F realMatrix64F, String string, int n, int n2, int n3, int n4) {
        printStream.println("Type = submatrix , rows " + n + " to " + n2 + "  columns " + n3 + " to " + n4);
        string = string + " ";
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                printStream.printf(string, realMatrix64F.get(i, j));
            }
            printStream.println();
        }
    }

    public static void print(PrintStream printStream, ComplexMatrix64F complexMatrix64F) {
        MatrixIO.print(printStream, complexMatrix64F, 6, 3);
    }

    public static void print(PrintStream printStream, ComplexMatrix64F complexMatrix64F, int n, int n2) {
        String string = "%" + n + "." + n2 + "f + %" + n + "." + n2 + "fi";
        MatrixIO.print(printStream, complexMatrix64F, string);
    }

    public static void print(PrintStream printStream, ComplexMatrix64F complexMatrix64F, String string) {
        String string2 = "dense";
        printStream.println("Type = " + string2 + " complex , numRows = " + complexMatrix64F.getNumRows() + " , numCols = " + complexMatrix64F.getNumCols());
        string = string + " ";
        Complex64F complex64F = new Complex64F();
        for (int i = 0; i < complexMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < complexMatrix64F.getNumCols(); ++j) {
                complexMatrix64F.get(i, j, complex64F);
                printStream.printf(string, complex64F.real, complex64F.imaginary);
                if (j >= complexMatrix64F.getNumCols() - 1) continue;
                printStream.print(" , ");
            }
            printStream.println();
        }
    }
}

