/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.data.Complex64F;
import org.ejml.data.ComplexMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix32F;
import org.ejml.data.RealMatrix64F;

public class EjmlUnitTests {
    public static void assertCountable(RealMatrix64F realMatrix64F) {
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                EjmlUnitTests.assertTrue(!Double.isNaN(realMatrix64F.get(i, j)), "NaN found at " + i + " " + j);
                EjmlUnitTests.assertTrue(!Double.isInfinite(realMatrix64F.get(i, j)), "Infinite found at " + i + " " + j);
            }
        }
    }

    public static void assertShape(Matrix matrix, Matrix matrix2) {
        EjmlUnitTests.assertTrue(matrix.getNumRows() == matrix2.getNumRows(), "Number of rows do not match");
        EjmlUnitTests.assertTrue(matrix.getNumCols() == matrix2.getNumCols(), "Number of columns do not match");
    }

    public static void assertShape(RealMatrix64F realMatrix64F, int n, int n2) {
        EjmlUnitTests.assertTrue(realMatrix64F.getNumRows() == n, "Unexpected number of rows.");
        EjmlUnitTests.assertTrue(realMatrix64F.getNumCols() == n2, "Unexpected number of columns.");
    }

    public static void assertEqualsUncountable(RealMatrix64F realMatrix64F, RealMatrix64F realMatrix64F2, double d) {
        EjmlUnitTests.assertShape(realMatrix64F, realMatrix64F2);
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                double d2 = realMatrix64F.get(i, j);
                double d3 = realMatrix64F2.get(i, j);
                if (Double.isNaN(d2)) {
                    EjmlUnitTests.assertTrue(Double.isNaN(d3), "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
                    continue;
                }
                if (Double.isInfinite(d2)) {
                    EjmlUnitTests.assertTrue(Double.isInfinite(d3), "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
                    continue;
                }
                double d4 = Math.abs(d2 - d3);
                EjmlUnitTests.assertTrue(d4 <= d, "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
            }
        }
    }

    public static void assertEquals(RealMatrix64F realMatrix64F, RealMatrix64F realMatrix64F2, double d) {
        EjmlUnitTests.assertShape(realMatrix64F, realMatrix64F2);
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                double d2 = realMatrix64F.get(i, j);
                double d3 = realMatrix64F2.get(i, j);
                EjmlUnitTests.assertTrue(!Double.isNaN(d2) && !Double.isNaN(d3), "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
                EjmlUnitTests.assertTrue(!Double.isInfinite(d2) && !Double.isInfinite(d3), "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
                EjmlUnitTests.assertTrue(Math.abs(d2 - d3) <= d, "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
            }
        }
    }

    public static void assertEquals(RealMatrix32F realMatrix32F, RealMatrix32F realMatrix32F2, float f) {
        EjmlUnitTests.assertShape(realMatrix32F, realMatrix32F2);
        for (int i = 0; i < realMatrix32F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix32F.getNumCols(); ++j) {
                float f2 = realMatrix32F.get(i, j);
                float f3 = realMatrix32F2.get(i, j);
                EjmlUnitTests.assertTrue(!Float.isNaN(f2) && !Float.isNaN(f3), "At (" + i + "," + j + ") A = " + f2 + " B = " + f3);
                EjmlUnitTests.assertTrue(!Float.isInfinite(f2) && !Float.isInfinite(f3), "At (" + i + "," + j + ") A = " + f2 + " B = " + f3);
                EjmlUnitTests.assertTrue(Math.abs(f2 - f3) <= f, "At (" + i + "," + j + ") A = " + f2 + " B = " + f3);
            }
        }
    }

    public static void assertEquals(Complex64F complex64F, Complex64F complex64F2, double d) {
        EjmlUnitTests.assertTrue(!Double.isNaN(complex64F.real) && !Double.isNaN(complex64F2.real), "real a = " + complex64F.real + " b = " + complex64F2.real);
        EjmlUnitTests.assertTrue(!Double.isInfinite(complex64F.real) && !Double.isInfinite(complex64F2.real), "real a = " + complex64F.real + " b = " + complex64F2.real);
        EjmlUnitTests.assertTrue(Math.abs(complex64F.real - complex64F2.real) <= d, "real a = " + complex64F.real + " b = " + complex64F2.real);
        EjmlUnitTests.assertTrue(!Double.isNaN(complex64F.imaginary) && !Double.isNaN(complex64F2.imaginary), "imaginary a = " + complex64F.imaginary + " b = " + complex64F2.imaginary);
        EjmlUnitTests.assertTrue(!Double.isInfinite(complex64F.imaginary) && !Double.isInfinite(complex64F2.imaginary), "imaginary a = " + complex64F.imaginary + " b = " + complex64F2.imaginary);
        EjmlUnitTests.assertTrue(Math.abs(complex64F.imaginary - complex64F2.imaginary) <= d, "imaginary a = " + complex64F.imaginary + " b = " + complex64F2.imaginary);
    }

    public static void assertEquals(ComplexMatrix64F complexMatrix64F, ComplexMatrix64F complexMatrix64F2, double d) {
        EjmlUnitTests.assertShape(complexMatrix64F, complexMatrix64F2);
        Complex64F complex64F = new Complex64F();
        Complex64F complex64F2 = new Complex64F();
        for (int i = 0; i < complexMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < complexMatrix64F.getNumCols(); ++j) {
                complexMatrix64F.get(i, j, complex64F);
                complexMatrix64F2.get(i, j, complex64F2);
                EjmlUnitTests.assertTrue(!Double.isNaN(complex64F.real) && !Double.isNaN(complex64F2.real), "Real At (" + i + "," + j + ") A = " + complex64F.real + " B = " + complex64F2.real);
                EjmlUnitTests.assertTrue(!Double.isInfinite(complex64F.real) && !Double.isInfinite(complex64F2.real), "Real At (" + i + "," + j + ") A = " + complex64F.real + " B = " + complex64F2.real);
                EjmlUnitTests.assertTrue(Math.abs(complex64F.real - complex64F2.real) <= d, "Real At (" + i + "," + j + ") A = " + complex64F.real + " B = " + complex64F2.real);
                EjmlUnitTests.assertTrue(!Double.isNaN(complex64F.imaginary) && !Double.isNaN(complex64F2.imaginary), "Img At (" + i + "," + j + ") A = " + complex64F.imaginary + " B = " + complex64F2.imaginary);
                EjmlUnitTests.assertTrue(!Double.isInfinite(complex64F.imaginary) && !Double.isInfinite(complex64F2.imaginary), "Img At (" + i + "," + j + ") A = " + complex64F.imaginary + " B = " + complex64F2.imaginary);
                EjmlUnitTests.assertTrue(Math.abs(complex64F.imaginary - complex64F2.imaginary) <= d, "Img At (" + i + "," + j + ") A = " + complex64F.imaginary + " B = " + complex64F2.imaginary);
            }
        }
    }

    public static void assertEqualsTrans(RealMatrix64F realMatrix64F, RealMatrix64F realMatrix64F2, double d) {
        EjmlUnitTests.assertShape(realMatrix64F, realMatrix64F2.getNumCols(), realMatrix64F2.getNumRows());
        for (int i = 0; i < realMatrix64F.getNumRows(); ++i) {
            for (int j = 0; j < realMatrix64F.getNumCols(); ++j) {
                double d2 = realMatrix64F.get(i, j);
                double d3 = realMatrix64F2.get(j, i);
                EjmlUnitTests.assertTrue(!Double.isNaN(d2) && !Double.isNaN(d3), "A(" + i + "," + j + ") = " + d2 + ") B(" + j + "," + i + ") = " + d3);
                EjmlUnitTests.assertTrue(!Double.isInfinite(d2) && !Double.isInfinite(d3), "A(" + i + "," + j + ") = " + d2 + ") B(" + j + "," + i + ") = " + d3);
                EjmlUnitTests.assertTrue(Math.abs(d2 - d3) <= d, "A(" + i + "," + j + ") = " + d2 + ") B(" + j + "," + i + ") = " + d3);
            }
        }
    }

    private static void assertTrue(boolean bl, String string) {
        assert (bl) : string;
        if (!bl) {
            throw new TestException(string);
        }
    }

    public static class TestException
    extends RuntimeException {
        public TestException(String string) {
            super(string);
        }
    }
}

