/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.factory;

import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner_D64;
import org.ejml.alg.dense.decomposition.lu.LUDecompositionAlt_D64;
import org.ejml.alg.dense.decomposition.qr.QRColPivDecompositionHouseholderColumn_D64;
import org.ejml.alg.dense.linsol.AdjustableLinearSolver;
import org.ejml.alg.dense.linsol.chol.LinearSolverChol_B64;
import org.ejml.alg.dense.linsol.chol.LinearSolverChol_D64;
import org.ejml.alg.dense.linsol.lu.LinearSolverLu_D64;
import org.ejml.alg.dense.linsol.qr.AdjLinearSolverQr_D64;
import org.ejml.alg.dense.linsol.qr.LinearSolverQrBlock64_D64;
import org.ejml.alg.dense.linsol.qr.LinearSolverQrHouseCol_D64;
import org.ejml.alg.dense.linsol.qr.LinearSolverQrpHouseCol_D64;
import org.ejml.alg.dense.linsol.qr.SolvePseudoInverseQrp_D64;
import org.ejml.alg.dense.linsol.svd.SolvePseudoInverseSvd;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.linsol.LinearSolver;

public class LinearSolverFactory {
    public static LinearSolver<DenseMatrix64F> lu(int n) {
        return LinearSolverFactory.linear(n);
    }

    public static LinearSolver<DenseMatrix64F> chol(int n) {
        return LinearSolverFactory.symmPosDef(n);
    }

    public static LinearSolver<DenseMatrix64F> qr(int n, int n2) {
        return LinearSolverFactory.leastSquares(n, n2);
    }

    public static LinearSolver<DenseMatrix64F> qrp(boolean bl, boolean bl2) {
        return LinearSolverFactory.leastSquaresQrPivot(bl, bl2);
    }

    public static LinearSolver<DenseMatrix64F> general(int n, int n2) {
        if (n == n2) {
            return LinearSolverFactory.linear(n);
        }
        return LinearSolverFactory.leastSquares(n, n2);
    }

    public static LinearSolver<DenseMatrix64F> linear(int n) {
        return new LinearSolverLu_D64(new LUDecompositionAlt_D64());
    }

    public static LinearSolver<DenseMatrix64F> leastSquares(int n, int n2) {
        if (n2 < EjmlParameters.SWITCH_BLOCK64_QR) {
            return new LinearSolverQrHouseCol_D64();
        }
        if (EjmlParameters.MEMORY == EjmlParameters.MemoryUsage.FASTER) {
            return new LinearSolverQrBlock64_D64();
        }
        return new LinearSolverQrHouseCol_D64();
    }

    public static LinearSolver<DenseMatrix64F> symmPosDef(int n) {
        if (n < EjmlParameters.SWITCH_BLOCK64_CHOLESKY) {
            CholeskyDecompositionInner_D64 choleskyDecompositionInner_D64 = new CholeskyDecompositionInner_D64(true);
            return new LinearSolverChol_D64(choleskyDecompositionInner_D64);
        }
        if (EjmlParameters.MEMORY == EjmlParameters.MemoryUsage.FASTER) {
            return new LinearSolverChol_B64();
        }
        CholeskyDecompositionInner_D64 choleskyDecompositionInner_D64 = new CholeskyDecompositionInner_D64(true);
        return new LinearSolverChol_D64(choleskyDecompositionInner_D64);
    }

    public static LinearSolver<DenseMatrix64F> leastSquaresQrPivot(boolean bl, boolean bl2) {
        QRColPivDecompositionHouseholderColumn_D64 qRColPivDecompositionHouseholderColumn_D64 = new QRColPivDecompositionHouseholderColumn_D64();
        if (bl2) {
            return new SolvePseudoInverseQrp_D64(qRColPivDecompositionHouseholderColumn_D64, bl);
        }
        return new LinearSolverQrpHouseCol_D64(qRColPivDecompositionHouseholderColumn_D64, bl);
    }

    public static LinearSolver<DenseMatrix64F> pseudoInverse(boolean bl) {
        if (bl) {
            return new SolvePseudoInverseSvd();
        }
        return LinearSolverFactory.leastSquaresQrPivot(true, false);
    }

    public static AdjustableLinearSolver adjustable() {
        return new AdjLinearSolverQr_D64();
    }
}

