/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.equation;

import java.util.List;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.equation.ManagerTempVariables;
import org.ejml.equation.MatrixConstructor;
import org.ejml.equation.Variable;
import org.ejml.equation.VariableDouble;
import org.ejml.equation.VariableInteger;
import org.ejml.equation.VariableMatrix;
import org.ejml.equation.VariableScalar;
import org.ejml.equation.VariableSpecial;
import org.ejml.equation.VariableType;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.NormOps;

public abstract class Operation {
    String name;

    protected Operation(String string) {
        this.name = string;
    }

    public abstract void process();

    public String name() {
        return this.name;
    }

    protected void resize(VariableMatrix variableMatrix, int n, int n2) {
        if (variableMatrix.isTemp()) {
            variableMatrix.matrix.reshape(n, n2);
        }
    }

    public static Info multiply(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix && variable2 instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("multiply-mm"){

                @Override
                public void process() {
                    VariableMatrix variableMatrix3 = (VariableMatrix)variable;
                    VariableMatrix variableMatrix2 = (VariableMatrix)variable2;
                    this.resize(variableMatrix, variableMatrix3.matrix.numRows, variableMatrix2.matrix.numCols);
                    CommonOps.mult(variableMatrix3.matrix, variableMatrix2.matrix, variableMatrix.matrix);
                }
            };
        } else if (variable instanceof VariableInteger && variable2 instanceof VariableInteger) {
            final VariableInteger variableInteger = managerTempVariables.createInteger();
            info.output = variableInteger;
            info.op = new Operation("multiply-ii"){

                @Override
                public void process() {
                    VariableInteger variableInteger3 = (VariableInteger)variable;
                    VariableInteger variableInteger2 = (VariableInteger)variable2;
                    variableInteger.value = variableInteger3.value * variableInteger2.value;
                }
            };
        } else if (variable instanceof VariableScalar && variable2 instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("multiply-ss"){

                @Override
                public void process() {
                    VariableScalar variableScalar = (VariableScalar)variable;
                    VariableScalar variableScalar2 = (VariableScalar)variable2;
                    variableDouble.value = variableScalar.getDouble() * variableScalar2.getDouble();
                }
            };
        } else {
            VariableScalar variableScalar;
            VariableMatrix variableMatrix;
            final VariableMatrix variableMatrix2 = managerTempVariables.createMatrix();
            info.output = variableMatrix2;
            if (variable instanceof VariableMatrix) {
                variableMatrix = (VariableMatrix)variable;
                variableScalar = (VariableScalar)variable2;
            } else {
                variableMatrix = (VariableMatrix)variable2;
                variableScalar = (VariableScalar)variable;
            }
            info.op = new Operation("multiply-ms"){

                @Override
                public void process() {
                    variableMatrix2.matrix.reshape(variableMatrix.matrix.numRows, variableMatrix.matrix.numCols);
                    CommonOps.scale(variableScalar.getDouble(), variableMatrix.matrix, variableMatrix2.matrix);
                }
            };
        }
        return info;
    }

    public static Info divide(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix && variable2 instanceof VariableMatrix) {
            return Operation.solve(variable2, variable, managerTempVariables);
        }
        if (variable instanceof VariableMatrix && variable2 instanceof VariableScalar) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            final VariableMatrix variableMatrix2 = (VariableMatrix)variable;
            final VariableScalar variableScalar = (VariableScalar)variable2;
            info.output = variableMatrix;
            info.op = new Operation("divide-ma"){

                @Override
                public void process() {
                    variableMatrix.matrix.reshape(variableMatrix2.matrix.numRows, variableMatrix2.matrix.numCols);
                    CommonOps.divide(variableMatrix2.matrix, variableScalar.getDouble(), (D1Matrix64F)variableMatrix.matrix);
                }
            };
        } else if (variable instanceof VariableScalar && variable2 instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            final VariableMatrix variableMatrix3 = (VariableMatrix)variable2;
            final VariableScalar variableScalar = (VariableScalar)variable;
            info.output = variableMatrix;
            info.op = new Operation("divide-ma"){

                @Override
                public void process() {
                    variableMatrix.matrix.reshape(variableMatrix3.matrix.numRows, variableMatrix3.matrix.numCols);
                    CommonOps.divide(variableScalar.getDouble(), variableMatrix3.matrix, (D1Matrix64F)variableMatrix.matrix);
                }
            };
        } else if (variable instanceof VariableInteger && variable2 instanceof VariableInteger) {
            final VariableInteger variableInteger = managerTempVariables.createInteger();
            info.output = variableInteger;
            info.op = new Operation("divide-ii"){

                @Override
                public void process() {
                    VariableInteger variableInteger3 = (VariableInteger)variable;
                    VariableInteger variableInteger2 = (VariableInteger)variable2;
                    variableInteger.value = variableInteger3.value / variableInteger2.value;
                }
            };
        } else {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("divide-ss"){

                @Override
                public void process() {
                    VariableScalar variableScalar = (VariableScalar)variable;
                    VariableScalar variableScalar2 = (VariableScalar)variable2;
                    variableDouble.value = variableScalar.getDouble() / variableScalar2.getDouble();
                }
            };
        }
        return info;
    }

    public static Info neg(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableInteger) {
            final VariableInteger variableInteger = managerTempVariables.createInteger();
            info.output = variableInteger;
            info.op = new Operation("neg-i"){

                @Override
                public void process() {
                    variableInteger.value = -((VariableInteger)variable).value;
                }
            };
        } else if (variable instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("neg-s"){

                @Override
                public void process() {
                    variableDouble.value = -((VariableScalar)variable).getDouble();
                }
            };
        } else if (variable instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("neg-m"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    variableMatrix.matrix.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.changeSign(denseMatrix64F, variableMatrix.matrix);
                }
            };
        } else {
            throw new RuntimeException("Unsupported variable " + variable);
        }
        return info;
    }

    public static Info pow(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        if (!(variable instanceof VariableScalar) || !(variable2 instanceof VariableScalar)) {
            throw new RuntimeException("Only scalar to scalar power supported");
        }
        info.op = new Operation("pow-ss"){

            @Override
            public void process() {
                double d = ((VariableScalar)variable).getDouble();
                double d2 = ((VariableScalar)variable2).getDouble();
                variableDouble.value = Math.pow(d, d2);
            }
        };
        return info;
    }

    public static Info atan2(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        if (!(variable instanceof VariableScalar) || !(variable2 instanceof VariableScalar)) {
            throw new RuntimeException("Only scalar to scalar atan2 supported");
        }
        info.op = new Operation("atan2-ss"){

            @Override
            public void process() {
                double d = ((VariableScalar)variable).getDouble();
                double d2 = ((VariableScalar)variable2).getDouble();
                variableDouble.value = Math.atan2(d, d2);
            }
        };
        return info;
    }

    public static Info sqrt(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        if (!(variable instanceof VariableScalar)) {
            throw new RuntimeException("Only scalars are supported");
        }
        info.op = new Operation("sqrt-s"){

            @Override
            public void process() {
                double d = ((VariableScalar)variable).getDouble();
                variableDouble.value = Math.sqrt(d);
            }
        };
        return info;
    }

    public static Info sin(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        if (!(variable instanceof VariableScalar)) {
            throw new RuntimeException("Only scalars are supported");
        }
        info.op = new Operation("sin-s"){

            @Override
            public void process() {
                variableDouble.value = Math.sin(((VariableScalar)variable).getDouble());
            }
        };
        return info;
    }

    public static Info cos(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        if (!(variable instanceof VariableScalar)) {
            throw new RuntimeException("Only scalars are supported");
        }
        info.op = new Operation("cos-s"){

            @Override
            public void process() {
                variableDouble.value = Math.cos(((VariableScalar)variable).getDouble());
            }
        };
        return info;
    }

    public static Info atan(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        if (!(variable instanceof VariableScalar)) {
            throw new RuntimeException("Only scalars are supported");
        }
        info.op = new Operation("atan-s"){

            @Override
            public void process() {
                variableDouble.value = Math.atan(((VariableScalar)variable).getDouble());
            }
        };
        return info;
    }

    public static Info exp(final Variable variable, ManagerTempVariables managerTempVariables) {
        final Info info = new Info();
        if (variable instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("exp-s"){

                @Override
                public void process() {
                    variableDouble.value = Math.exp(((VariableScalar)variable).getDouble());
                }
            };
        } else if (variable instanceof VariableMatrix) {
            VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("exp-m"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    DenseMatrix64F denseMatrix64F2 = ((VariableMatrix)info.output).matrix;
                    denseMatrix64F2.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.elementExp(denseMatrix64F, denseMatrix64F2);
                }
            };
        } else {
            throw new RuntimeException("Only scalars are supported");
        }
        return info;
    }

    public static Info log(final Variable variable, ManagerTempVariables managerTempVariables) {
        final Info info = new Info();
        if (variable instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("log-s"){

                @Override
                public void process() {
                    variableDouble.value = Math.log(((VariableScalar)variable).getDouble());
                }
            };
        } else if (variable instanceof VariableMatrix) {
            VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("log-m"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    DenseMatrix64F denseMatrix64F2 = ((VariableMatrix)info.output).matrix;
                    denseMatrix64F2.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.elementLog(denseMatrix64F, denseMatrix64F2);
                }
            };
        } else {
            throw new RuntimeException("Only scalars are supported");
        }
        return info;
    }

    public static Info add(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix && variable2 instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("add-mm"){

                @Override
                public void process() {
                    VariableMatrix variableMatrix3 = (VariableMatrix)variable;
                    VariableMatrix variableMatrix2 = (VariableMatrix)variable2;
                    this.resize(variableMatrix, variableMatrix3.matrix.numRows, variableMatrix3.matrix.numCols);
                    CommonOps.add((D1Matrix64F)variableMatrix3.matrix, variableMatrix2.matrix, (D1Matrix64F)variableMatrix.matrix);
                }
            };
        } else if (variable instanceof VariableInteger && variable2 instanceof VariableInteger) {
            final VariableInteger variableInteger = managerTempVariables.createInteger(0);
            info.output = variableInteger;
            info.op = new Operation("add-ii"){

                @Override
                public void process() {
                    VariableInteger variableInteger3 = (VariableInteger)variable;
                    VariableInteger variableInteger2 = (VariableInteger)variable2;
                    variableInteger.value = variableInteger3.value + variableInteger2.value;
                }
            };
        } else if (variable instanceof VariableScalar && variable2 instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("add-ss"){

                @Override
                public void process() {
                    VariableScalar variableScalar = (VariableScalar)variable;
                    VariableScalar variableScalar2 = (VariableScalar)variable2;
                    variableDouble.value = variableScalar.getDouble() + variableScalar2.getDouble();
                }
            };
        } else {
            VariableScalar variableScalar;
            VariableMatrix variableMatrix;
            final VariableMatrix variableMatrix2 = managerTempVariables.createMatrix();
            info.output = variableMatrix2;
            if (variable instanceof VariableMatrix) {
                variableMatrix = (VariableMatrix)variable;
                variableScalar = (VariableScalar)variable2;
            } else {
                variableMatrix = (VariableMatrix)variable2;
                variableScalar = (VariableScalar)variable;
            }
            info.op = new Operation("add-ms"){

                @Override
                public void process() {
                    variableMatrix2.matrix.reshape(variableMatrix.matrix.numRows, variableMatrix.matrix.numCols);
                    CommonOps.add((D1Matrix64F)variableMatrix.matrix, variableScalar.getDouble(), (D1Matrix64F)variableMatrix2.matrix);
                }
            };
        }
        return info;
    }

    public static Info subtract(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix && variable2 instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("subtract-mm"){

                @Override
                public void process() {
                    VariableMatrix variableMatrix3 = (VariableMatrix)variable;
                    VariableMatrix variableMatrix2 = (VariableMatrix)variable2;
                    this.resize(variableMatrix, variableMatrix3.matrix.numRows, variableMatrix3.matrix.numCols);
                    CommonOps.subtract((D1Matrix64F)variableMatrix3.matrix, (D1Matrix64F)variableMatrix2.matrix, (D1Matrix64F)variableMatrix.matrix);
                }
            };
        } else if (variable instanceof VariableInteger && variable2 instanceof VariableInteger) {
            final VariableInteger variableInteger = managerTempVariables.createInteger(0);
            info.output = variableInteger;
            info.op = new Operation("subtract-ii"){

                @Override
                public void process() {
                    VariableInteger variableInteger3 = (VariableInteger)variable;
                    VariableInteger variableInteger2 = (VariableInteger)variable2;
                    variableInteger.value = variableInteger3.value - variableInteger2.value;
                }
            };
        } else if (variable instanceof VariableScalar && variable2 instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("subtract-ss"){

                @Override
                public void process() {
                    VariableScalar variableScalar = (VariableScalar)variable;
                    VariableScalar variableScalar2 = (VariableScalar)variable2;
                    variableDouble.value = variableScalar.getDouble() - variableScalar2.getDouble();
                }
            };
        } else {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = variable instanceof VariableMatrix ? new Operation("subtract-ms"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    double d = ((VariableScalar)variable2).getDouble();
                    variableMatrix.matrix.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.subtract((D1Matrix64F)denseMatrix64F, d, (D1Matrix64F)variableMatrix.matrix);
                }
            } : new Operation("subtract-sm"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable2).matrix;
                    double d = ((VariableScalar)variable).getDouble();
                    variableMatrix.matrix.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.subtract(d, (D1Matrix64F)denseMatrix64F, (D1Matrix64F)variableMatrix.matrix);
                }
            };
        }
        return info;
    }

    public static Info elementMult(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (!(variable instanceof VariableMatrix) || !(variable2 instanceof VariableMatrix)) {
            throw new RuntimeException("Both inputs must be matrices for element wise multiplication");
        }
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        info.op = new Operation("elementMult-mm"){

            @Override
            public void process() {
                VariableMatrix variableMatrix3 = (VariableMatrix)variable;
                VariableMatrix variableMatrix2 = (VariableMatrix)variable2;
                this.resize(variableMatrix, variableMatrix3.matrix.numRows, variableMatrix3.matrix.numCols);
                CommonOps.elementMult(variableMatrix3.matrix, variableMatrix2.matrix, variableMatrix.matrix);
            }
        };
        return info;
    }

    public static Info elementDivision(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (!(variable instanceof VariableMatrix) || !(variable2 instanceof VariableMatrix)) {
            throw new RuntimeException("Both inputs must be matrices for element wise multiplication");
        }
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        info.op = new Operation("elementDivision-mm"){

            @Override
            public void process() {
                VariableMatrix variableMatrix3 = (VariableMatrix)variable;
                VariableMatrix variableMatrix2 = (VariableMatrix)variable2;
                this.resize(variableMatrix, variableMatrix3.matrix.numRows, variableMatrix3.matrix.numCols);
                CommonOps.elementDiv(variableMatrix3.matrix, variableMatrix2.matrix, variableMatrix.matrix);
            }
        };
        return info;
    }

    public static Info elementPow(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableScalar && variable2 instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("elementPow-ss"){

                @Override
                public void process() {
                    double d = ((VariableScalar)variable).getDouble();
                    double d2 = ((VariableScalar)variable2).getDouble();
                    variableDouble.value = Math.pow(d, d2);
                }
            };
        } else if (variable instanceof VariableMatrix && variable2 instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("elementPow-mm"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    DenseMatrix64F denseMatrix64F2 = ((VariableMatrix)variable2).matrix;
                    this.resize(variableMatrix, denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.elementPower((D1Matrix64F)denseMatrix64F, (D1Matrix64F)denseMatrix64F2, (D1Matrix64F)variableMatrix.matrix);
                }
            };
        } else if (variable instanceof VariableMatrix && variable2 instanceof VariableScalar) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("elementPow-ms"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    double d = ((VariableScalar)variable2).getDouble();
                    this.resize(variableMatrix, denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.elementPower((D1Matrix64F)denseMatrix64F, d, (D1Matrix64F)variableMatrix.matrix);
                }
            };
        } else if (variable instanceof VariableScalar && variable2 instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("elementPow-sm"){

                @Override
                public void process() {
                    double d = ((VariableScalar)variable).getDouble();
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable2).matrix;
                    this.resize(variableMatrix, denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.elementPower(d, (D1Matrix64F)denseMatrix64F, (D1Matrix64F)variableMatrix.matrix);
                }
            };
        } else {
            throw new RuntimeException("Unsupport element-wise power input types");
        }
        return info;
    }

    public static Operation copy(final Variable variable, final Variable variable2) {
        if (variable instanceof VariableMatrix) {
            if (variable2 instanceof VariableMatrix) {
                return new Operation("copy-mm"){

                    @Override
                    public void process() {
                        DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable2).matrix;
                        DenseMatrix64F denseMatrix64F2 = ((VariableMatrix)variable).matrix;
                        denseMatrix64F.reshape(denseMatrix64F2.numRows, denseMatrix64F2.numCols);
                        denseMatrix64F.set(((VariableMatrix)variable).matrix);
                    }
                };
            }
            if (variable2 instanceof VariableDouble) {
                return new Operation("copy-sm1"){

                    @Override
                    public void process() {
                        DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                        if (denseMatrix64F.numRows != 1 || denseMatrix64F.numCols != 1) {
                            throw new RuntimeException("Attempting to assign a non 1x1 matrix to a double");
                        }
                        ((VariableDouble)variable2).value = denseMatrix64F.unsafe_get(0, 0);
                    }
                };
            }
        }
        if (variable instanceof VariableInteger && variable2 instanceof VariableInteger) {
            return new Operation("copy-ii"){

                @Override
                public void process() {
                    ((VariableInteger)variable2).value = ((VariableInteger)variable).value;
                }
            };
        }
        if (variable instanceof VariableScalar && variable2 instanceof VariableDouble) {
            return new Operation("copy-ss"){

                @Override
                public void process() {
                    ((VariableDouble)variable2).value = ((VariableScalar)variable).getDouble();
                }
            };
        }
        throw new RuntimeException("Copy type miss-match src = " + variable.getClass().getSimpleName() + " dst = " + variable2.getClass().getSimpleName());
    }

    public static Operation copy(final Variable variable, final Variable variable2, final List<Variable> list) {
        if (variable instanceof VariableMatrix && variable2 instanceof VariableMatrix) {
            return new Operation("copyR-mm"){
                Extents extents;
                {
                    super(string);
                    this.extents = new Extents();
                }

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    DenseMatrix64F denseMatrix64F2 = ((VariableMatrix)variable2).matrix;
                    41.findExtents(denseMatrix64F2, list, 0, this.extents);
                    if (this.extents.col1 - this.extents.col0 != denseMatrix64F.numCols) {
                        throw new RuntimeException("Columns don't match");
                    }
                    if (this.extents.row1 - this.extents.row0 != denseMatrix64F.numRows) {
                        throw new RuntimeException("Rows don't match");
                    }
                    CommonOps.insert(denseMatrix64F, denseMatrix64F2, this.extents.row0, this.extents.col0);
                }
            };
        }
        if (variable instanceof VariableScalar && variable2 instanceof VariableMatrix) {
            return new Operation("copyR-sm"){
                Extents extents;
                {
                    super(string);
                    this.extents = new Extents();
                }

                @Override
                public void process() {
                    double d = ((VariableScalar)variable).getDouble();
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable2).matrix;
                    42.findExtents(denseMatrix64F, list, 0, this.extents);
                    if (!denseMatrix64F.isInBounds(this.extents.row0, this.extents.col0)) {
                        throw new RuntimeException("Submatrix out of bounds. Lower extent");
                    }
                    if (!denseMatrix64F.isInBounds(this.extents.row1 - 1, this.extents.col1 - 1)) {
                        throw new RuntimeException("Submatrix out of bounds. Upper extent");
                    }
                    for (int i = this.extents.row0; i < this.extents.row1; ++i) {
                        int n = i * denseMatrix64F.numCols + this.extents.col0;
                        for (int j = this.extents.col0; j < this.extents.col1; ++j) {
                            denseMatrix64F.data[n++] = d;
                        }
                    }
                }
            };
        }
        throw new RuntimeException("Both variables must be of type VariableMatrix");
    }

    public static Info transpose(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (!(variable instanceof VariableMatrix)) {
            throw new RuntimeException("Transpose only makes sense for a matrix");
        }
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        info.op = new Operation("transpose-m"){

            @Override
            public void process() {
                VariableMatrix variableMatrix2 = (VariableMatrix)variable;
                variableMatrix.matrix.reshape(variableMatrix2.matrix.numCols, variableMatrix2.matrix.numRows);
                CommonOps.transpose(variableMatrix2.matrix, variableMatrix.matrix);
            }
        };
        return info;
    }

    public static Info inv(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("inv-m"){

                @Override
                public void process() {
                    VariableMatrix variableMatrix2 = (VariableMatrix)variable;
                    variableMatrix.matrix.reshape(variableMatrix2.matrix.numRows, variableMatrix2.matrix.numCols);
                    if (!CommonOps.invert(variableMatrix2.matrix, variableMatrix.matrix)) {
                        throw new RuntimeException("Inverse failed!");
                    }
                }
            };
        } else {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("inv-s"){

                @Override
                public void process() {
                    VariableScalar variableScalar = (VariableScalar)variable;
                    variableDouble.value = 1.0 / variableScalar.getDouble();
                }
            };
        }
        return info;
    }

    public static Info pinv(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("pinv-m"){

                @Override
                public void process() {
                    VariableMatrix variableMatrix2 = (VariableMatrix)variable;
                    variableMatrix.matrix.reshape(variableMatrix2.matrix.numCols, variableMatrix2.matrix.numRows);
                    CommonOps.pinv(variableMatrix2.matrix, variableMatrix.matrix);
                }
            };
        } else {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("pinv-s"){

                @Override
                public void process() {
                    VariableScalar variableScalar = (VariableScalar)variable;
                    variableDouble.value = 1.0 / variableScalar.getDouble();
                }
            };
        }
        return info;
    }

    public static Info rref(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("rref-m"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    variableMatrix.matrix.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.rref(denseMatrix64F, -1, variableMatrix.matrix);
                }
            };
        } else {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("rref-s"){

                @Override
                public void process() {
                    double d = ((VariableScalar)variable).getDouble();
                    variableDouble.value = d == 0.0 ? 0.0 : 1.0;
                }
            };
        }
        return info;
    }

    public static Info det(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        info.op = variable instanceof VariableMatrix ? new Operation("det-m"){

            @Override
            public void process() {
                VariableMatrix variableMatrix = (VariableMatrix)variable;
                variableDouble.value = CommonOps.det(variableMatrix.matrix);
            }
        } : new Operation("det-s"){

            @Override
            public void process() {
                VariableScalar variableScalar = (VariableScalar)variable;
                variableDouble.value = variableScalar.getDouble();
            }
        };
        return info;
    }

    public static Info trace(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        info.op = variable instanceof VariableMatrix ? new Operation("trace-m"){

            @Override
            public void process() {
                VariableMatrix variableMatrix = (VariableMatrix)variable;
                variableDouble.value = CommonOps.trace(variableMatrix.matrix);
            }
        } : new Operation("trace-s"){

            @Override
            public void process() {
                VariableScalar variableScalar = (VariableScalar)variable;
                variableDouble.value = variableScalar.getDouble();
            }
        };
        return info;
    }

    public static Info normF(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        info.op = variable instanceof VariableMatrix ? new Operation("normF-m"){

            @Override
            public void process() {
                variableDouble.value = NormOps.normF(((VariableMatrix)variable).matrix);
            }
        } : new Operation("normF-s"){

            @Override
            public void process() {
                variableDouble.value = Math.abs(((VariableScalar)variable).getDouble());
            }
        };
        return info;
    }

    public static Info max(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("max-m"){

                @Override
                public void process() {
                    variableDouble.value = CommonOps.elementMax(((VariableMatrix)variable).matrix);
                }
            };
        } else if (variable instanceof VariableInteger) {
            final VariableInteger variableInteger = managerTempVariables.createInteger();
            info.output = variableInteger;
            info.op = new Operation("max-i"){

                @Override
                public void process() {
                    variableInteger.value = ((VariableInteger)variable).value;
                }
            };
        } else if (variable instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("max-s"){

                @Override
                public void process() {
                    variableDouble.value = ((VariableDouble)variable).getDouble();
                }
            };
        }
        return info;
    }

    public static Info min(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("min-m"){

                @Override
                public void process() {
                    variableDouble.value = CommonOps.elementMin(((VariableMatrix)variable).matrix);
                }
            };
        } else if (variable instanceof VariableInteger) {
            final VariableInteger variableInteger = managerTempVariables.createInteger();
            info.output = variableInteger;
            info.op = new Operation("min-i"){

                @Override
                public void process() {
                    variableInteger.value = ((VariableInteger)variable).value;
                }
            };
        } else if (variable instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("min-s"){

                @Override
                public void process() {
                    variableDouble.value = ((VariableDouble)variable).getDouble();
                }
            };
        }
        return info;
    }

    public static Info abs(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (variable instanceof VariableMatrix) {
            final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
            info.output = variableMatrix;
            info.op = new Operation("abs-m"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    variableMatrix.matrix.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols);
                    int n = denseMatrix64F.getNumElements();
                    for (int i = 0; i < n; ++i) {
                        variableMatrix.matrix.data[i] = Math.abs(denseMatrix64F.data[i]);
                    }
                }
            };
        } else if (variable instanceof VariableInteger) {
            final VariableInteger variableInteger = managerTempVariables.createInteger();
            info.output = variableInteger;
            info.op = new Operation("abs-i"){

                @Override
                public void process() {
                    variableInteger.value = Math.abs(((VariableInteger)variable).value);
                }
            };
        } else if (variable instanceof VariableScalar) {
            final VariableDouble variableDouble = managerTempVariables.createDouble();
            info.output = variableDouble;
            info.op = new Operation("abs-s"){

                @Override
                public void process() {
                    variableDouble.value = Math.abs(((VariableDouble)variable).getDouble());
                }
            };
        }
        return info;
    }

    public static Info eye(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        if (variable instanceof VariableMatrix) {
            info.op = new Operation("eye-m"){

                @Override
                public void process() {
                    DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                    variableMatrix.matrix.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols);
                    CommonOps.setIdentity(variableMatrix.matrix);
                }
            };
        } else if (variable instanceof VariableInteger) {
            info.op = new Operation("eye-i"){

                @Override
                public void process() {
                    int n = ((VariableInteger)variable).value;
                    variableMatrix.matrix.reshape(n, n);
                    CommonOps.setIdentity(variableMatrix.matrix);
                }
            };
        } else {
            throw new RuntimeException("Unsupported variable type " + variable);
        }
        return info;
    }

    public static Info diag(final Variable variable, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        if (!(variable instanceof VariableMatrix)) {
            throw new RuntimeException("diag requires a matrix as input");
        }
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        info.op = new Operation("diag-m"){

            @Override
            public void process() {
                DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                if (MatrixFeatures.isVector(denseMatrix64F)) {
                    int n = denseMatrix64F.getNumElements();
                    variableMatrix.matrix.reshape(n, n);
                    CommonOps.diag(variableMatrix.matrix, n, denseMatrix64F.data);
                } else {
                    int n = Math.min(denseMatrix64F.numCols, denseMatrix64F.numRows);
                    variableMatrix.matrix.reshape(n, 1);
                    for (int i = 0; i < n; ++i) {
                        variableMatrix.matrix.data[i] = denseMatrix64F.unsafe_get(i, i);
                    }
                }
            }
        };
        return info;
    }

    public static Info zeros(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        if (!(variable instanceof VariableInteger) || !(variable2 instanceof VariableInteger)) {
            throw new RuntimeException("Expected two integers got " + variable + " " + variable2);
        }
        info.op = new Operation("zeros-ii"){

            @Override
            public void process() {
                int n = ((VariableInteger)variable).value;
                int n2 = ((VariableInteger)variable2).value;
                variableMatrix.matrix.reshape(n, n2);
                CommonOps.fill(variableMatrix.matrix, 0.0);
            }
        };
        return info;
    }

    public static Info ones(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        if (!(variable instanceof VariableInteger) || !(variable2 instanceof VariableInteger)) {
            throw new RuntimeException("Expected two integers got " + variable + " " + variable2);
        }
        info.op = new Operation("ones-ii"){

            @Override
            public void process() {
                int n = ((VariableInteger)variable).value;
                int n2 = ((VariableInteger)variable2).value;
                variableMatrix.matrix.reshape(n, n2);
                CommonOps.fill(variableMatrix.matrix, 1.0);
            }
        };
        return info;
    }

    public static Info kron(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        if (!(variable instanceof VariableMatrix) || !(variable2 instanceof VariableMatrix)) {
            throw new RuntimeException("Both inputs must be matrices ");
        }
        info.op = new Operation("kron-mm"){

            @Override
            public void process() {
                DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                DenseMatrix64F denseMatrix64F2 = ((VariableMatrix)variable2).matrix;
                variableMatrix.matrix.reshape(denseMatrix64F.numRows * denseMatrix64F2.numRows, denseMatrix64F.numCols * denseMatrix64F2.numCols);
                CommonOps.kron(denseMatrix64F, denseMatrix64F2, variableMatrix.matrix);
            }
        };
        return info;
    }

    public static Info dot(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        if (!(variable instanceof VariableMatrix) || !(variable2 instanceof VariableMatrix)) {
            throw new RuntimeException("Expected two matrices got " + variable + " " + variable2);
        }
        info.op = new Operation("dot-mm"){

            @Override
            public void process() {
                DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                DenseMatrix64F denseMatrix64F2 = ((VariableMatrix)variable2).matrix;
                if (!MatrixFeatures.isVector(denseMatrix64F) || !MatrixFeatures.isVector(denseMatrix64F2)) {
                    throw new RuntimeException("Both inputs to dot() must be vectors");
                }
                variableDouble.value = VectorVectorMult.innerProd(denseMatrix64F, denseMatrix64F2);
            }
        };
        return info;
    }

    public static Info solve(final Variable variable, final Variable variable2, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        if (!(variable instanceof VariableMatrix) || !(variable2 instanceof VariableMatrix)) {
            throw new RuntimeException("Expected two matrices got " + variable + " " + variable2);
        }
        info.op = new Operation("solve-mm"){
            LinearSolver<DenseMatrix64F> solver;

            @Override
            public void process() {
                DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
                DenseMatrix64F denseMatrix64F2 = ((VariableMatrix)variable2).matrix;
                if (this.solver == null) {
                    this.solver = LinearSolverFactory.leastSquares(denseMatrix64F.numRows, denseMatrix64F.numCols);
                }
                if (!this.solver.setA(denseMatrix64F)) {
                    throw new RuntimeException("Solver failed!");
                }
                variableMatrix.matrix.reshape(denseMatrix64F.numCols, denseMatrix64F2.numCols);
                this.solver.solve(denseMatrix64F2, variableMatrix.matrix);
            }
        };
        return info;
    }

    public static Info extract(final List<Variable> list, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableMatrix variableMatrix = managerTempVariables.createMatrix();
        info.output = variableMatrix;
        if (!(list.get(0) instanceof VariableMatrix)) {
            throw new RuntimeException("First parameter must be a matrix.");
        }
        for (int i = 1; i < list.size(); ++i) {
            if (list.get(i) instanceof VariableInteger || list.get(i) instanceof VariableSpecial) continue;
            throw new RuntimeException("Last parameters must be integers or special for sub");
        }
        info.op = new Operation("extract"){
            Extents extents;
            {
                super(string);
                this.extents = new Extents();
            }

            @Override
            public void process() {
                DenseMatrix64F denseMatrix64F = ((VariableMatrix)list.get((int)0)).matrix;
                73.findExtents(denseMatrix64F, list, 1, this.extents);
                variableMatrix.matrix.reshape(this.extents.row1 - this.extents.row0, this.extents.col1 - this.extents.col0);
                CommonOps.extract(denseMatrix64F, this.extents.row0, this.extents.row1, this.extents.col0, this.extents.col1, variableMatrix.matrix, 0, 0);
            }
        };
        return info;
    }

    public static Info extractScalar(final List<Variable> list, ManagerTempVariables managerTempVariables) {
        Info info = new Info();
        final VariableDouble variableDouble = managerTempVariables.createDouble();
        info.output = variableDouble;
        if (!(list.get(0) instanceof VariableMatrix)) {
            throw new RuntimeException("First parameter must be a matrix.");
        }
        for (int i = 1; i < 3; ++i) {
            if (list.get(i) instanceof VariableInteger) continue;
            throw new RuntimeException("Parameters must be integers for extract scalar");
        }
        info.op = new Operation("extractScalar"){
            Extents extents;
            {
                super(string);
                this.extents = new Extents();
            }

            @Override
            public void process() {
                DenseMatrix64F denseMatrix64F = ((VariableMatrix)list.get((int)0)).matrix;
                int n = ((VariableInteger)list.get((int)1)).value;
                int n2 = ((VariableInteger)list.get((int)2)).value;
                variableDouble.value = denseMatrix64F.get(n, n2);
            }
        };
        return info;
    }

    protected static void findExtents(DenseMatrix64F denseMatrix64F, List<Variable> list, int n, Extents extents) {
        if (list.get(n).getType() == VariableType.SPECIAL) {
            extents.row0 = 0;
            extents.row1 = denseMatrix64F.numRows;
            ++n;
        } else {
            extents.row0 = ((VariableInteger)list.get((int)n++)).value;
            extents.row1 = list.get(n).getType() == VariableType.SPECIAL ? denseMatrix64F.numRows : ((VariableInteger)list.get((int)n)).value + 1;
            ++n;
        }
        if (list.get(n).getType() == VariableType.SPECIAL) {
            extents.col0 = 0;
            extents.col1 = denseMatrix64F.numCols;
            ++n;
        } else {
            extents.col0 = ((VariableInteger)list.get((int)n++)).value;
            extents.col1 = list.get(n).getType() == VariableType.SPECIAL ? denseMatrix64F.numCols : ((VariableInteger)list.get((int)n)).value + 1;
            ++n;
        }
        if (n != list.size()) {
            throw new RuntimeException("Unexpected number of inputs");
        }
    }

    public static Info matrixConstructor(final MatrixConstructor matrixConstructor) {
        Info info = new Info();
        info.output = matrixConstructor.getOutput();
        info.op = new Operation("matrixConstructor"){

            @Override
            public void process() {
                matrixConstructor.construct();
            }
        };
        return info;
    }

    public static class Info {
        public Operation op;
        public Variable output;
    }

    public static class Extents {
        int row0;
        int row1;
        int col0;
        int col1;
    }
}

