/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.equation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.equation.Function;
import org.ejml.equation.ManagerFunctions;
import org.ejml.equation.ManagerTempVariables;
import org.ejml.equation.MatrixConstructor;
import org.ejml.equation.Operation;
import org.ejml.equation.Sequence;
import org.ejml.equation.Symbol;
import org.ejml.equation.TokenList;
import org.ejml.equation.Variable;
import org.ejml.equation.VariableDouble;
import org.ejml.equation.VariableInteger;
import org.ejml.equation.VariableMatrix;
import org.ejml.equation.VariableScalar;
import org.ejml.equation.VariableSpecial;
import org.ejml.simple.SimpleMatrix;

public class Equation {
    HashMap<String, Variable> variables = new HashMap();
    char[] storage = new char[1024];
    ManagerFunctions functions = new ManagerFunctions();

    public Equation() {
        this.alias(Math.PI, "pi");
        this.alias(Math.E, "e");
    }

    public void alias(DenseMatrix64F denseMatrix64F, String string) {
        if (this.isReserved(string)) {
            throw new RuntimeException("Reserved word or contains a reserved character");
        }
        VariableMatrix variableMatrix = (VariableMatrix)this.variables.get(string);
        if (variableMatrix == null) {
            this.variables.put(string, new VariableMatrix(denseMatrix64F));
        } else {
            variableMatrix.matrix = denseMatrix64F;
        }
    }

    public void alias(SimpleMatrix simpleMatrix, String string) {
        this.alias(simpleMatrix.getMatrix(), string);
    }

    public void alias(double d, String string) {
        if (this.isReserved(string)) {
            throw new RuntimeException("Reserved word or contains a reserved character");
        }
        VariableDouble variableDouble = (VariableDouble)this.variables.get(string);
        if (variableDouble == null) {
            this.variables.put(string, new VariableDouble(d));
        } else {
            variableDouble.value = d;
        }
    }

    public void alias(int n, String string) {
        if (this.isReserved(string)) {
            throw new RuntimeException("Reserved word or contains a reserved character");
        }
        VariableInteger variableInteger = (VariableInteger)this.variables.get(string);
        if (variableInteger == null) {
            this.variables.put(string, new VariableInteger(n));
        } else {
            variableInteger.value = n;
        }
    }

    public void alias(Object ... objectArray) {
        if (objectArray.length % 2 == 1) {
            throw new RuntimeException("Even number of arguments expected");
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i].getClass() == Integer.class) {
                this.alias((Integer)objectArray[i], (String)objectArray[i + 1]);
                continue;
            }
            if (objectArray[i].getClass() == Double.class) {
                this.alias((Double)objectArray[i], (String)objectArray[i + 1]);
                continue;
            }
            if (objectArray[i].getClass() == DenseMatrix64F.class) {
                this.alias((DenseMatrix64F)objectArray[i], (String)objectArray[i + 1]);
                continue;
            }
            if (objectArray[i].getClass() == SimpleMatrix.class) {
                this.alias((SimpleMatrix)objectArray[i], (String)objectArray[i + 1]);
                continue;
            }
            throw new RuntimeException("Unknown value type " + objectArray[i]);
        }
    }

    public Sequence compile(String string) {
        return this.compile(string, false);
    }

    public Sequence compile(String string, boolean bl) {
        TokenList.Token token;
        ManagerTempVariables managerTempVariables = new ManagerTempVariables();
        this.functions.setManagerTemp(managerTempVariables);
        Sequence sequence = new Sequence();
        TokenList tokenList = this.extractTokens(string, managerTempVariables);
        if (tokenList.size() < 3) {
            throw new RuntimeException("Too few tokens");
        }
        if (bl) {
            System.out.println("Parsed tokens:\n------------");
            tokenList.print();
            System.out.println();
        }
        if ((token = tokenList.getFirst()).getType() != TokenList.Type.VARIABLE && token.getType() != TokenList.Type.WORD) {
            throw new RuntimeException("Expected variable name first.  Not " + token);
        }
        List<Variable> list = this.parseAssignRange(sequence, tokenList, token);
        TokenList.Token token2 = token.next;
        if (token2.getType() != TokenList.Type.SYMBOL || token2.getSymbol() != Symbol.ASSIGN) {
            throw new RuntimeException("Expected assign next");
        }
        TokenList tokenList2 = tokenList.extractSubList(token2.next, tokenList.last);
        this.checkForUnknownVariables(tokenList2);
        this.handleParentheses(tokenList2, sequence);
        if (tokenList2.size() != 1) {
            throw new RuntimeException("BUG");
        }
        if (tokenList2.getLast().getType() != TokenList.Type.VARIABLE) {
            throw new RuntimeException("BUG the last token must be a variable");
        }
        Variable variable = tokenList2.getFirst().getVariable();
        if (list == null) {
            Variable variable2 = this.createVariableInferred(token, variable);
            sequence.addOperation(Operation.copy(variable, variable2));
        } else {
            if (token.getType() == TokenList.Type.WORD) {
                throw new RuntimeException("Can't do lazy variable initialization with submatrices. " + token.getWord());
            }
            sequence.addOperation(Operation.copy(variable, token.getVariable(), list));
        }
        if (bl) {
            System.out.println("Operations:\n------------");
            for (int i = 0; i < sequence.operations.size(); ++i) {
                System.out.println(sequence.operations.get(i).name());
            }
        }
        return sequence;
    }

    private void checkForUnknownVariables(TokenList tokenList) {
        TokenList.Token token = tokenList.getFirst();
        while (token != null) {
            if (token.getType() == TokenList.Type.WORD) {
                throw new RuntimeException("Unknown variable on right side. " + token.getWord());
            }
            token = token.next;
        }
    }

    private Variable createVariableInferred(TokenList.Token token, Variable variable) {
        Variable variable2;
        if (token.getType() == TokenList.Type.WORD) {
            switch (variable.getType()) {
                case MATRIX: {
                    this.alias(new DenseMatrix64F(1, 1), token.getWord());
                    break;
                }
                case SCALAR: {
                    if (variable instanceof VariableInteger) {
                        this.alias(0, token.getWord());
                        break;
                    }
                    this.alias(1.0, token.getWord());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type");
                }
            }
            variable2 = this.variables.get(token.getWord());
        } else {
            variable2 = token.getVariable();
        }
        return variable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Variable> parseAssignRange(Sequence sequence, TokenList tokenList, TokenList.Token token) {
        TokenList.Token token2 = token.next;
        if (token2.getType() != TokenList.Type.SYMBOL) throw new RuntimeException("Expecting symbol after first variable");
        if (token2.symbol == Symbol.ASSIGN) {
            return null;
        }
        if (token2.symbol != Symbol.PAREN_LEFT) throw new RuntimeException("Expected assign or submatrix");
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        TokenList.Token token3 = token2.next;
        while (token3 != null && token3.symbol != Symbol.PAREN_RIGHT) {
            token3 = token3.next;
        }
        if (token3 == null) {
            throw new RuntimeException("Could not find closing )");
        }
        TokenList.Token token4 = token3.next;
        TokenList tokenList2 = tokenList.extractSubList(token2, token3);
        tokenList2.remove(tokenList2.first);
        tokenList2.remove(tokenList2.last);
        this.parseSubmatrixRange(tokenList2, sequence, arrayList);
        token2 = token4;
        if (token2.symbol == Symbol.ASSIGN) return arrayList;
        throw new RuntimeException("Expected assign after sub-matrix");
    }

    protected void handleParentheses(TokenList tokenList, Sequence sequence) {
        ArrayList<TokenList.Token> arrayList = new ArrayList<TokenList.Token>();
        TokenList.Token token = tokenList.first;
        while (token != null) {
            TokenList.Token token2 = token.next;
            if (token.getType() == TokenList.Type.SYMBOL) {
                if (token.getSymbol() == Symbol.PAREN_LEFT) {
                    arrayList.add(token);
                } else if (token.getSymbol() == Symbol.PAREN_RIGHT) {
                    Object object;
                    if (arrayList.isEmpty()) {
                        throw new RuntimeException(") found with no matching (");
                    }
                    TokenList.Token token3 = (TokenList.Token)arrayList.remove(arrayList.size() - 1);
                    TokenList.Token token4 = token3.previous;
                    TokenList tokenList2 = tokenList.extractSubList(token3, token);
                    tokenList2.remove(tokenList2.first);
                    tokenList2.remove(tokenList2.last);
                    if (token4 != null && token4.getType() == TokenList.Type.FUNCTION) {
                        object = this.parseParameterCommaBlock(tokenList2, sequence);
                        if (object.isEmpty()) {
                            throw new RuntimeException("Empty function input parameters");
                        }
                        this.createFunction(token4, (List<TokenList.Token>)object, tokenList, sequence);
                    } else if (token4 != null && token4.getType() == TokenList.Type.VARIABLE) {
                        object = this.parseSubmatrixToExtract(token4, tokenList2, sequence);
                        tokenList.insert(token4, (TokenList.Token)object);
                        tokenList.remove(token4);
                    } else {
                        object = this.parseBlockNoParentheses(tokenList2, sequence);
                        if (object != null) {
                            tokenList.insert(token4, (TokenList.Token)object);
                        }
                    }
                }
            }
            token = token2;
        }
        if (!arrayList.isEmpty()) {
            throw new RuntimeException("Dangling ( parentheses");
        }
        if (tokenList.size() > 1) {
            this.parseBlockNoParentheses(tokenList, sequence);
        }
    }

    protected List<TokenList.Token> parseParameterCommaBlock(TokenList tokenList, Sequence sequence) {
        ArrayList<TokenList.Token> arrayList = new ArrayList<TokenList.Token>();
        TokenList.Token token = tokenList.first;
        while (token != null) {
            if (token.getType() == TokenList.Type.SYMBOL && token.getSymbol() == Symbol.COMMA) {
                arrayList.add(token);
            }
            token = token.next;
        }
        ArrayList<TokenList.Token> arrayList2 = new ArrayList<TokenList.Token>();
        if (arrayList.isEmpty()) {
            arrayList2.add(this.parseBlockNoParentheses(tokenList, sequence));
        } else {
            Object object;
            TokenList.Token token2 = tokenList.first;
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (TokenList.Token)arrayList.get(i);
                if (token2 == object) {
                    throw new RuntimeException("No empty function inputs allowed!");
                }
                TokenList.Token token3 = ((TokenList.Token)object).next;
                TokenList tokenList2 = tokenList.extractSubList(token2, (TokenList.Token)object);
                tokenList2.remove((TokenList.Token)object);
                arrayList2.add(this.parseBlockNoParentheses(tokenList2, sequence));
                token2 = token3;
            }
            if (token2 == null) {
                throw new RuntimeException("No empty function inputs allowed!");
            }
            TokenList.Token token4 = tokenList.last;
            object = tokenList.extractSubList(token2, token4);
            arrayList2.add(this.parseBlockNoParentheses((TokenList)object, sequence));
        }
        return arrayList2;
    }

    protected TokenList.Token parseSubmatrixToExtract(TokenList.Token token, TokenList tokenList, Sequence sequence) {
        Operation.Info info;
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        arrayList.add(token.getVariable());
        this.parseSubmatrixRange(tokenList, sequence, arrayList);
        if (arrayList.get(1) == arrayList.get(2) && arrayList.get(3) == arrayList.get(4)) {
            arrayList.remove(4);
            arrayList.remove(2);
            info = this.functions.create("extractScalar", arrayList);
        } else {
            info = this.functions.create("extract", arrayList);
        }
        sequence.addOperation(info.op);
        return new TokenList.Token(info.output);
    }

    private void parseSubmatrixRange(TokenList tokenList, Sequence sequence, List<Variable> list) {
        TokenList.Token token = tokenList.first;
        while (token != null && token.getSymbol() != Symbol.COMMA) {
            token = token.next;
        }
        if (token == null) {
            throw new RuntimeException("Can't find comma inside submatrix");
        }
        TokenList tokenList2 = tokenList.extractSubList(tokenList.first, token.previous);
        TokenList tokenList3 = tokenList.extractSubList(token.next, tokenList.last);
        this.parseValueRange(tokenList2, sequence, list);
        this.parseValueRange(tokenList3, sequence, list);
    }

    protected void parseValueRange(TokenList tokenList, Sequence sequence, List<Variable> list) {
        TokenList tokenList2;
        TokenList.Token[] tokenArray = new TokenList.Token[2];
        TokenList.Token token = tokenList.first;
        while (token != null && token.getSymbol() != Symbol.COLON) {
            token = token.next;
        }
        if (token == null) {
            tokenArray[0] = tokenArray[1] = this.parseBlockNoParentheses(tokenList, sequence);
        } else if (token.previous == null && token.next == null) {
            tokenArray[0] = new TokenList.Token(VariableSpecial.Special.ALL);
        } else if (token.next == null) {
            tokenList2 = tokenList.extractSubList(tokenList.first, token.previous);
            tokenArray[0] = this.parseBlockNoParentheses(tokenList2, sequence);
            tokenArray[1] = new TokenList.Token(VariableSpecial.Special.END);
        } else {
            if (token.previous == null) {
                throw new RuntimeException(":<int> not allowed");
            }
            tokenList2 = tokenList.extractSubList(tokenList.first, token.previous);
            TokenList tokenList3 = tokenList.extractSubList(token.next, tokenList.last);
            tokenArray[0] = this.parseBlockNoParentheses(tokenList2, sequence);
            tokenArray[1] = this.parseBlockNoParentheses(tokenList3, sequence);
        }
        for (int i = 0; i < tokenArray.length; ++i) {
            if (tokenArray[i] == null) continue;
            if (tokenArray[i].getType() != TokenList.Type.VARIABLE) {
                throw new RuntimeException("Expected variable inside of range");
            }
            list.add(tokenArray[i].getVariable());
        }
    }

    protected TokenList.Token parseBlockNoParentheses(TokenList tokenList, Sequence sequence) {
        this.parseBracketCreateMatrix(tokenList, sequence);
        this.parseNegOp(tokenList, sequence);
        this.parseOperationsL(tokenList, sequence);
        this.parseOperationsLR(new Symbol[]{Symbol.POWER, Symbol.ELEMENT_POWER}, tokenList, sequence);
        this.parseOperationsLR(new Symbol[]{Symbol.TIMES, Symbol.RDIVIDE, Symbol.LDIVIDE, Symbol.ELEMENT_TIMES, Symbol.ELEMENT_DIVIDE}, tokenList, sequence);
        this.parseOperationsLR(new Symbol[]{Symbol.PLUS, Symbol.MINUS}, tokenList, sequence);
        if (tokenList.size() > 1) {
            throw new RuntimeException("BUG in parser.  There should only be a single token left");
        }
        return tokenList.first;
    }

    protected void parseBracketCreateMatrix(TokenList tokenList, Sequence sequence) {
        ArrayList<TokenList.Token> arrayList = new ArrayList<TokenList.Token>();
        TokenList.Token token = tokenList.getFirst();
        while (token != null) {
            TokenList.Token token2 = token.next;
            if (token.getSymbol() == Symbol.BRACKET_LEFT) {
                arrayList.add(token);
            } else if (token.getSymbol() == Symbol.BRACKET_RIGHT) {
                if (arrayList.isEmpty()) {
                    throw new RuntimeException("No matching left bracket for right");
                }
                TokenList.Token token3 = (TokenList.Token)arrayList.remove(arrayList.size() - 1);
                TokenList.Token token4 = token3.next;
                MatrixConstructor matrixConstructor = new MatrixConstructor(this.functions.getManagerTemp());
                TokenList.Token token5 = null;
                while (true) {
                    if (token4.getType() == TokenList.Type.VARIABLE) {
                        this.innerMatrixConstructorOp(tokenList, sequence, matrixConstructor, token5, token4.previous);
                        token5 = token4;
                    } else if (token4.getType() == TokenList.Type.SYMBOL) {
                        boolean bl = false;
                        boolean bl2 = true;
                        if (token4.getSymbol() == Symbol.SEMICOLON) {
                            bl2 = false;
                        } else if (token4.getSymbol() == Symbol.BRACKET_RIGHT) {
                            bl = true;
                            bl2 = false;
                        }
                        if (!bl2) {
                            this.innerMatrixConstructorOp(tokenList, sequence, matrixConstructor, token5, token4.previous);
                            matrixConstructor.endRow();
                            token5 = null;
                            if (bl) {
                                break;
                            }
                        }
                    } else {
                        throw new RuntimeException("Unexpected token " + token4);
                    }
                    token4 = token4.next;
                }
                Operation.Info info = Operation.matrixConstructor(matrixConstructor);
                sequence.addOperation(info.op);
                tokenList.insert(token, new TokenList.Token(info.output));
                tokenList.extractSubList(token3, token);
            }
            token = token2;
        }
        if (!arrayList.isEmpty()) {
            throw new RuntimeException("Dangling [");
        }
    }

    private void innerMatrixConstructorOp(TokenList tokenList, Sequence sequence, MatrixConstructor matrixConstructor, TokenList.Token token, TokenList.Token token2) {
        if (token == null) {
            return;
        }
        if (token != token2) {
            TokenList tokenList2 = tokenList.extractSubList(token, token2);
            TokenList.Token token3 = this.parseBlockNoParentheses(tokenList2, sequence);
            matrixConstructor.addToRow(token3.getVariable());
        } else {
            matrixConstructor.addToRow(token.getVariable());
        }
    }

    protected void parseNegOp(TokenList tokenList, Sequence sequence) {
        if (tokenList.size == 0) {
            return;
        }
        TokenList.Token token = tokenList.first;
        while (token != null) {
            TokenList.Token token2 = token.next;
            if (token.getSymbol() == Symbol.MINUS && (token.previous == null || token.previous.getType() == TokenList.Type.SYMBOL) && token.next != null && token.next.getType() != TokenList.Type.SYMBOL) {
                if (token.next.getType() != TokenList.Type.VARIABLE) {
                    throw new RuntimeException("Crap bug rethink this function");
                }
                Operation.Info info = Operation.neg(token.next.getVariable(), this.functions.getManagerTemp());
                sequence.addOperation(info.op);
                TokenList.Token token3 = new TokenList.Token(info.output);
                tokenList.insert(token.next, token3);
                tokenList.remove(token.next);
                tokenList.remove(token);
                token2 = token3;
            }
            token = token2;
        }
    }

    protected void parseOperationsL(TokenList tokenList, Sequence sequence) {
        if (tokenList.size == 0) {
            return;
        }
        TokenList.Token token = tokenList.first;
        if (token.getType() != TokenList.Type.VARIABLE) {
            throw new RuntimeException("The first token in an equation needs to be a variable and not " + token);
        }
        while (token != null) {
            if (token.getType() == TokenList.Type.FUNCTION) {
                throw new RuntimeException("Function encountered with no parentheses");
            }
            if (token.getType() == TokenList.Type.SYMBOL && token.getSymbol() == Symbol.TRANSPOSE) {
                if (token.previous.getType() == TokenList.Type.VARIABLE) {
                    token = this.insertTranspose(token.previous, tokenList, sequence);
                } else {
                    throw new RuntimeException("Expected variable before tranpose");
                }
            }
            token = token.next;
        }
    }

    protected void parseOperationsLR(Symbol[] symbolArray, TokenList tokenList, Sequence sequence) {
        if (tokenList.size == 0) {
            return;
        }
        TokenList.Token token = tokenList.first;
        if (token.getType() != TokenList.Type.VARIABLE) {
            throw new RuntimeException("The first token in an equation needs to be a variable and not " + token);
        }
        boolean bl = false;
        while (token != null) {
            if (token.getType() == TokenList.Type.FUNCTION) {
                throw new RuntimeException("Function encountered with no parentheses");
            }
            if (token.getType() == TokenList.Type.VARIABLE) {
                if (bl) {
                    if (token.previous.getType() == TokenList.Type.VARIABLE) {
                        throw new RuntimeException("Two variables next to each other");
                    }
                    if (Equation.isTargetOp(token.previous, symbolArray)) {
                        token = this.createOp(token.previous.previous, token.previous, token, tokenList, sequence);
                    }
                } else {
                    bl = true;
                }
            } else if (token.previous.getType() == TokenList.Type.SYMBOL) {
                throw new RuntimeException("Two symbols next to each other. " + token.previous + " and " + token);
            }
            token = token.next;
        }
    }

    protected TokenList.Token insertTranspose(TokenList.Token token, TokenList tokenList, Sequence sequence) {
        Operation.Info info = this.functions.create('\'', token.getVariable());
        sequence.addOperation(info.op);
        TokenList.Token token2 = new TokenList.Token(info.output);
        tokenList.remove(token.next);
        tokenList.replace(token, token2);
        return token2;
    }

    protected TokenList.Token createOp(TokenList.Token token, TokenList.Token token2, TokenList.Token token3, TokenList tokenList, Sequence sequence) {
        Operation.Info info = this.functions.create(token2.symbol, token.getVariable(), token3.getVariable());
        sequence.addOperation(info.op);
        TokenList.Token token4 = new TokenList.Token(info.output);
        tokenList.remove(token);
        tokenList.remove(token3);
        tokenList.replace(token2, token4);
        return token4;
    }

    protected TokenList.Token createFunction(TokenList.Token token, List<TokenList.Token> list, TokenList tokenList, Sequence sequence) {
        Object object;
        Operation.Info info;
        if (list.size() == 1) {
            info = this.functions.create(token.getFunction().getName(), list.get(0).getVariable());
        } else {
            object = new ArrayList<Variable>();
            for (int i = 0; i < list.size(); ++i) {
                object.add(list.get(i).getVariable());
            }
            info = this.functions.create(token.getFunction().getName(), (List<Variable>)object);
        }
        sequence.addOperation(info.op);
        object = new TokenList.Token(info.output);
        tokenList.replace(token, (TokenList.Token)object);
        return object;
    }

    public <T extends Variable> T lookupVariable(String string) {
        Variable variable = this.variables.get(string);
        return (T)variable;
    }

    public DenseMatrix64F lookupMatrix(String string) {
        return ((VariableMatrix)this.variables.get((Object)string)).matrix;
    }

    public int lookupInteger(String string) {
        return ((VariableInteger)this.variables.get((Object)string)).value;
    }

    public double lookupDouble(String string) {
        Variable variable = this.variables.get(string);
        if (variable instanceof VariableMatrix) {
            DenseMatrix64F denseMatrix64F = ((VariableMatrix)variable).matrix;
            if (denseMatrix64F.numCols == 1 && denseMatrix64F.numRows == 1) {
                return denseMatrix64F.get(0, 0);
            }
            throw new RuntimeException("Can only return 1x1 real matrices as doubles");
        }
        return ((VariableScalar)this.variables.get(string)).getDouble();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TokenList extractTokens(String string, ManagerTempVariables managerTempVariables) {
        TokenList tokenList = new TokenList();
        int n = 0;
        TokenType tokenType = TokenType.UNKNOWN;
        for (int i = 0; i < string.length(); ++i) {
            boolean bl = false;
            char c = string.charAt(i);
            if (tokenType == TokenType.WORD) {
                if (Equation.isLetter(c)) {
                    this.storage[n++] = c;
                } else {
                    String string2 = new String(this.storage, 0, n);
                    Object t = this.lookupVariable(string2);
                    if (t == null) {
                        if (this.functions.isFunctionName(string2)) {
                            tokenList.add(new Function(string2));
                        } else {
                            tokenList.add(string2);
                        }
                    } else {
                        tokenList.add((Variable)t);
                    }
                    tokenType = TokenType.UNKNOWN;
                    bl = true;
                }
            } else if (tokenType == TokenType.INTEGER) {
                if (c == '.') {
                    tokenType = TokenType.FLOAT;
                    this.storage[n++] = c;
                } else if (c == 'e' || c == 'E') {
                    tokenType = TokenType.FLOAT_EXP;
                    this.storage[n++] = c;
                } else if (Character.isDigit(c)) {
                    this.storage[n++] = c;
                } else {
                    if (!Equation.isSymbol(c) && !Character.isWhitespace(c)) throw new RuntimeException("Unexpected character at the end of an integer " + c);
                    int n2 = Integer.parseInt(new String(this.storage, 0, n));
                    tokenList.add(managerTempVariables.createInteger(n2));
                    tokenType = TokenType.UNKNOWN;
                    bl = true;
                }
            } else if (tokenType == TokenType.FLOAT) {
                if (c == '.') {
                    throw new RuntimeException("Unexpected '.' in a float");
                }
                if (c == 'e' || c == 'E') {
                    this.storage[n++] = c;
                    tokenType = TokenType.FLOAT_EXP;
                } else if (Character.isDigit(c)) {
                    this.storage[n++] = c;
                } else {
                    if (!Equation.isSymbol(c) && !Character.isWhitespace(c)) throw new RuntimeException("Unexpected character at the end of an float " + c);
                    double d = Double.parseDouble(new String(this.storage, 0, n));
                    tokenList.add(managerTempVariables.createDouble(d));
                    tokenType = TokenType.UNKNOWN;
                    bl = true;
                }
            } else if (tokenType == TokenType.FLOAT_EXP) {
                boolean bl2 = false;
                if (c == '-') {
                    char c2 = this.storage[n - 1];
                    if (c2 == 'e' || c2 == 'E') {
                        this.storage[n++] = c;
                    } else {
                        bl2 = true;
                    }
                } else if (Character.isDigit(c)) {
                    this.storage[n++] = c;
                } else {
                    if (!Equation.isSymbol(c) && !Character.isWhitespace(c)) throw new RuntimeException("Unexpected character at the end of an float " + c);
                    bl2 = true;
                }
                if (bl2) {
                    double d = Double.parseDouble(new String(this.storage, 0, n));
                    tokenList.add(managerTempVariables.createDouble(d));
                    tokenType = TokenType.UNKNOWN;
                    bl = true;
                }
            } else if (Equation.isSymbol(c)) {
                boolean bl3 = false;
                if (c == '-' && i + 1 < string.length() && Character.isDigit(string.charAt(i + 1)) && (tokenList.last == null || Equation.isOperatorLR(tokenList.last.getSymbol()))) {
                    tokenType = TokenType.INTEGER;
                    this.storage[0] = c;
                    n = 1;
                    bl3 = true;
                }
                if (!bl3) {
                    TokenList.Token token = tokenList.add(Symbol.lookup(c));
                    if (token.previous != null && token.previous.getType() == TokenList.Type.SYMBOL && token.previous.getSymbol() == Symbol.PERIOD) {
                        tokenList.remove(token.previous);
                        tokenList.remove(token);
                        tokenList.add(Symbol.lookupElementWise(c));
                    }
                }
            } else {
                if (Character.isWhitespace(c)) continue;
                tokenType = Character.isDigit(c) ? TokenType.INTEGER : TokenType.WORD;
                this.storage[0] = c;
                n = 1;
            }
            if (!bl) continue;
            --i;
        }
        if (tokenType == TokenType.WORD) {
            String string3 = new String(this.storage, 0, n);
            Object t = this.lookupVariable(string3);
            if (t == null) {
                throw new RuntimeException("Unknown variable " + string3);
            }
            tokenList.add((Variable)t);
            return tokenList;
        } else if (tokenType == TokenType.INTEGER) {
            tokenList.add(managerTempVariables.createInteger(Integer.parseInt(new String(this.storage, 0, n))));
            return tokenList;
        } else {
            if (tokenType != TokenType.FLOAT && tokenType != TokenType.FLOAT_EXP) return tokenList;
            tokenList.add(managerTempVariables.createDouble(Double.parseDouble(new String(this.storage, 0, n))));
        }
        return tokenList;
    }

    protected static boolean isTargetOp(TokenList.Token token, Symbol[] symbolArray) {
        Symbol symbol = token.symbol;
        for (int i = 0; i < symbolArray.length; ++i) {
            if (symbol != symbolArray[i]) continue;
            return true;
        }
        return false;
    }

    protected static boolean isSymbol(char c) {
        return c == '*' || c == '/' || c == '+' || c == '-' || c == '(' || c == ')' || c == '[' || c == ']' || c == '=' || c == '\'' || c == '.' || c == ',' || c == ':' || c == ';' || c == '\\' || c == '^';
    }

    protected static boolean isOperatorLR(Symbol symbol) {
        if (symbol == null) {
            return false;
        }
        switch (symbol) {
            case ELEMENT_DIVIDE: 
            case ELEMENT_TIMES: 
            case ELEMENT_POWER: 
            case RDIVIDE: 
            case LDIVIDE: 
            case TIMES: 
            case POWER: 
            case PLUS: 
            case MINUS: 
            case ASSIGN: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isLetter(char c) {
        return !Equation.isSymbol(c) && !Character.isWhitespace(c);
    }

    protected boolean isReserved(String string) {
        if (this.functions.isFunctionName(string)) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Equation.isLetter(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public void process(String string) {
        this.compile(string).perform();
    }

    public void process(String string, boolean bl) {
        this.compile(string, bl).perform();
    }

    public ManagerFunctions getFunctions() {
        return this.functions;
    }

    protected static enum TokenType {
        WORD,
        INTEGER,
        FLOAT,
        FLOAT_EXP,
        UNKNOWN;

    }
}

