/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.ejml.data.D1Matrix32F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix32F;
import org.ejml.ops.MatrixIO;

public class DenseMatrix32F
extends D1Matrix32F {
    public DenseMatrix32F(int n, int n2, boolean bl, float ... fArray) {
        int n3 = n * n2;
        this.data = new float[n3];
        this.numRows = n;
        this.numCols = n2;
        this.set(n, n2, bl, fArray);
    }

    public DenseMatrix32F(float[][] fArray) {
        this.numRows = fArray.length;
        this.numCols = fArray[0].length;
        this.data = new float[this.numRows * this.numCols];
        int n = 0;
        for (int i = 0; i < this.numRows; ++i) {
            float[] fArray2 = fArray[i];
            if (fArray2.length != this.numCols) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            System.arraycopy(fArray2, 0, this.data, n, this.numCols);
            n += this.numCols;
        }
    }

    public DenseMatrix32F(int n, int n2) {
        this.data = new float[n * n2];
        this.numRows = n;
        this.numCols = n2;
    }

    public DenseMatrix32F(DenseMatrix32F denseMatrix32F) {
        this(denseMatrix32F.numRows, denseMatrix32F.numCols);
        System.arraycopy(denseMatrix32F.data, 0, this.data, 0, denseMatrix32F.getNumElements());
    }

    public DenseMatrix32F(int n) {
        this.data = new float[n];
    }

    public DenseMatrix32F() {
    }

    public DenseMatrix32F(RealMatrix32F realMatrix32F) {
        this(realMatrix32F.getNumRows(), realMatrix32F.getNumCols());
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.set(i, j, realMatrix32F.get(i, j));
            }
        }
    }

    public static DenseMatrix32F wrap(int n, int n2, float[] fArray) {
        DenseMatrix32F denseMatrix32F = new DenseMatrix32F();
        denseMatrix32F.data = fArray;
        denseMatrix32F.numRows = n;
        denseMatrix32F.numCols = n2;
        return denseMatrix32F;
    }

    @Override
    public void reshape(int n, int n2, boolean bl) {
        if (this.data.length < n * n2) {
            float[] fArray = new float[n * n2];
            if (bl) {
                System.arraycopy(this.data, 0, fArray, 0, this.getNumElements());
            }
            this.data = fArray;
        }
        this.numRows = n;
        this.numCols = n2;
    }

    @Override
    public void set(int n, int n2, float f) {
        if (n2 < 0 || n2 >= this.numCols || n < 0 || n >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + n + " , " + n2 + ")");
        }
        this.data[n * this.numCols + n2] = f;
    }

    @Override
    public void unsafe_set(int n, int n2, float f) {
        this.data[n * this.numCols + n2] = f;
    }

    public void add(int n, int n2, float f) {
        if (n2 < 0 || n2 >= this.numCols || n < 0 || n >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds");
        }
        int n3 = n * this.numCols + n2;
        this.data[n3] = this.data[n3] + f;
    }

    @Override
    public float get(int n, int n2) {
        if (n2 < 0 || n2 >= this.numCols || n < 0 || n >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds: " + n + " " + n2);
        }
        return this.data[n * this.numCols + n2];
    }

    @Override
    public float unsafe_get(int n, int n2) {
        return this.data[n * this.numCols + n2];
    }

    @Override
    public int getIndex(int n, int n2) {
        return n * this.numCols + n2;
    }

    public boolean isInBounds(int n, int n2) {
        return n2 >= 0 && n2 < this.numCols && n >= 0 && n < this.numRows;
    }

    @Override
    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    public void set(int n, int n2, boolean bl, float ... fArray) {
        this.reshape(n, n2);
        int n3 = n * n2;
        if (n3 > this.data.length) {
            throw new IllegalArgumentException("The length of this matrix's data array is too small.");
        }
        if (bl) {
            System.arraycopy(fArray, 0, this.data, 0, n3);
        } else {
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.data[n4++] = fArray[j * n + i];
                }
            }
        }
    }

    public void zero() {
        Arrays.fill(this.data, 0, this.getNumElements(), 0.0f);
    }

    public DenseMatrix32F copy() {
        return new DenseMatrix32F(this);
    }

    @Override
    public void set(Matrix matrix) {
        RealMatrix32F realMatrix32F = (RealMatrix32F)matrix;
        this.reshape(matrix.getNumRows(), matrix.getNumCols());
        if (matrix instanceof DenseMatrix32F) {
            System.arraycopy(((DenseMatrix32F)realMatrix32F).data, 0, this.data, 0, this.numRows * this.numCols);
        } else {
            int n = 0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    this.data[n++] = realMatrix32F.get(i, j);
                }
            }
        }
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }

    public void print(String string) {
        MatrixIO.print(System.out, this, string);
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MatrixIO.print(new PrintStream(byteArrayOutputStream), this);
        return byteArrayOutputStream.toString();
    }
}

