/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.CD1Matrix64F;
import org.ejml.data.Complex64F;
import org.ejml.data.ComplexMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.ops.MatrixIO;

public class CDenseMatrix64F
extends CD1Matrix64F {
    public CDenseMatrix64F(double[][] dArray) {
        this.numRows = dArray.length;
        this.numCols = dArray[0].length / 2;
        this.data = new double[this.numRows * this.numCols * 2];
        for (int i = 0; i < this.numRows; ++i) {
            double[] dArray2 = dArray[i];
            if (dArray2.length != this.numCols * 2) {
                throw new IllegalArgumentException("Unexpected row size in input data at row " + i);
            }
            System.arraycopy(dArray2, 0, this.data, i * this.numCols * 2, dArray2.length);
        }
    }

    public CDenseMatrix64F(int n, int n2, boolean bl, double ... dArray) {
        if (dArray.length != n * n2 * 2) {
            throw new RuntimeException("Unexpected length for data");
        }
        this.data = new double[n * n2 * 2];
        this.numRows = n;
        this.numCols = n2;
        this.set(n, n2, bl, dArray);
    }

    public CDenseMatrix64F(CDenseMatrix64F cDenseMatrix64F) {
        this(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        this.set(cDenseMatrix64F);
    }

    public CDenseMatrix64F(int n, int n2) {
        this.numRows = n;
        this.numCols = n2;
        this.data = new double[n * n2 * 2];
    }

    @Override
    public int getIndex(int n, int n2) {
        return n * this.numCols * 2 + n2 * 2;
    }

    @Override
    public void reshape(int n, int n2) {
        int n3 = n * n2 * 2;
        if (n3 > this.data.length) {
            this.data = new double[n3];
        }
        this.numRows = n;
        this.numCols = n2;
    }

    @Override
    public void get(int n, int n2, Complex64F complex64F) {
        int n3 = n * this.numCols * 2 + n2 * 2;
        complex64F.real = this.data[n3];
        complex64F.imaginary = this.data[n3 + 1];
    }

    @Override
    public void set(int n, int n2, double d, double d2) {
        int n3 = n * this.numCols * 2 + n2 * 2;
        this.data[n3] = d;
        this.data[n3 + 1] = d2;
    }

    @Override
    public double getReal(int n, int n2) {
        return this.data[n * this.numCols * 2 + n2 * 2];
    }

    @Override
    public void setReal(int n, int n2, double d) {
        this.data[n * this.numCols * 2 + n2 * 2] = d;
    }

    @Override
    public double getImaginary(int n, int n2) {
        return this.data[n * this.numCols * 2 + n2 * 2 + 1];
    }

    @Override
    public void setImaginary(int n, int n2, double d) {
        this.data[n * this.numCols * 2 + n2 * 2 + 1] = d;
    }

    @Override
    public int getDataLength() {
        return this.numRows * this.numCols * 2;
    }

    public void set(CDenseMatrix64F cDenseMatrix64F) {
        this.reshape(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        int n = this.numCols * 2;
        for (int i = 0; i < this.numRows; ++i) {
            int n2 = i * this.numCols * 2;
            System.arraycopy(cDenseMatrix64F.data, n2, this.data, n2, n);
        }
    }

    public CDenseMatrix64F copy() {
        return new CDenseMatrix64F(this);
    }

    @Override
    public void set(Matrix matrix) {
        this.reshape(matrix.getNumRows(), matrix.getNumCols());
        ComplexMatrix64F complexMatrix64F = (ComplexMatrix64F)matrix;
        Complex64F complex64F = new Complex64F();
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                complexMatrix64F.get(i, j, complex64F);
                this.set(i, j, complex64F.real, complex64F.imaginary);
            }
        }
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }

    public int getRowStride() {
        return this.numCols * 2;
    }

    public void set(int n, int n2, boolean bl, double ... dArray) {
        this.reshape(n, n2);
        int n3 = n * n2 * 2;
        if (n3 > dArray.length) {
            throw new RuntimeException("Passed in array not long enough");
        }
        if (bl) {
            System.arraycopy(dArray, 0, this.data, 0, n3);
        } else {
            int n4 = 0;
            int n5 = n * 2;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.data[n4++] = dArray[j * n5 + i * 2];
                    this.data[n4++] = dArray[j * n5 + i * 2 + 1];
                }
            }
        }
    }
}

