/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.fixed;

import org.ejml.data.FixedMatrix3_64F;
import org.ejml.data.FixedMatrix3x3_64F;

public class FixedOps3 {
    public static void add(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2, FixedMatrix3x3_64F fixedMatrix3x3_64F3) {
        fixedMatrix3x3_64F3.a11 = fixedMatrix3x3_64F.a11 + fixedMatrix3x3_64F2.a11;
        fixedMatrix3x3_64F3.a12 = fixedMatrix3x3_64F.a12 + fixedMatrix3x3_64F2.a12;
        fixedMatrix3x3_64F3.a13 = fixedMatrix3x3_64F.a13 + fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a21 = fixedMatrix3x3_64F.a21 + fixedMatrix3x3_64F2.a21;
        fixedMatrix3x3_64F3.a22 = fixedMatrix3x3_64F.a22 + fixedMatrix3x3_64F2.a22;
        fixedMatrix3x3_64F3.a23 = fixedMatrix3x3_64F.a23 + fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a31 = fixedMatrix3x3_64F.a31 + fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a32 = fixedMatrix3x3_64F.a32 + fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a33 = fixedMatrix3x3_64F.a33 + fixedMatrix3x3_64F2.a33;
    }

    public static void addEquals(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2) {
        fixedMatrix3x3_64F.a11 += fixedMatrix3x3_64F2.a11;
        fixedMatrix3x3_64F.a12 += fixedMatrix3x3_64F2.a12;
        fixedMatrix3x3_64F.a13 += fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F.a21 += fixedMatrix3x3_64F2.a21;
        fixedMatrix3x3_64F.a22 += fixedMatrix3x3_64F2.a22;
        fixedMatrix3x3_64F.a23 += fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F.a31 += fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F.a32 += fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F.a33 += fixedMatrix3x3_64F2.a33;
    }

    public static void subtract(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2, FixedMatrix3x3_64F fixedMatrix3x3_64F3) {
        fixedMatrix3x3_64F3.a11 = fixedMatrix3x3_64F.a11 - fixedMatrix3x3_64F2.a11;
        fixedMatrix3x3_64F3.a12 = fixedMatrix3x3_64F.a12 - fixedMatrix3x3_64F2.a12;
        fixedMatrix3x3_64F3.a13 = fixedMatrix3x3_64F.a13 - fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a21 = fixedMatrix3x3_64F.a21 - fixedMatrix3x3_64F2.a21;
        fixedMatrix3x3_64F3.a22 = fixedMatrix3x3_64F.a22 - fixedMatrix3x3_64F2.a22;
        fixedMatrix3x3_64F3.a23 = fixedMatrix3x3_64F.a23 - fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a31 = fixedMatrix3x3_64F.a31 - fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a32 = fixedMatrix3x3_64F.a32 - fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a33 = fixedMatrix3x3_64F.a33 - fixedMatrix3x3_64F2.a33;
    }

    public static void subtractEquals(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2) {
        fixedMatrix3x3_64F.a11 -= fixedMatrix3x3_64F2.a11;
        fixedMatrix3x3_64F.a12 -= fixedMatrix3x3_64F2.a12;
        fixedMatrix3x3_64F.a13 -= fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F.a21 -= fixedMatrix3x3_64F2.a21;
        fixedMatrix3x3_64F.a22 -= fixedMatrix3x3_64F2.a22;
        fixedMatrix3x3_64F.a23 -= fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F.a31 -= fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F.a32 -= fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F.a33 -= fixedMatrix3x3_64F2.a33;
    }

    public static void transpose(FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        double d = fixedMatrix3x3_64F.a12;
        fixedMatrix3x3_64F.a12 = fixedMatrix3x3_64F.a21;
        fixedMatrix3x3_64F.a21 = d;
        d = fixedMatrix3x3_64F.a13;
        fixedMatrix3x3_64F.a13 = fixedMatrix3x3_64F.a31;
        fixedMatrix3x3_64F.a31 = d;
        d = fixedMatrix3x3_64F.a23;
        fixedMatrix3x3_64F.a23 = fixedMatrix3x3_64F.a32;
        fixedMatrix3x3_64F.a32 = d;
    }

    public static FixedMatrix3x3_64F transpose(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2) {
        if (fixedMatrix3x3_64F == null) {
            fixedMatrix3x3_64F = new FixedMatrix3x3_64F();
        }
        fixedMatrix3x3_64F2.a11 = fixedMatrix3x3_64F.a11;
        fixedMatrix3x3_64F2.a12 = fixedMatrix3x3_64F.a21;
        fixedMatrix3x3_64F2.a13 = fixedMatrix3x3_64F.a31;
        fixedMatrix3x3_64F2.a21 = fixedMatrix3x3_64F.a12;
        fixedMatrix3x3_64F2.a22 = fixedMatrix3x3_64F.a22;
        fixedMatrix3x3_64F2.a23 = fixedMatrix3x3_64F.a32;
        fixedMatrix3x3_64F2.a31 = fixedMatrix3x3_64F.a13;
        fixedMatrix3x3_64F2.a32 = fixedMatrix3x3_64F.a23;
        fixedMatrix3x3_64F2.a33 = fixedMatrix3x3_64F.a33;
        return fixedMatrix3x3_64F2;
    }

    public static void mult(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2, FixedMatrix3x3_64F fixedMatrix3x3_64F3) {
        fixedMatrix3x3_64F3.a11 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a12 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a13 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a13 + fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a23 + fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a33;
        fixedMatrix3x3_64F3.a21 = fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a22 = fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a23 = fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a13 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a23 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a33;
        fixedMatrix3x3_64F3.a31 = fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a32 = fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a33 = fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a13 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a23 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a33;
    }

    public static void multTransA(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2, FixedMatrix3x3_64F fixedMatrix3x3_64F3) {
        fixedMatrix3x3_64F3.a11 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a12 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a13 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a13 + fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a23 + fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a33;
        fixedMatrix3x3_64F3.a21 = fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a22 = fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a23 = fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a13 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a23 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a33;
        fixedMatrix3x3_64F3.a31 = fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a32 = fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a33 = fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a13 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a23 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a33;
    }

    public static void multTransAB(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2, FixedMatrix3x3_64F fixedMatrix3x3_64F3) {
        fixedMatrix3x3_64F3.a11 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a12 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a13 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a31 + fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a32 + fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a33;
        fixedMatrix3x3_64F3.a21 = fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a22 = fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a23 = fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a31 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a32 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a33;
        fixedMatrix3x3_64F3.a31 = fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a32 = fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a33 = fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a31 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a32 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a33;
    }

    public static void multTransB(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2, FixedMatrix3x3_64F fixedMatrix3x3_64F3) {
        fixedMatrix3x3_64F3.a11 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a12 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a13 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a31 + fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a32 + fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a33;
        fixedMatrix3x3_64F3.a21 = fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a22 = fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a23 = fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a31 + fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a32 + fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a33;
        fixedMatrix3x3_64F3.a31 = fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a11 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a12 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a32 = fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a21 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a22 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a33 = fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a31 + fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a32 + fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a33;
    }

    public static void mult(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3_64F fixedMatrix3_64F, FixedMatrix3_64F fixedMatrix3_64F2) {
        fixedMatrix3_64F2.a1 = fixedMatrix3x3_64F.a11 * fixedMatrix3_64F.a1 + fixedMatrix3x3_64F.a12 * fixedMatrix3_64F.a2 + fixedMatrix3x3_64F.a13 * fixedMatrix3_64F.a3;
        fixedMatrix3_64F2.a2 = fixedMatrix3x3_64F.a21 * fixedMatrix3_64F.a1 + fixedMatrix3x3_64F.a22 * fixedMatrix3_64F.a2 + fixedMatrix3x3_64F.a23 * fixedMatrix3_64F.a3;
        fixedMatrix3_64F2.a3 = fixedMatrix3x3_64F.a31 * fixedMatrix3_64F.a1 + fixedMatrix3x3_64F.a32 * fixedMatrix3_64F.a2 + fixedMatrix3x3_64F.a33 * fixedMatrix3_64F.a3;
    }

    public static void mult(FixedMatrix3_64F fixedMatrix3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3_64F fixedMatrix3_64F2) {
        fixedMatrix3_64F2.a1 = fixedMatrix3_64F.a1 * fixedMatrix3x3_64F.a11 + fixedMatrix3_64F.a2 * fixedMatrix3x3_64F.a21 + fixedMatrix3_64F.a3 * fixedMatrix3x3_64F.a31;
        fixedMatrix3_64F2.a2 = fixedMatrix3_64F.a1 * fixedMatrix3x3_64F.a12 + fixedMatrix3_64F.a2 * fixedMatrix3x3_64F.a22 + fixedMatrix3_64F.a3 * fixedMatrix3x3_64F.a32;
        fixedMatrix3_64F2.a3 = fixedMatrix3_64F.a1 * fixedMatrix3x3_64F.a13 + fixedMatrix3_64F.a2 * fixedMatrix3x3_64F.a23 + fixedMatrix3_64F.a3 * fixedMatrix3x3_64F.a33;
    }

    public static double dot(FixedMatrix3_64F fixedMatrix3_64F, FixedMatrix3_64F fixedMatrix3_64F2) {
        return fixedMatrix3_64F.a1 * fixedMatrix3_64F2.a1 + fixedMatrix3_64F.a2 * fixedMatrix3_64F2.a2 + fixedMatrix3_64F.a3 * fixedMatrix3_64F2.a3;
    }

    public static void setIdentity(FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        fixedMatrix3x3_64F.a11 = 1.0;
        fixedMatrix3x3_64F.a21 = 0.0;
        fixedMatrix3x3_64F.a31 = 0.0;
        fixedMatrix3x3_64F.a12 = 0.0;
        fixedMatrix3x3_64F.a22 = 1.0;
        fixedMatrix3x3_64F.a32 = 0.0;
        fixedMatrix3x3_64F.a13 = 0.0;
        fixedMatrix3x3_64F.a23 = 0.0;
        fixedMatrix3x3_64F.a33 = 1.0;
    }

    public static boolean invert(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2) {
        double d = 1.0 / FixedOps3.elementMaxAbs(fixedMatrix3x3_64F);
        double d2 = fixedMatrix3x3_64F.a11 * d;
        double d3 = fixedMatrix3x3_64F.a12 * d;
        double d4 = fixedMatrix3x3_64F.a13 * d;
        double d5 = fixedMatrix3x3_64F.a21 * d;
        double d6 = fixedMatrix3x3_64F.a22 * d;
        double d7 = fixedMatrix3x3_64F.a23 * d;
        double d8 = fixedMatrix3x3_64F.a31 * d;
        double d9 = fixedMatrix3x3_64F.a32 * d;
        double d10 = fixedMatrix3x3_64F.a33 * d;
        double d11 = d6 * d10 - d7 * d9;
        double d12 = -(d5 * d10 - d7 * d8);
        double d13 = d5 * d9 - d6 * d8;
        double d14 = -(d3 * d10 - d4 * d9);
        double d15 = d2 * d10 - d4 * d8;
        double d16 = -(d2 * d9 - d3 * d8);
        double d17 = d3 * d7 - d4 * d6;
        double d18 = -(d2 * d7 - d4 * d5);
        double d19 = d2 * d6 - d3 * d5;
        double d20 = (d2 * d11 + d3 * d12 + d4 * d13) / d;
        fixedMatrix3x3_64F2.a11 = d11 / d20;
        fixedMatrix3x3_64F2.a12 = d14 / d20;
        fixedMatrix3x3_64F2.a13 = d17 / d20;
        fixedMatrix3x3_64F2.a21 = d12 / d20;
        fixedMatrix3x3_64F2.a22 = d15 / d20;
        fixedMatrix3x3_64F2.a23 = d18 / d20;
        fixedMatrix3x3_64F2.a31 = d13 / d20;
        fixedMatrix3x3_64F2.a32 = d16 / d20;
        fixedMatrix3x3_64F2.a33 = d19 / d20;
        return !Double.isNaN(d20) && !Double.isInfinite(d20);
    }

    public static double det(FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        double d = fixedMatrix3x3_64F.a11 * (fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F.a33 - fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F.a32);
        double d2 = fixedMatrix3x3_64F.a12 * (fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F.a33 - fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F.a31);
        double d3 = fixedMatrix3x3_64F.a13 * (fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F.a32 - fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F.a22);
        return d - d2 + d3;
    }

    public static double trace(FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        return fixedMatrix3x3_64F.a11 + fixedMatrix3x3_64F.a21 + fixedMatrix3x3_64F.a31;
    }

    public static void diag(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3_64F fixedMatrix3_64F) {
        fixedMatrix3_64F.a1 = fixedMatrix3x3_64F.a11;
        fixedMatrix3_64F.a2 = fixedMatrix3x3_64F.a22;
        fixedMatrix3_64F.a3 = fixedMatrix3x3_64F.a33;
    }

    public static double elementMax(FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        double d = fixedMatrix3x3_64F.a11;
        d = Math.max(d, fixedMatrix3x3_64F.a12);
        d = Math.max(d, fixedMatrix3x3_64F.a13);
        d = Math.max(d, fixedMatrix3x3_64F.a21);
        d = Math.max(d, fixedMatrix3x3_64F.a22);
        d = Math.max(d, fixedMatrix3x3_64F.a23);
        d = Math.max(d, fixedMatrix3x3_64F.a31);
        d = Math.max(d, fixedMatrix3x3_64F.a32);
        d = Math.max(d, fixedMatrix3x3_64F.a33);
        return d;
    }

    public static double elementMaxAbs(FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        double d = fixedMatrix3x3_64F.a11;
        d = Math.max(d, Math.abs(fixedMatrix3x3_64F.a12));
        d = Math.max(d, Math.abs(fixedMatrix3x3_64F.a13));
        d = Math.max(d, Math.abs(fixedMatrix3x3_64F.a21));
        d = Math.max(d, Math.abs(fixedMatrix3x3_64F.a22));
        d = Math.max(d, Math.abs(fixedMatrix3x3_64F.a23));
        d = Math.max(d, Math.abs(fixedMatrix3x3_64F.a31));
        d = Math.max(d, Math.abs(fixedMatrix3x3_64F.a32));
        d = Math.max(d, Math.abs(fixedMatrix3x3_64F.a33));
        return d;
    }

    public static double elementMin(FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        double d = fixedMatrix3x3_64F.a11;
        d = Math.min(d, fixedMatrix3x3_64F.a12);
        d = Math.min(d, fixedMatrix3x3_64F.a13);
        d = Math.min(d, fixedMatrix3x3_64F.a21);
        d = Math.min(d, fixedMatrix3x3_64F.a22);
        d = Math.min(d, fixedMatrix3x3_64F.a23);
        d = Math.min(d, fixedMatrix3x3_64F.a31);
        d = Math.min(d, fixedMatrix3x3_64F.a32);
        d = Math.min(d, fixedMatrix3x3_64F.a33);
        return d;
    }

    public static double elementMinAbs(FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        double d = fixedMatrix3x3_64F.a11;
        d = Math.min(d, Math.abs(fixedMatrix3x3_64F.a12));
        d = Math.min(d, Math.abs(fixedMatrix3x3_64F.a13));
        d = Math.min(d, Math.abs(fixedMatrix3x3_64F.a21));
        d = Math.min(d, Math.abs(fixedMatrix3x3_64F.a22));
        d = Math.min(d, Math.abs(fixedMatrix3x3_64F.a23));
        d = Math.min(d, Math.abs(fixedMatrix3x3_64F.a31));
        d = Math.min(d, Math.abs(fixedMatrix3x3_64F.a32));
        d = Math.min(d, Math.abs(fixedMatrix3x3_64F.a33));
        return d;
    }

    public static void elementMult(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2) {
        fixedMatrix3x3_64F.a11 *= fixedMatrix3x3_64F2.a11;
        fixedMatrix3x3_64F.a12 *= fixedMatrix3x3_64F2.a12;
        fixedMatrix3x3_64F.a13 *= fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F.a21 *= fixedMatrix3x3_64F2.a21;
        fixedMatrix3x3_64F.a22 *= fixedMatrix3x3_64F2.a22;
        fixedMatrix3x3_64F.a23 *= fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F.a31 *= fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F.a32 *= fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F.a33 *= fixedMatrix3x3_64F2.a33;
    }

    public static void elementMult(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2, FixedMatrix3x3_64F fixedMatrix3x3_64F3) {
        fixedMatrix3x3_64F3.a11 = fixedMatrix3x3_64F.a11 * fixedMatrix3x3_64F2.a11;
        fixedMatrix3x3_64F3.a12 = fixedMatrix3x3_64F.a12 * fixedMatrix3x3_64F2.a12;
        fixedMatrix3x3_64F3.a13 = fixedMatrix3x3_64F.a13 * fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a21 = fixedMatrix3x3_64F.a21 * fixedMatrix3x3_64F2.a21;
        fixedMatrix3x3_64F3.a22 = fixedMatrix3x3_64F.a22 * fixedMatrix3x3_64F2.a22;
        fixedMatrix3x3_64F3.a23 = fixedMatrix3x3_64F.a23 * fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a31 = fixedMatrix3x3_64F.a31 * fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a32 = fixedMatrix3x3_64F.a32 * fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a33 = fixedMatrix3x3_64F.a33 * fixedMatrix3x3_64F2.a33;
    }

    public static void elementDiv(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2) {
        fixedMatrix3x3_64F.a11 /= fixedMatrix3x3_64F2.a11;
        fixedMatrix3x3_64F.a12 /= fixedMatrix3x3_64F2.a12;
        fixedMatrix3x3_64F.a13 /= fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F.a21 /= fixedMatrix3x3_64F2.a21;
        fixedMatrix3x3_64F.a22 /= fixedMatrix3x3_64F2.a22;
        fixedMatrix3x3_64F.a23 /= fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F.a31 /= fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F.a32 /= fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F.a33 /= fixedMatrix3x3_64F2.a33;
    }

    public static void elementDiv(FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2, FixedMatrix3x3_64F fixedMatrix3x3_64F3) {
        fixedMatrix3x3_64F3.a11 = fixedMatrix3x3_64F.a11 / fixedMatrix3x3_64F2.a11;
        fixedMatrix3x3_64F3.a12 = fixedMatrix3x3_64F.a12 / fixedMatrix3x3_64F2.a12;
        fixedMatrix3x3_64F3.a13 = fixedMatrix3x3_64F.a13 / fixedMatrix3x3_64F2.a13;
        fixedMatrix3x3_64F3.a21 = fixedMatrix3x3_64F.a21 / fixedMatrix3x3_64F2.a21;
        fixedMatrix3x3_64F3.a22 = fixedMatrix3x3_64F.a22 / fixedMatrix3x3_64F2.a22;
        fixedMatrix3x3_64F3.a23 = fixedMatrix3x3_64F.a23 / fixedMatrix3x3_64F2.a23;
        fixedMatrix3x3_64F3.a31 = fixedMatrix3x3_64F.a31 / fixedMatrix3x3_64F2.a31;
        fixedMatrix3x3_64F3.a32 = fixedMatrix3x3_64F.a32 / fixedMatrix3x3_64F2.a32;
        fixedMatrix3x3_64F3.a33 = fixedMatrix3x3_64F.a33 / fixedMatrix3x3_64F2.a33;
    }

    public static void scale(double d, FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        fixedMatrix3x3_64F.a11 *= d;
        fixedMatrix3x3_64F.a12 *= d;
        fixedMatrix3x3_64F.a13 *= d;
        fixedMatrix3x3_64F.a21 *= d;
        fixedMatrix3x3_64F.a22 *= d;
        fixedMatrix3x3_64F.a23 *= d;
        fixedMatrix3x3_64F.a31 *= d;
        fixedMatrix3x3_64F.a32 *= d;
        fixedMatrix3x3_64F.a33 *= d;
    }

    public static void scale(double d, FixedMatrix3x3_64F fixedMatrix3x3_64F, FixedMatrix3x3_64F fixedMatrix3x3_64F2) {
        fixedMatrix3x3_64F2.a11 = fixedMatrix3x3_64F.a11 * d;
        fixedMatrix3x3_64F2.a12 = fixedMatrix3x3_64F.a12 * d;
        fixedMatrix3x3_64F2.a13 = fixedMatrix3x3_64F.a13 * d;
        fixedMatrix3x3_64F2.a21 = fixedMatrix3x3_64F.a21 * d;
        fixedMatrix3x3_64F2.a22 = fixedMatrix3x3_64F.a22 * d;
        fixedMatrix3x3_64F2.a23 = fixedMatrix3x3_64F.a23 * d;
        fixedMatrix3x3_64F2.a31 = fixedMatrix3x3_64F.a31 * d;
        fixedMatrix3x3_64F2.a32 = fixedMatrix3x3_64F.a32 * d;
        fixedMatrix3x3_64F2.a33 = fixedMatrix3x3_64F.a33 * d;
    }

    public static void divide(FixedMatrix3x3_64F fixedMatrix3x3_64F, double d) {
        fixedMatrix3x3_64F.a11 /= d;
        fixedMatrix3x3_64F.a12 /= d;
        fixedMatrix3x3_64F.a13 /= d;
        fixedMatrix3x3_64F.a21 /= d;
        fixedMatrix3x3_64F.a22 /= d;
        fixedMatrix3x3_64F.a23 /= d;
        fixedMatrix3x3_64F.a31 /= d;
        fixedMatrix3x3_64F.a32 /= d;
        fixedMatrix3x3_64F.a33 /= d;
    }

    public static void divide(FixedMatrix3x3_64F fixedMatrix3x3_64F, double d, FixedMatrix3x3_64F fixedMatrix3x3_64F2) {
        fixedMatrix3x3_64F2.a11 = fixedMatrix3x3_64F.a11 / d;
        fixedMatrix3x3_64F2.a12 = fixedMatrix3x3_64F.a12 / d;
        fixedMatrix3x3_64F2.a13 = fixedMatrix3x3_64F.a13 / d;
        fixedMatrix3x3_64F2.a21 = fixedMatrix3x3_64F.a21 / d;
        fixedMatrix3x3_64F2.a22 = fixedMatrix3x3_64F.a22 / d;
        fixedMatrix3x3_64F2.a23 = fixedMatrix3x3_64F.a23 / d;
        fixedMatrix3x3_64F2.a31 = fixedMatrix3x3_64F.a31 / d;
        fixedMatrix3x3_64F2.a32 = fixedMatrix3x3_64F.a32 / d;
        fixedMatrix3x3_64F2.a33 = fixedMatrix3x3_64F.a33 / d;
    }

    public static void changeSign(FixedMatrix3x3_64F fixedMatrix3x3_64F) {
        fixedMatrix3x3_64F.a11 = -fixedMatrix3x3_64F.a11;
        fixedMatrix3x3_64F.a12 = -fixedMatrix3x3_64F.a12;
        fixedMatrix3x3_64F.a13 = -fixedMatrix3x3_64F.a13;
        fixedMatrix3x3_64F.a21 = -fixedMatrix3x3_64F.a21;
        fixedMatrix3x3_64F.a22 = -fixedMatrix3x3_64F.a22;
        fixedMatrix3x3_64F.a23 = -fixedMatrix3x3_64F.a23;
        fixedMatrix3x3_64F.a31 = -fixedMatrix3x3_64F.a31;
        fixedMatrix3x3_64F.a32 = -fixedMatrix3x3_64F.a32;
        fixedMatrix3x3_64F.a33 = -fixedMatrix3x3_64F.a33;
    }

    public static void fill(FixedMatrix3x3_64F fixedMatrix3x3_64F, double d) {
        fixedMatrix3x3_64F.a11 = d;
        fixedMatrix3x3_64F.a12 = d;
        fixedMatrix3x3_64F.a13 = d;
        fixedMatrix3x3_64F.a21 = d;
        fixedMatrix3x3_64F.a22 = d;
        fixedMatrix3x3_64F.a23 = d;
        fixedMatrix3x3_64F.a31 = d;
        fixedMatrix3x3_64F.a32 = d;
        fixedMatrix3x3_64F.a33 = d;
    }

    public static FixedMatrix3_64F extractRow(FixedMatrix3x3_64F fixedMatrix3x3_64F, int n, FixedMatrix3_64F fixedMatrix3_64F) {
        if (fixedMatrix3_64F == null) {
            fixedMatrix3_64F = new FixedMatrix3_64F();
        }
        switch (n) {
            case 0: {
                fixedMatrix3_64F.a1 = fixedMatrix3x3_64F.a11;
                fixedMatrix3_64F.a2 = fixedMatrix3x3_64F.a12;
                fixedMatrix3_64F.a3 = fixedMatrix3x3_64F.a13;
                break;
            }
            case 1: {
                fixedMatrix3_64F.a1 = fixedMatrix3x3_64F.a21;
                fixedMatrix3_64F.a2 = fixedMatrix3x3_64F.a22;
                fixedMatrix3_64F.a3 = fixedMatrix3x3_64F.a23;
                break;
            }
            case 2: {
                fixedMatrix3_64F.a1 = fixedMatrix3x3_64F.a31;
                fixedMatrix3_64F.a2 = fixedMatrix3x3_64F.a32;
                fixedMatrix3_64F.a3 = fixedMatrix3x3_64F.a33;
                break;
            }
            default: {
                throw new IllegalArgumentException("Out of bounds row.  row = " + n);
            }
        }
        return fixedMatrix3_64F;
    }

    public static FixedMatrix3_64F extractColumn(FixedMatrix3x3_64F fixedMatrix3x3_64F, int n, FixedMatrix3_64F fixedMatrix3_64F) {
        if (fixedMatrix3_64F == null) {
            fixedMatrix3_64F = new FixedMatrix3_64F();
        }
        switch (n) {
            case 0: {
                fixedMatrix3_64F.a1 = fixedMatrix3x3_64F.a11;
                fixedMatrix3_64F.a2 = fixedMatrix3x3_64F.a21;
                fixedMatrix3_64F.a3 = fixedMatrix3x3_64F.a31;
                break;
            }
            case 1: {
                fixedMatrix3_64F.a1 = fixedMatrix3x3_64F.a12;
                fixedMatrix3_64F.a2 = fixedMatrix3x3_64F.a22;
                fixedMatrix3_64F.a3 = fixedMatrix3x3_64F.a32;
                break;
            }
            case 2: {
                fixedMatrix3_64F.a1 = fixedMatrix3x3_64F.a13;
                fixedMatrix3_64F.a2 = fixedMatrix3x3_64F.a23;
                fixedMatrix3_64F.a3 = fixedMatrix3x3_64F.a33;
                break;
            }
            default: {
                throw new IllegalArgumentException("Out of bounds column.  column = " + n);
            }
        }
        return fixedMatrix3_64F;
    }
}

