/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;

public class VectorVectorMult {
    public static double innerProd(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        int n = d1Matrix64F.getNumElements();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += d1Matrix64F.get(i) * d1Matrix64F2.get(i);
        }
        return d;
    }

    public static double innerProdA(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        int n = d1Matrix64F2.numRows;
        int n2 = d1Matrix64F2.numCols;
        if (d1Matrix64F.getNumElements() != n) {
            throw new IllegalArgumentException("Unexpected number of elements in x");
        }
        if (d1Matrix64F3.getNumElements() != n2) {
            throw new IllegalArgumentException("Unexpected number of elements in y");
        }
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                d2 += d1Matrix64F.get(j) * d1Matrix64F2.unsafe_get(j, i);
            }
            d += d2 * d1Matrix64F3.get(i);
        }
        return d;
    }

    public static double innerProdTranA(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        int n = d1Matrix64F2.numRows;
        if (n != d1Matrix64F2.numCols) {
            throw new IllegalArgumentException("A must be square");
        }
        if (d1Matrix64F.getNumElements() != n) {
            throw new IllegalArgumentException("Unexpected number of elements in x");
        }
        if (d1Matrix64F3.getNumElements() != n) {
            throw new IllegalArgumentException("Unexpected number of elements in y");
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                d2 += d1Matrix64F.get(j) * d1Matrix64F2.unsafe_get(i, j);
            }
            d += d2 * d1Matrix64F3.get(i);
        }
        return d;
    }

    public static void outerProd(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, RowD1Matrix64F rowD1Matrix64F) {
        int n = rowD1Matrix64F.numRows;
        int n2 = rowD1Matrix64F.numCols;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d = d1Matrix64F.get(i);
            for (int j = 0; j < n2; ++j) {
                rowD1Matrix64F.set(n3++, d * d1Matrix64F2.get(j));
            }
        }
    }

    public static void addOuterProd(double d, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, RowD1Matrix64F rowD1Matrix64F) {
        int n = rowD1Matrix64F.numRows;
        int n2 = rowD1Matrix64F.numCols;
        int n3 = 0;
        if (d == 1.0) {
            for (int i = 0; i < n; ++i) {
                double d2 = d1Matrix64F.get(i);
                for (int j = 0; j < n2; ++j) {
                    rowD1Matrix64F.plus(n3++, d2 * d1Matrix64F2.get(j));
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double d3 = d1Matrix64F.get(i);
                for (int j = 0; j < n2; ++j) {
                    rowD1Matrix64F.plus(n3++, d * d3 * d1Matrix64F2.get(j));
                }
            }
        }
    }

    public static void householder(double d, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        int n;
        int n2 = d1Matrix64F.getNumElements();
        double d2 = 0.0;
        for (n = 0; n < n2; ++n) {
            d2 += d1Matrix64F.get(n) * d1Matrix64F2.get(n);
        }
        for (n = 0; n < n2; ++n) {
            d1Matrix64F3.set(n, d1Matrix64F2.get(n) + d * d1Matrix64F.get(n) * d2);
        }
    }

    public static void rank1Update(double d, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3, DenseMatrix64F denseMatrix64F4) {
        int n = denseMatrix64F2.getNumElements();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2 = denseMatrix64F2.data[i];
            int n3 = 0;
            while (n3 < n) {
                denseMatrix64F4.data[n2] = denseMatrix64F.data[n2] + d * d2 * denseMatrix64F3.data[n3];
                ++n3;
                ++n2;
            }
        }
    }

    public static void rank1Update(double d, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
        int n = denseMatrix64F2.getNumElements();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2 = denseMatrix64F2.data[i];
            for (int j = 0; j < n; ++j) {
                int n3 = n2++;
                denseMatrix64F.data[n3] = denseMatrix64F.data[n3] + d * d2 * denseMatrix64F3.data[j];
            }
        }
    }
}

