/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.linsol.ReducedRowEchelonForm;

public class RrefGaussJordanRowPivot
implements ReducedRowEchelonForm<DenseMatrix64F> {
    double tol;

    @Override
    public void setTolerance(double d) {
        this.tol = d;
    }

    @Override
    public void reduce(DenseMatrix64F denseMatrix64F, int n) {
        if (denseMatrix64F.numCols < n) {
            throw new IllegalArgumentException("The system must be at least as wide as A");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d;
            int n3;
            int n4 = -1;
            double d2 = this.tol;
            for (n3 = n2; n3 < denseMatrix64F.numRows; ++n3) {
                d = Math.abs(denseMatrix64F.data[n3 * denseMatrix64F.numCols + i]);
                if (!(d > d2)) continue;
                d2 = d;
                n4 = n3;
            }
            if (n4 == -1) continue;
            if (n2 != n4) {
                RrefGaussJordanRowPivot.swapRows(denseMatrix64F, n2, n4);
            }
            for (n3 = 0; n3 < denseMatrix64F.numRows; ++n3) {
                if (n3 == n2) continue;
                int n5 = n2 * denseMatrix64F.numCols + i;
                int n6 = n3 * denseMatrix64F.numCols + i;
                double d3 = denseMatrix64F.data[n6] / denseMatrix64F.data[n5++];
                denseMatrix64F.data[n6++] = 0.0;
                for (int j = i + 1; j < denseMatrix64F.numCols; ++j) {
                    int n7 = n6++;
                    denseMatrix64F.data[n7] = denseMatrix64F.data[n7] - denseMatrix64F.data[n5++] * d3;
                }
            }
            n3 = n2 * denseMatrix64F.numCols + i;
            d = 1.0 / denseMatrix64F.data[n3];
            denseMatrix64F.data[n3++] = 1.0;
            for (int j = i + 1; j < denseMatrix64F.numCols; ++j) {
                int n8 = n3++;
                denseMatrix64F.data[n8] = denseMatrix64F.data[n8] * d;
            }
            ++n2;
        }
    }

    protected static void swapRows(DenseMatrix64F denseMatrix64F, int n, int n2) {
        int n3 = n * denseMatrix64F.numCols;
        int n4 = n2 * denseMatrix64F.numCols;
        int n5 = 0;
        while (n5 < denseMatrix64F.numCols) {
            double d = denseMatrix64F.data[n3];
            denseMatrix64F.data[n3] = denseMatrix64F.data[n4];
            denseMatrix64F.data[n4] = d;
            ++n5;
            ++n3;
            ++n4;
        }
    }
}

