/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.chol;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionLDL_D64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.CholeskyLDLDecomposition;
import org.ejml.ops.SpecializedOps;

public class LinearSolverCholLDL_D64
extends LinearSolverAbstract_D64 {
    private CholeskyDecompositionLDL_D64 decomposer;
    private int n;
    private double[] vv;
    private double[] el;
    private double[] d;

    public LinearSolverCholLDL_D64(CholeskyDecompositionLDL_D64 choleskyDecompositionLDL_D64) {
        this.decomposer = choleskyDecompositionLDL_D64;
    }

    public LinearSolverCholLDL_D64() {
        this.decomposer = new CholeskyDecompositionLDL_D64();
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        this._setA(denseMatrix64F);
        if (this.decomposer.decompose(denseMatrix64F)) {
            this.n = denseMatrix64F.numCols;
            this.vv = this.decomposer._getVV();
            this.el = this.decomposer.getL().data;
            this.d = this.decomposer.getDiagonal();
            return true;
        }
        return false;
    }

    @Override
    public double quality() {
        return Math.abs(SpecializedOps.diagProd(this.decomposer.getL()));
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F.numCols != denseMatrix64F2.numCols && denseMatrix64F.numRows != this.n && denseMatrix64F2.numRows != this.n) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        int n = denseMatrix64F.numCols;
        double[] dArray = denseMatrix64F.data;
        double[] dArray2 = denseMatrix64F2.data;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.n; ++n2) {
                this.vv[n2] = dArray[n2 * n + i];
            }
            this.solveInternal();
            for (n2 = 0; n2 < this.n; ++n2) {
                dArray2[n2 * n + i] = this.vv[n2];
            }
        }
    }

    private void solveInternal() {
        TriangularSolver.solveL(this.el, this.vv, this.n);
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.vv[n] = this.vv[n] / this.d[i];
        }
        TriangularSolver.solveTranL(this.el, this.vv, this.n);
    }

    @Override
    public void invert(DenseMatrix64F denseMatrix64F) {
        int n;
        double d;
        int n2;
        if (denseMatrix64F.numRows != this.n || denseMatrix64F.numCols != this.n) {
            throw new RuntimeException("Unexpected matrix dimension");
        }
        double[] dArray = denseMatrix64F.data;
        for (n2 = 0; n2 < this.n; ++n2) {
            for (int i = 0; i <= n2; ++i) {
                d = n2 == i ? 1.0 : 0.0;
                for (n = n2 - 1; n >= i; --n) {
                    d -= this.el[n2 * this.n + n] * dArray[i * this.n + n];
                }
                dArray[i * this.n + n2] = d;
            }
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            double d2 = 1.0 / this.d[n2];
            for (int i = 0; i <= n2; ++i) {
                int n3 = i * this.n + n2;
                dArray[n3] = dArray[n3] * d2;
            }
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            for (int i = 0; i <= n2; ++i) {
                d = n2 < i ? 0.0 : dArray[i * this.n + n2];
                for (n = n2 + 1; n < this.n; ++n) {
                    d -= this.el[n * this.n + n2] * dArray[i * this.n + n];
                }
                double d3 = d;
                dArray[i * this.n + n2] = d3;
                dArray[n2 * this.n + i] = d3;
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public CholeskyLDLDecomposition<DenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

