/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol;

import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.linsol.LinearSolver;

public class LinearSolverSafe<T extends ReshapeMatrix>
implements LinearSolver<T> {
    private LinearSolver<T> alg;
    private T A;
    private T B;

    public LinearSolverSafe(LinearSolver<T> linearSolver) {
        this.alg = linearSolver;
    }

    @Override
    public boolean setA(T t) {
        if (this.alg.modifiesA()) {
            if (this.A == null) {
                this.A = (ReshapeMatrix)t.copy();
            } else {
                if (this.A.getNumRows() != t.getNumRows() || this.A.getNumCols() != t.getNumCols()) {
                    this.A.reshape(t.getNumRows(), t.getNumCols());
                }
                this.A.set((Matrix)t);
            }
            return this.alg.setA(this.A);
        }
        return this.alg.setA(t);
    }

    @Override
    public double quality() {
        return this.alg.quality();
    }

    @Override
    public void solve(T t, T t2) {
        if (this.alg.modifiesB()) {
            if (this.B == null) {
                this.B = (ReshapeMatrix)t.copy();
            } else {
                if (this.B.getNumRows() != t.getNumRows() || this.B.getNumCols() != t.getNumCols()) {
                    this.B.reshape(this.A.getNumRows(), t.getNumCols());
                }
                this.B.set((Matrix)t);
            }
            t = this.B;
        }
        this.alg.solve(t, t2);
    }

    @Override
    public void invert(T t) {
        this.alg.invert(t);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public <D extends DecompositionInterface> D getDecomposition() {
        return this.alg.getDecomposition();
    }
}

