/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.svd;

import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class SmartRotatorUpdate {
    DenseMatrix64F R;
    int[] mod = new int[1];

    public DenseMatrix64F getR() {
        return this.R;
    }

    public void init(DenseMatrix64F denseMatrix64F) {
        this.R = denseMatrix64F;
        CommonOps.setIdentity(denseMatrix64F);
        int n = Math.min(denseMatrix64F.numRows, denseMatrix64F.numCols);
        if (this.mod.length < n) {
            this.mod = new int[n];
        }
        for (int i = 0; i < n; ++i) {
            this.mod[i] = i;
        }
    }

    public void update(int n, int n2, double d, double d2) {
        int n3;
        this.mod[n] = n3 = Math.max(this.mod[n], this.mod[n2]);
        this.mod[n2] = n3;
        int n4 = n * this.R.numCols;
        int n5 = n2 * this.R.numCols;
        int n6 = 0;
        while (n6 < n3) {
            double d3 = this.R.data[n4];
            double d4 = this.R.data[n5];
            this.R.data[n4] = d * d3 + d2 * d4;
            this.R.data[n5] = -d2 * d3 + d * d4;
            ++n6;
            ++n4;
            ++n5;
        }
    }
}

