/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CommonOps;

public class QRDecompositionHouseholderTran_D64
implements QRDecomposition<DenseMatrix64F> {
    protected DenseMatrix64F QR;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] gammas;
    protected double gamma;
    protected double tau;
    protected boolean error;

    public void setExpectedMaxSize(int n, int n2) {
        this.numCols = n2;
        this.numRows = n;
        this.minLength = Math.min(n2, n);
        int n3 = Math.max(n2, n);
        if (this.QR == null) {
            this.QR = new DenseMatrix64F(n2, n);
            this.v = new double[n3];
            this.gammas = new double[this.minLength];
        } else {
            this.QR.reshape(n2, n, false);
        }
        if (this.v.length < n3) {
            this.v = new double[n3];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public DenseMatrix64F getQR() {
        return this.QR;
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (bl) {
            if (denseMatrix64F == null) {
                denseMatrix64F = CommonOps.identity(this.numRows, this.minLength);
            } else {
                if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CommonOps.setIdentity(denseMatrix64F);
            }
        } else if (denseMatrix64F == null) {
            denseMatrix64F = CommonOps.identity(this.numRows);
        } else {
            if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CommonOps.setIdentity(denseMatrix64F);
        }
        for (int i = this.minLength - 1; i >= 0; --i) {
            int n = i * this.numRows + i;
            double d = this.QR.data[n];
            this.QR.data[n] = 1.0;
            QrHelperFunctions_D64.rank1UpdateMultR(denseMatrix64F, this.QR.data, i * this.numRows, this.gammas[i], i, i, this.numRows, this.v);
            this.QR.data[n] = d;
        }
        return denseMatrix64F;
    }

    public void applyQ(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows != this.numRows) {
            throw new IllegalArgumentException("A must have at least " + this.numRows + " rows.");
        }
        for (int i = this.minLength - 1; i >= 0; --i) {
            int n = i * this.numRows + i;
            double d = this.QR.data[n];
            this.QR.data[n] = 1.0;
            QrHelperFunctions_D64.rank1UpdateMultR(denseMatrix64F, this.QR.data, i * this.numRows, this.gammas[i], 0, i, this.numRows, this.v);
            this.QR.data[n] = d;
        }
    }

    public void applyTranQ(DenseMatrix64F denseMatrix64F) {
        for (int i = 0; i < this.minLength; ++i) {
            int n = i * this.numRows + i;
            double d = this.QR.data[n];
            this.QR.data[n] = 1.0;
            QrHelperFunctions_D64.rank1UpdateMultR(denseMatrix64F, this.QR.data, i * this.numRows, this.gammas[i], 0, i, this.numRows, this.v);
            this.QR.data[n] = d;
        }
    }

    @Override
    public DenseMatrix64F getR(DenseMatrix64F denseMatrix64F, boolean bl) {
        int n;
        int n2;
        if (denseMatrix64F == null) {
            denseMatrix64F = bl ? new DenseMatrix64F(this.minLength, this.numCols) : new DenseMatrix64F(this.numRows, this.numCols);
        } else {
            if (bl ? denseMatrix64F.numCols != this.numCols || denseMatrix64F.numRows != this.minLength : denseMatrix64F.numCols != this.numCols || denseMatrix64F.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            for (n2 = 0; n2 < denseMatrix64F.numRows; ++n2) {
                n = Math.min(n2, denseMatrix64F.numCols);
                for (int i = 0; i < n; ++i) {
                    denseMatrix64F.unsafe_set(n2, i, 0.0);
                }
            }
        }
        for (n2 = 0; n2 < denseMatrix64F.numRows; ++n2) {
            for (n = n2; n < denseMatrix64F.numCols; ++n) {
                denseMatrix64F.unsafe_set(n2, n, this.QR.unsafe_get(n, n2));
            }
        }
        return denseMatrix64F;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.setExpectedMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        CommonOps.transpose(denseMatrix64F, this.QR);
        this.error = false;
        for (int i = 0; i < this.minLength; ++i) {
            this.householder(i);
            this.updateA(i);
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void householder(int n) {
        int n2 = n * this.numRows;
        int n3 = n2 + this.numRows;
        double d = QrHelperFunctions_D64.findMax(this.QR.data, n2 += n, this.numRows - n);
        if (d == 0.0) {
            this.gamma = 0.0;
            this.error = true;
        } else {
            this.tau = QrHelperFunctions_D64.computeTauAndDivide(n2, n3, this.QR.data, d);
            double d2 = this.QR.data[n2] + this.tau;
            QrHelperFunctions_D64.divideElements(n2 + 1, n3, this.QR.data, d2);
            this.gamma = d2 / this.tau;
            this.tau *= d;
            this.QR.data[n2] = -this.tau;
        }
        this.gammas[n] = this.gamma;
    }

    protected void updateA(int n) {
        int n2;
        double[] dArray = this.QR.data;
        int n3 = n * this.numRows + n + 1;
        int n4 = n2 + (this.numCols - n - 1) * this.numRows;
        int n5 = n3 + this.numRows - n - 1;
        for (n2 = n3 + this.numRows; n4 != n2; n2 += this.numRows) {
            double d = dArray[n2 - 1];
            int n6 = n3;
            int n7 = n2;
            while (n6 != n5) {
                d += dArray[n6++] * dArray[n7++];
            }
            int n8 = n2 - 1;
            dArray[n8] = dArray[n8] - (d *= this.gamma);
            n6 = n3;
            n7 = n2;
            while (n6 != n5) {
                int n9 = n7++;
                dArray[n9] = dArray[n9] - dArray[n6++] * d;
            }
        }
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

