/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SpecializedOps;

public abstract class LUDecompositionBase_D64
implements LUDecomposition<DenseMatrix64F> {
    protected DenseMatrix64F LU;
    protected int maxWidth = -1;
    protected int m;
    protected int n;
    protected double[] dataLU;
    protected double[] vv;
    protected int[] indx;
    protected int[] pivot;
    protected double pivsign;
    Complex64F det = new Complex64F();

    public void setExpectedMaxSize(int n, int n2) {
        this.LU = new DenseMatrix64F(n, n2);
        this.dataLU = this.LU.data;
        this.maxWidth = Math.max(n, n2);
        this.vv = new double[this.maxWidth];
        this.indx = new int[this.maxWidth];
        this.pivot = new int[this.maxWidth];
    }

    public DenseMatrix64F getLU() {
        return this.LU;
    }

    public int[] getIndx() {
        return this.indx;
    }

    public int[] getPivot() {
        return this.pivot;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    @Override
    public DenseMatrix64F getLower(DenseMatrix64F denseMatrix64F) {
        int n;
        int n2;
        int n3;
        int n4 = this.LU.numRows;
        int n5 = n3 = this.LU.numRows < this.LU.numCols ? this.LU.numRows : this.LU.numCols;
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n4, n3);
        } else {
            if (denseMatrix64F.numCols != n3 || denseMatrix64F.numRows != n4) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CommonOps.fill(denseMatrix64F, 0.0);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            denseMatrix64F.set(n2, n2, 1.0);
            for (n = 0; n < n2; ++n) {
                denseMatrix64F.set(n2, n, this.LU.get(n2, n));
            }
        }
        if (n4 > n3) {
            for (n2 = n3; n2 < n4; ++n2) {
                for (n = 0; n < n3; ++n) {
                    denseMatrix64F.set(n2, n, this.LU.get(n2, n));
                }
            }
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getUpper(DenseMatrix64F denseMatrix64F) {
        int n = this.LU.numRows < this.LU.numCols ? this.LU.numRows : this.LU.numCols;
        int n2 = this.LU.numCols;
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n, n2);
        } else {
            if (denseMatrix64F.numCols != n2 || denseMatrix64F.numRows != n) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CommonOps.fill(denseMatrix64F, 0.0);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n2; ++j) {
                denseMatrix64F.set(i, j, this.LU.get(i, j));
            }
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getPivot(DenseMatrix64F denseMatrix64F) {
        return SpecializedOps.pivotMatrix(denseMatrix64F, this.pivot, this.LU.numRows, false);
    }

    protected void decomposeCommonInit(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows > this.maxWidth || denseMatrix64F.numCols > this.maxWidth) {
            this.setExpectedMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        }
        this.m = denseMatrix64F.numRows;
        this.n = denseMatrix64F.numCols;
        this.LU.set(denseMatrix64F);
        for (int i = 0; i < this.m; ++i) {
            this.pivot[i] = i;
        }
        this.pivsign = 1.0;
    }

    @Override
    public boolean isSingular() {
        for (int i = 0; i < this.m; ++i) {
            if (!(Math.abs(this.dataLU[i * this.n + i]) < UtilEjml.EPS)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Complex64F computeDeterminant() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        double d = this.pivsign;
        int n = this.m * this.n;
        for (int i = 0; i < n; i += this.n + 1) {
            d *= this.dataLU[i];
        }
        this.det.real = d;
        this.det.imaginary = 0.0;
        return this.det;
    }

    public double quality() {
        return SpecializedOps.qualityTriangular(this.LU);
    }

    public void _solveVectorInternal(double[] dArray) {
        int n = 0;
        for (int i = 0; i < this.n; ++i) {
            int n2 = this.indx[i];
            double d = dArray[n2];
            dArray[n2] = dArray[i];
            if (n != 0) {
                int n3 = i * this.n + n - 1;
                for (int j = n - 1; j < i; ++j) {
                    d -= this.dataLU[n3++] * dArray[j];
                }
            } else if (d != 0.0) {
                n = i + 1;
            }
            dArray[i] = d;
        }
        TriangularSolver.solveU(this.dataLU, dArray, this.n);
    }

    public double[] _getVV() {
        return this.vv;
    }
}

