/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig.symm;

import java.util.Random;
import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.eig.EigenvalueSmall;
import org.ejml.data.DenseMatrix64F;

public class SymmetricQREigenHelper {
    protected Random rand = new Random(3434270L);
    protected int steps;
    protected int numExceptional;
    protected int lastExceptional;
    protected EigenvalueSmall eigenSmall = new EigenvalueSmall();
    protected DenseMatrix64F Q;
    protected int N;
    protected double[] diag;
    protected double[] off;
    protected int x1;
    protected int x2;
    protected int[] splits = new int[1];
    protected int numSplits;
    private double bulge;
    private double c;
    private double s;
    private double c2;
    private double s2;
    private double cs;

    public void printMatrix() {
        int n;
        System.out.print("Off Diag[ ");
        for (n = 0; n < this.N - 1; ++n) {
            System.out.printf("%5.2f ", this.off[n]);
        }
        System.out.println();
        System.out.print("    Diag[ ");
        for (n = 0; n < this.N; ++n) {
            System.out.printf("%5.2f ", this.diag[n]);
        }
        System.out.println();
    }

    public void setQ(DenseMatrix64F denseMatrix64F) {
        this.Q = denseMatrix64F;
    }

    public void incrementSteps() {
        ++this.steps;
    }

    public void init(double[] dArray, double[] dArray2, int n) {
        this.reset(n);
        this.diag = dArray;
        this.off = dArray2;
    }

    public double[] swapDiag(double[] dArray) {
        double[] dArray2 = this.diag;
        this.diag = dArray;
        return dArray2;
    }

    public double[] swapOff(double[] dArray) {
        double[] dArray2 = this.off;
        this.off = dArray;
        return dArray2;
    }

    public void reset(int n) {
        this.N = n;
        this.diag = null;
        this.off = null;
        if (this.splits.length < n) {
            this.splits = new int[n];
        }
        this.numSplits = 0;
        this.x1 = 0;
        this.x2 = n - 1;
        this.lastExceptional = 0;
        this.numExceptional = 0;
        this.steps = 0;
        this.Q = null;
    }

    public double[] copyDiag(double[] dArray) {
        if (dArray == null || dArray.length < this.N) {
            dArray = new double[this.N];
        }
        System.arraycopy(this.diag, 0, dArray, 0, this.N);
        return dArray;
    }

    public double[] copyOff(double[] dArray) {
        if (dArray == null || dArray.length < this.N - 1) {
            dArray = new double[this.N - 1];
        }
        System.arraycopy(this.off, 0, dArray, 0, this.N - 1);
        return dArray;
    }

    public double[] copyEigenvalues(double[] dArray) {
        if (dArray == null || dArray.length < this.N) {
            dArray = new double[this.N];
        }
        System.arraycopy(this.diag, 0, dArray, 0, this.N);
        return dArray;
    }

    public void setSubmatrix(int n, int n2) {
        this.x1 = n;
        this.x2 = n2;
    }

    protected boolean isZero(int n) {
        double d = Math.abs(this.diag[n]) + Math.abs(this.diag[n + 1]);
        return Math.abs(this.off[n]) <= d * UtilEjml.EPS;
    }

    protected void performImplicitSingleStep(double d, boolean bl) {
        if (this.x2 - this.x1 == 1) {
            this.createBulge2by2(this.x1, d, bl);
        } else {
            this.createBulge(this.x1, d, bl);
            for (int i = this.x1; i < this.x2 - 2 && this.bulge != 0.0; ++i) {
                this.removeBulge(i);
            }
            if (this.bulge != 0.0) {
                this.removeBulgeEnd(this.x2 - 2);
            }
        }
    }

    protected void updateQ(int n, int n2, double d, double d2) {
        int n3 = n * this.N;
        int n4 = n2 * this.N;
        int n5 = n3 + this.N;
        while (n3 < n5) {
            double d3 = this.Q.data[n3];
            double d4 = this.Q.data[n4];
            this.Q.data[n3++] = d * d3 + d2 * d4;
            this.Q.data[n4++] = -d2 * d3 + d * d4;
        }
    }

    protected void createBulge(int n, double d, boolean bl) {
        double d2 = this.diag[n];
        double d3 = this.diag[n + 1];
        double d4 = this.off[n];
        double d5 = this.off[n + 1];
        if (bl) {
            this.c = Math.cos(d);
            this.s = Math.sin(d);
            this.c2 = this.c * this.c;
            this.s2 = this.s * this.s;
            this.cs = this.c * this.s;
        } else {
            this.computeRotation(d2 - d, d4);
        }
        this.diag[n] = this.c2 * d2 + 2.0 * this.cs * d4 + this.s2 * d3;
        this.diag[n + 1] = this.c2 * d3 - 2.0 * this.cs * d4 + this.s2 * d2;
        this.off[n] = d4 * (this.c2 - this.s2) + this.cs * (d3 - d2);
        this.off[n + 1] = this.c * d5;
        this.bulge = this.s * d5;
        if (this.Q != null) {
            this.updateQ(n, n + 1, this.c, this.s);
        }
    }

    protected void createBulge2by2(int n, double d, boolean bl) {
        double d2 = this.diag[n];
        double d3 = this.diag[n + 1];
        double d4 = this.off[n];
        if (bl) {
            this.c = Math.cos(d);
            this.s = Math.sin(d);
            this.c2 = this.c * this.c;
            this.s2 = this.s * this.s;
            this.cs = this.c * this.s;
        } else {
            this.computeRotation(d2 - d, d4);
        }
        this.diag[n] = this.c2 * d2 + 2.0 * this.cs * d4 + this.s2 * d3;
        this.diag[n + 1] = this.c2 * d3 - 2.0 * this.cs * d4 + this.s2 * d2;
        this.off[n] = d4 * (this.c2 - this.s2) + this.cs * (d3 - d2);
        if (this.Q != null) {
            this.updateQ(n, n + 1, this.c, this.s);
        }
    }

    private void computeRotation(double d, double d2) {
        if (Math.abs(d2) > Math.abs(d)) {
            double d3 = d / d2;
            double d4 = 1.0 + d3 * d3;
            double d5 = Math.sqrt(d4);
            this.s2 = 1.0 / d4;
            this.c2 = d3 * d3 / d4;
            this.cs = d3 / d4;
            this.s = 1.0 / d5;
            this.c = d3 / d5;
        } else {
            double d6 = d2 / d;
            double d7 = 1.0 + d6 * d6;
            double d8 = Math.sqrt(d7);
            this.c2 = 1.0 / d7;
            this.s2 = d6 * d6 / d7;
            this.cs = d6 / d7;
            this.c = 1.0 / d8;
            this.s = d6 / d8;
        }
    }

    protected void removeBulge(int n) {
        double d = this.diag[n + 1];
        double d2 = this.diag[n + 2];
        double d3 = this.off[n];
        double d4 = this.off[n + 1];
        double d5 = this.off[n + 2];
        this.computeRotation(d3, this.bulge);
        this.diag[n + 1] = this.c2 * d + 2.0 * this.cs * d4 + this.s2 * d2;
        this.diag[n + 2] = this.c2 * d2 - 2.0 * this.cs * d4 + this.s2 * d;
        this.off[n] = this.c * d3 + this.s * this.bulge;
        this.off[n + 1] = d4 * (this.c2 - this.s2) + this.cs * (d2 - d);
        this.off[n + 2] = this.c * d5;
        this.bulge = this.s * d5;
        if (this.Q != null) {
            this.updateQ(n + 1, n + 2, this.c, this.s);
        }
    }

    protected void removeBulgeEnd(int n) {
        double d = this.diag[n + 1];
        double d2 = this.off[n];
        double d3 = this.off[n + 1];
        double d4 = this.diag[n + 2];
        this.computeRotation(d2, this.bulge);
        this.diag[n + 1] = this.c2 * d + 2.0 * this.cs * d3 + this.s2 * d4;
        this.diag[n + 2] = this.c2 * d4 - 2.0 * this.cs * d3 + this.s2 * d;
        this.off[n] = this.c * d2 + this.s * this.bulge;
        this.off[n + 1] = d3 * (this.c2 - this.s2) + this.cs * (d4 - d);
        if (this.Q != null) {
            this.updateQ(n + 1, n + 2, this.c, this.s);
        }
    }

    protected void eigenvalue2by2(int n) {
        double d;
        double d2 = this.diag[n];
        double d3 = this.off[n];
        double d4 = this.diag[n + 1];
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        double d7 = Math.abs(d4);
        double d8 = d = d5 > d6 ? d5 : d6;
        if (d7 > d) {
            d = d7;
        }
        if (d == 0.0) {
            this.off[n] = 0.0;
            this.diag[n] = 0.0;
            this.diag[n + 1] = 0.0;
            return;
        }
        this.eigenSmall.symm2x2_fast(d2 /= d, d3 /= d, d4 /= d);
        this.off[n] = 0.0;
        this.diag[n] = d * this.eigenSmall.value0.real;
        this.diag[n + 1] = d * this.eigenSmall.value1.real;
    }

    public void exceptionalShift() {
        ++this.numExceptional;
        double d = 0.05 * (double)this.numExceptional;
        if (d > 1.0) {
            d = 1.0;
        }
        double d2 = 2.0 * (this.rand.nextDouble() - 0.5) * d;
        this.performImplicitSingleStep(d2, true);
        this.lastExceptional = this.steps;
    }

    public boolean nextSplit() {
        if (this.numSplits == 0) {
            return false;
        }
        this.x2 = this.splits[--this.numSplits];
        this.x1 = this.numSplits > 0 ? this.splits[this.numSplits - 1] + 1 : 0;
        return true;
    }

    public double computeShift() {
        if (this.x2 - this.x1 >= 1) {
            return this.computeWilkinsonShift();
        }
        return this.diag[this.x2];
    }

    public double computeWilkinsonShift() {
        double d;
        double d2 = this.diag[this.x2 - 1];
        double d3 = this.off[this.x2 - 1];
        double d4 = this.diag[this.x2];
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        double d7 = Math.abs(d4);
        double d8 = d = d5 > d6 ? d5 : d6;
        if (d7 > d) {
            d = d7;
        }
        if (d == 0.0) {
            throw new RuntimeException("this should never happen");
        }
        this.eigenSmall.symm2x2_fast(d2 /= d, d3 /= d, d4 /= d);
        double d9 = Math.abs(this.eigenSmall.value0.real - d4);
        double d10 = Math.abs(this.eigenSmall.value1.real - d4);
        if (d9 < d10) {
            return d * this.eigenSmall.value0.real;
        }
        return d * this.eigenSmall.value1.real;
    }

    public int getMatrixSize() {
        return this.N;
    }

    public void resetSteps() {
        this.steps = 0;
        this.lastExceptional = 0;
    }
}

