/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.bidiagonal;

import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.SpecializedOps;
import org.ejml.simple.SimpleMatrix;

public class BidiagonalDecompositionNaive_D64 {
    private SimpleMatrix U;
    private SimpleMatrix B;
    private SimpleMatrix V;
    private int m;
    private int n;
    private int min;
    DenseMatrix64F u;

    public SimpleMatrix getU() {
        return this.U;
    }

    public SimpleMatrix getB() {
        return this.B;
    }

    public SimpleMatrix getV() {
        return this.V;
    }

    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.init(denseMatrix64F);
        return this._decompose();
    }

    protected void init(DenseMatrix64F denseMatrix64F) {
        this.m = denseMatrix64F.numRows;
        this.n = denseMatrix64F.numCols;
        this.min = Math.min(this.m, this.n);
        this.U = SimpleMatrix.identity(this.m);
        this.B = new SimpleMatrix(denseMatrix64F);
        this.V = SimpleMatrix.identity(this.n);
        int n = Math.max(this.m, this.n);
        this.u = new DenseMatrix64F(n, 1);
    }

    private boolean _decompose() {
        for (int i = 0; i < this.min; ++i) {
            this.computeU(i);
            this.computeV(i);
        }
        return true;
    }

    protected void computeU(int n) {
        this.u.reshape(this.m, 1, false);
        double[] dArray = this.u.data;
        double d = 0.0;
        for (int i = n; i < this.m; ++i) {
            double d2 = dArray[i] = this.B.get(i, n);
            if (!((d2 = Math.abs(d2)) > d)) continue;
            d = d2;
        }
        if (d > 0.0) {
            double d3 = 0.0;
            int n2 = n;
            while (n2 < this.m) {
                int n3 = n2++;
                double d4 = dArray[n3] / d;
                dArray[n3] = d4;
                double d5 = d4;
                d3 += d5 * d5;
            }
            d3 = Math.sqrt(d3);
            if (dArray[n] < 0.0) {
                d3 = -d3;
            }
            double d6 = dArray[n] + d3;
            dArray[n] = 1.0;
            int n4 = n + 1;
            while (n4 < this.m) {
                int n5 = n4++;
                dArray[n5] = dArray[n5] / d6;
            }
            SimpleMatrix simpleMatrix = SimpleMatrix.wrap(SpecializedOps.createReflector(this.u, d6 / d3));
            this.U = this.U.mult(simpleMatrix);
            this.B = simpleMatrix.mult(this.B);
        }
    }

    protected void computeV(int n) {
        this.u.reshape(this.n, 1, false);
        this.u.zero();
        double[] dArray = this.u.data;
        double d = 0.0;
        for (int i = n + 1; i < this.n; ++i) {
            double d2 = dArray[i] = this.B.get(n, i);
            if (!((d2 = Math.abs(d2)) > d)) continue;
            d = d2;
        }
        if (d > 0.0) {
            double d3 = 0.0;
            int n2 = n + 1;
            while (n2 < this.n) {
                int n3 = n2++;
                double d4 = dArray[n3] / d;
                dArray[n3] = d4;
                double d5 = d4;
                d3 += d5 * d5;
            }
            d3 = Math.sqrt(d3);
            if (dArray[n + 1] < 0.0) {
                d3 = -d3;
            }
            double d6 = dArray[n + 1] + d3;
            dArray[n + 1] = 1.0;
            int n4 = n + 2;
            while (n4 < this.n) {
                int n5 = n4++;
                dArray[n5] = dArray[n5] / d6;
            }
            SimpleMatrix simpleMatrix = SimpleMatrix.wrap(SpecializedOps.createReflector(this.u, d6 / d3));
            this.V = this.V.mult(simpleMatrix);
            this.B = this.B.mult(simpleMatrix);
        }
    }
}

