/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.qr;

import org.ejml.alg.dense.decompose.qr.QrHelperFunctions_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CCommonOps;

public class QRDecompositionHouseholderTran_CD64
implements QRDecomposition<CDenseMatrix64F> {
    protected CDenseMatrix64F QR;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] gammas;
    protected double gamma;
    protected Complex64F tau = new Complex64F();
    protected boolean error;

    public void setExpectedMaxSize(int n, int n2) {
        this.numCols = n2;
        this.numRows = n;
        this.minLength = Math.min(n2, n);
        int n3 = Math.max(n2, n);
        if (this.QR == null) {
            this.QR = new CDenseMatrix64F(n2, n);
            this.v = new double[n3 * 2];
            this.gammas = new double[this.minLength];
        } else {
            this.QR.reshape(n2, n);
        }
        if (this.v.length < n3 * 2) {
            this.v = new double[n3 * 2];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public CDenseMatrix64F getQR() {
        return this.QR;
    }

    @Override
    public CDenseMatrix64F getQ(CDenseMatrix64F cDenseMatrix64F, boolean bl) {
        if (bl) {
            if (cDenseMatrix64F == null) {
                cDenseMatrix64F = CCommonOps.identity(this.numRows, this.minLength);
            } else {
                if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CCommonOps.setIdentity(cDenseMatrix64F);
            }
        } else if (cDenseMatrix64F == null) {
            cDenseMatrix64F = CCommonOps.identity(this.numRows);
        } else {
            if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CCommonOps.setIdentity(cDenseMatrix64F);
        }
        for (int i = this.minLength - 1; i >= 0; --i) {
            int n = (i * this.numRows + i) * 2;
            double d = this.QR.data[n];
            double d2 = this.QR.data[n + 1];
            this.QR.data[n] = 1.0;
            this.QR.data[n + 1] = 0.0;
            QrHelperFunctions_CD64.rank1UpdateMultR(cDenseMatrix64F, this.QR.data, i * this.numRows, this.gammas[i], i, i, this.numRows, this.v);
            this.QR.data[n] = d;
            this.QR.data[n + 1] = d2;
        }
        return cDenseMatrix64F;
    }

    public void applyQ(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numRows != this.numRows) {
            throw new IllegalArgumentException("A must have at least " + this.numRows + " rows.");
        }
        for (int i = this.minLength - 1; i >= 0; --i) {
            int n = (i * this.numRows + i) * 2;
            double d = this.QR.data[n];
            double d2 = this.QR.data[n + 1];
            this.QR.data[n] = 1.0;
            this.QR.data[n + 1] = 0.0;
            QrHelperFunctions_CD64.rank1UpdateMultR(cDenseMatrix64F, this.QR.data, i * this.numRows, this.gammas[i], 0, i, this.numRows, this.v);
            this.QR.data[n] = d;
            this.QR.data[n + 1] = d2;
        }
    }

    public void applyTranQ(CDenseMatrix64F cDenseMatrix64F) {
        for (int i = 0; i < this.minLength; ++i) {
            int n = (i * this.numRows + i) * 2;
            double d = this.QR.data[n];
            double d2 = this.QR.data[n + 1];
            this.QR.data[n] = 1.0;
            this.QR.data[n + 1] = 0.0;
            QrHelperFunctions_CD64.rank1UpdateMultR(cDenseMatrix64F, this.QR.data, i * this.numRows, this.gammas[i], 0, i, this.numRows, this.v);
            this.QR.data[n] = d;
            this.QR.data[n + 1] = d2;
        }
    }

    @Override
    public CDenseMatrix64F getR(CDenseMatrix64F cDenseMatrix64F, boolean bl) {
        int n;
        int n2;
        int n3;
        if (cDenseMatrix64F == null) {
            cDenseMatrix64F = bl ? new CDenseMatrix64F(this.minLength, this.numCols) : new CDenseMatrix64F(this.numRows, this.numCols);
        } else {
            if (bl ? cDenseMatrix64F.numCols != this.numCols || cDenseMatrix64F.numRows != this.minLength : cDenseMatrix64F.numCols != this.numCols || cDenseMatrix64F.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            for (n3 = 0; n3 < cDenseMatrix64F.numRows; ++n3) {
                n2 = Math.min(n3, cDenseMatrix64F.numCols);
                for (n = 0; n < n2; ++n) {
                    cDenseMatrix64F.set(n3, n, 0.0, 0.0);
                }
            }
        }
        for (n3 = 0; n3 < cDenseMatrix64F.numRows; ++n3) {
            for (n2 = n3; n2 < cDenseMatrix64F.numCols; ++n2) {
                n = this.QR.getIndex(n2, n3);
                cDenseMatrix64F.set(n3, n2, this.QR.data[n], this.QR.data[n + 1]);
            }
        }
        return cDenseMatrix64F;
    }

    @Override
    public boolean decompose(CDenseMatrix64F cDenseMatrix64F) {
        this.setExpectedMaxSize(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        CCommonOps.transpose(cDenseMatrix64F, this.QR);
        this.error = false;
        for (int i = 0; i < this.minLength; ++i) {
            this.householder(i);
            this.updateA(i);
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void householder(int n) {
        int n2 = n * this.numRows;
        int n3 = n2 + this.numRows;
        double d = QrHelperFunctions_CD64.findMax(this.QR.data, n2 += n, this.numRows - n);
        if (d == 0.0) {
            this.gamma = 0.0;
            this.error = true;
        } else {
            this.gamma = QrHelperFunctions_CD64.computeTauGammaAndDivide(n2, n3, this.QR.data, d, this.tau);
            double d2 = this.QR.data[n2 * 2] + this.tau.real;
            double d3 = this.QR.data[n2 * 2 + 1] + this.tau.imaginary;
            QrHelperFunctions_CD64.divideElements(n2 + 1, n3, this.QR.data, 0, d2, d3);
            this.tau.real *= d;
            this.tau.imaginary *= d;
            this.QR.data[n2 * 2] = -this.tau.real;
            this.QR.data[n2 * 2 + 1] = -this.tau.imaginary;
        }
        this.gammas[n] = this.gamma;
    }

    protected void updateA(int n) {
        double[] dArray = this.QR.data;
        int n2 = n * this.numRows + n + 1;
        int n3 = n2 + this.numRows;
        int n4 = 2 * (n3 + (this.numCols - n - 1) * this.numRows);
        int n5 = 2 * (n2 + this.numRows - n - 1);
        n2 = 2 * n2;
        for (n3 = 2 * n3; n4 != n3; n3 += this.numRows * 2) {
            double d;
            double d2;
            double d3 = dArray[n3 - 2];
            double d4 = dArray[n3 - 1];
            int n6 = n2;
            int n7 = n3;
            while (n6 != n5) {
                d2 = dArray[n6++];
                d = -dArray[n6++];
                double d5 = dArray[n7++];
                double d6 = dArray[n7++];
                d3 += d2 * d5 - d * d6;
                d4 += d2 * d6 + d * d5;
            }
            int n8 = n3 - 2;
            dArray[n8] = dArray[n8] - (d3 *= this.gamma);
            int n9 = n3 - 1;
            dArray[n9] = dArray[n9] - (d4 *= this.gamma);
            n6 = n2;
            n7 = n3;
            while (n6 != n5) {
                d2 = dArray[n6++];
                d = dArray[n6++];
                int n10 = n7++;
                dArray[n10] = dArray[n10] - (d2 * d3 - d * d4);
                int n11 = n7++;
                dArray[n11] = dArray[n11] - (d2 * d4 + d * d3);
            }
        }
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

