/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.lu;

import org.ejml.alg.dense.decompose.lu.LUDecompositionBase_CD64;
import org.ejml.data.CDenseMatrix64F;

public class LUDecompositionAlt_CD64
extends LUDecompositionBase_CD64 {
    @Override
    public boolean decompose(CDenseMatrix64F cDenseMatrix64F) {
        this.decomposeCommonInit(cDenseMatrix64F);
        double[] dArray = this.vv;
        for (int i = 0; i < this.n; ++i) {
            int n;
            double d;
            double d2;
            int n2;
            for (n2 = 0; n2 < this.m; ++n2) {
                dArray[n2 * 2] = this.dataLU[n2 * this.stride + i * 2];
                dArray[n2 * 2 + 1] = this.dataLU[n2 * this.stride + i * 2 + 1];
            }
            for (n2 = 0; n2 < this.m; ++n2) {
                int n3 = n2 * this.stride;
                int n4 = n2 < i ? n2 : i;
                double d3 = 0.0;
                double d4 = 0.0;
                for (int j = 0; j < n4; ++j) {
                    double d5 = this.dataLU[n3 + j * 2];
                    d2 = this.dataLU[n3 + j * 2 + 1];
                    d = dArray[j * 2];
                    double d6 = dArray[j * 2 + 1];
                    d3 += d5 * d - d2 * d6;
                    d4 += d5 * d6 + d2 * d;
                }
                int n5 = n2 * 2;
                double d7 = dArray[n5] - d3;
                dArray[n5] = d7;
                this.dataLU[n3 + i * 2] = d7;
                int n6 = n2 * 2 + 1;
                double d8 = dArray[n6] - d4;
                dArray[n6] = d8;
                this.dataLU[n3 + i * 2 + 1] = d8;
            }
            n2 = i;
            double d9 = LUDecompositionAlt_CD64.mag(dArray, n2 * 2);
            for (n = i + 1; n < this.m; ++n) {
                double d10 = LUDecompositionAlt_CD64.mag(dArray, n * 2);
                if (!(d10 > d9)) continue;
                n2 = n;
                d9 = d10;
            }
            if (n2 != i) {
                n = n2 * this.stride;
                int n7 = i * this.stride;
                int n8 = n + this.stride;
                while (n < n8) {
                    double d11 = this.dataLU[n];
                    this.dataLU[n] = this.dataLU[n7];
                    this.dataLU[n7] = d11;
                    ++n;
                    ++n7;
                }
                int n9 = this.pivot[n2];
                this.pivot[n2] = this.pivot[i];
                this.pivot[i] = n9;
                this.pivsign = -this.pivsign;
            }
            this.indx[i] = n2;
            if (i >= this.m) continue;
            double d12 = this.dataLU[i * this.stride + i * 2];
            double d13 = this.dataLU[i * this.stride + i * 2 + 1];
            double d14 = d12 * d12 + d13 * d13;
            if (d12 == 0.0 && d13 == 0.0) continue;
            for (int j = i + 1; j < this.m; ++j) {
                d2 = this.dataLU[j * this.stride + i * 2];
                d = this.dataLU[j * this.stride + i * 2 + 1];
                this.dataLU[j * this.stride + i * 2] = (d2 * d12 + d * d13) / d14;
                this.dataLU[j * this.stride + i * 2 + 1] = (d * d12 - d2 * d13) / d14;
            }
        }
        return true;
    }

    private static double mag(double[] dArray, int n) {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        return d * d + d2 * d2;
    }
}

