/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.decomposition.chol;

import org.ejml.data.D1Submatrix64F;

public class InnerCholesky_B64 {
    public static boolean upper(D1Submatrix64F d1Submatrix64F) {
        int n = d1Submatrix64F.row1 - d1Submatrix64F.row0;
        int n2 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + d1Submatrix64F.col0 * n;
        return InnerCholesky_B64.upper(d1Submatrix64F.original.data, n2, n);
    }

    public static boolean lower(D1Submatrix64F d1Submatrix64F) {
        int n = d1Submatrix64F.row1 - d1Submatrix64F.row0;
        int n2 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + d1Submatrix64F.col0 * n;
        return InnerCholesky_B64.lower(d1Submatrix64F.original.data, n2, n);
    }

    public static boolean upper(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = i; j < n2; ++j) {
                double d2 = dArray[n + i * n2 + j];
                for (int k = 0; k < i; ++k) {
                    d2 -= dArray[n + k * n2 + i] * dArray[n + k * n2 + j];
                }
                if (i == j) {
                    double d3;
                    if (d2 <= 0.0) {
                        return false;
                    }
                    dArray[n + i * n2 + i] = d3 = Math.sqrt(d2);
                    d = 1.0 / d3;
                    continue;
                }
                dArray[n + i * n2 + j] = d2 * d;
            }
        }
        return true;
    }

    public static boolean lower(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = i; j < n2; ++j) {
                double d2 = dArray[n + j * n2 + i];
                for (int k = 0; k < i; ++k) {
                    d2 -= dArray[n + i * n2 + k] * dArray[n + j * n2 + k];
                }
                if (i == j) {
                    double d3;
                    if (d2 <= 0.0) {
                        return false;
                    }
                    dArray[n + i * n2 + i] = d3 = Math.sqrt(d2);
                    d = 1.0 / d3;
                    continue;
                }
                dArray[n + j * n2 + i] = d2 * d;
            }
        }
        return true;
    }
}

